/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import javax.swing.Action;
import javax.swing.JButton;
import oracle.bali.inspector.AbstractCustomEditorButton;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.editor.SinglePropertyInfo;

public final class ActionContext {
    private static final String ACTION_CONTEXT_PROPERTY = ActionContext.class.getName();
    private Component editorComponent;
    private SinglePropertyInfo property;
    private Component owner;

    public static ActionContext contextFrom(Action action) {
        return (ActionContext)action.getValue(ACTION_CONTEXT_PROPERTY);
    }

    public static Action updateContextIn(Action action, ActionContext context) {
        action.putValue(ACTION_CONTEXT_PROPERTY, context);
        return action;
    }

    @Deprecated
    public ActionContext(PropertyEditorFactory2 propertyEditorFactory, PropertyModel propertyModel, int propertyModelRow, Component editorComponent, JButton customEditorButton) {
        if (!(customEditorButton instanceof AbstractCustomEditorButton)) {
            throw new IllegalArgumentException("customEditorButton should be an instance of AbstractCustomEditorButton");
        }
        this.editorComponent = editorComponent;
        this.property = (AbstractCustomEditorButton)customEditorButton;
        this.owner(customEditorButton);
    }

    public ActionContext(Component editorComponent, AbstractCustomEditorButton button) {
        this.editorComponent = editorComponent;
        this.property = button;
        this.owner(button);
    }

    public ActionContext(Component editorComponent, SinglePropertyInfo property) {
        this.editorComponent = editorComponent;
        this.property = property;
        if (property instanceof Component) {
            this.owner((Component)((Object)property));
        }
    }

    public void owner(Component owner) {
        this.owner = owner;
    }

    public Component owner() {
        return this.owner;
    }

    public void updateModelWithEditorFactoryValue() {
        try {
            PropertyModel propertyModel = this.propertyModel();
            int row = this.propertyModelRow();
            PropertyEditorFactory2 propertyEditorFactory = this.propertyEditorFactory();
            if (propertyModel == null || propertyEditorFactory == null) {
                return;
            }
            propertyModel.setPropertyValue(row, propertyEditorFactory.getValue());
        }
        catch (Throwable t) {
            System.err.println("Exception setting property value: " + t);
        }
    }

    public void dispose() {
        this.property = null;
    }

    public PropertyEditorFactory2 propertyEditorFactory() {
        if (this.property == null) {
            return null;
        }
        return this.property.getPropertyEditorFactory();
    }

    public PropertyModel propertyModel() {
        if (this.property == null) {
            return null;
        }
        return this.property.getPropertyModel();
    }

    public int propertyModelRow() {
        if (this.property == null) {
            return -1;
        }
        return this.property.getPropertyModelRow();
    }

    public Component editorComponent() {
        return this.editorComponent;
    }

    public JButton customEditorButton() {
        if (this.property instanceof JButton) {
            return (JButton)((Object)this.property);
        }
        return null;
    }
}

