/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util.search;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

abstract class SearchTable
extends GenericTable {
    private final TableCellRenderer m_renderer = new SearchTableCellRenderer();

    SearchTable(TableModel model) {
        super(model);
        this.setSelectionMode(2);
        this.setAutoResizeMode(3);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public final void mouseReleased(MouseEvent e) {
                SearchTable table = SearchTable.this;
                int row = ((JTable)((Object)table)).rowAtPoint(e.getPoint());
                if (row >= 0 && !((JTable)((Object)table)).isRowSelected(row)) {
                    ((JTable)((Object)table)).setRowSelectionInterval(row, row);
                }
                ((JComponent)((Object)table)).requestFocus();
            }
        });
        this.setEnabled(false);
    }

    public final boolean isCellEditable(int row, int column) {
        return false;
    }

    public final TableCellRenderer getCellRenderer(int row, int column) {
        return this.m_renderer;
    }

    final Element[] getSelectedElements() {
        ArrayList<Object> selection = new ArrayList<Object>();
        int[] rows = this.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            Object o = this.getModel().getValueAt(rows[i], 0);
            if (o == null || !(o instanceof Element)) continue;
            selection.add(o);
        }
        return selection.toArray(new Element[0]);
    }

    protected abstract boolean isViewActive();

    private final class SearchTableCellRenderer
    extends DefaultTableCellRenderer {
        private SearchTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
            this.setIcon(null);
            if (value instanceof Displayable) {
                Icon icon = ((Displayable)value).getIcon();
                if (icon == null && value instanceof Folder) {
                    icon = OracleIcons.getIcon((String)"folder.png");
                } else if (icon == null) {
                    icon = OracleIcons.getIcon((String)"file.png");
                }
                this.setIcon(icon);
                this.setText(((Displayable)value).getShortLabel());
                this.setToolTipText(((Displayable)value).getToolTipText());
            }
            if (value instanceof Locatable) {
                this.setToolTipText(((Locatable)value).getURL().toString());
            }
            return this;
        }
    }
}

