/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util.search;

import java.awt.Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.config.ClientSetting;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.help.HelpInfo;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.vcs.util.search.ColumnHideDecorator;
import oracle.jdevimpl.vcs.util.search.SearchActions;
import oracle.jdevimpl.vcs.util.search.SearchController;
import oracle.jdevimpl.vcs.util.search.SearchException;
import oracle.jdevimpl.vcs.util.search.SearchLister;
import oracle.jdevimpl.vcs.util.search.SearchPanel;
import oracle.jdevimpl.vcs.util.search.SearchSetup;
import oracle.jdevimpl.vcs.util.search.SearchTable;
import oracle.jdevimpl.vcs.util.search.SearchTableModel;
import oracle.jdevimpl.vcs.util.search.SearchWindow;
import oracle.jdevimpl.vcs.util.search.SearchWorker;

public final class SearchControl {
    private Map _args = null;
    private Thread _thread = null;
    private final SearchLister _lister;
    private final SearchSetup _setup;
    private final Object[] _optionalKeys;
    private boolean[] _columnVisible;
    private SearchWindow _window;
    private SearchPanel _panel;
    private SearchTableModel _tableModel;
    private final SearchActions _actions;
    private final String _extensionId;

    public SearchControl(SearchLister lister, String extensionId) {
        this._lister = lister;
        this._setup = lister.getSearchSetup();
        this._optionalKeys = this._setup.getOptionalResultKeys();
        this._columnVisible = new boolean[this._optionalKeys.length];
        this._extensionId = extensionId;
        for (int i = 0; i < this._columnVisible.length; ++i) {
            String persistKey = this._setup.getControlId() + "_" + this._optionalKeys[i].toString();
            BooleanCopyable bc = (BooleanCopyable)ClientSetting.findOrCreate((String)this._extensionId).getData(persistKey);
            this._columnVisible[i] = bc != null ? bc.getValue() : true;
        }
        if (this._lister == null || this._setup == null) {
            throw new IllegalArgumentException();
        }
        this._window = this.createSearchWindow(this._setup.getControlId());
        this._actions = new SearchActions(this.getSearchView());
        this._panel = new SearchPanel(this._actions.getActionArray()){

            @Override
            protected final void refresh() {
                SearchControl.this.refresh(SearchControl.this.getArguments());
            }
        };
        String topic = this._setup.getHelpTopic();
        if (this._window != null) {
            this._window.initPanel(this._panel);
            if (topic != null) {
                this._window.setHelpInfo(new HelpInfo(topic));
            }
            this._window.setController(new SearchController(this));
        }
    }

    protected SearchWindow createSearchWindow(String id) {
        return new SearchWindow(id){

            public final String getTabName() {
                return SearchControl.this._setup.getWindowTitle();
            }

            public final String getTitleName() {
                return SearchControl.this._setup.getWindowTitle();
            }

            public final Icon getTabIcon() {
                return SearchControl.this._setup.getWindowIcon();
            }
        };
    }

    protected View getSearchView() {
        return this._window;
    }

    public final boolean isBusy() {
        return this._thread != null;
    }

    public final void refresh(final Map args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                try {
                    SearchControl.this.refreshImpl(args);
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)SearchControl.this.getPanel(), (Throwable)re, (String)re.getMessage());
                }
            }
        });
    }

    public final Map getArguments() {
        return this._args;
    }

    public final void close() {
        if (this._window != null) {
            DockStation.getDockStation().undock((Dockable)this._window);
            this._window.close();
        }
    }

    public final void setVisible(boolean visible) {
        if (this._window == null) {
            return;
        }
        if (!DockStation.getDockStation().isDockableVisible((Dockable)this._window) && visible) {
            DockingParam dockingParam = this._setup.getDockingParam();
            DockStation dockStation = DockStation.getDockStation();
            dockStation.dock((Dockable)this._window, dockingParam);
        }
        DockStation.getDockStation().setDockableVisible((Dockable)this._window, visible);
        if (visible) {
            DockStation.getDockStation().activateDockable((Dockable)this._window);
        }
    }

    final SearchWindow getWindow() {
        return this._window;
    }

    final SearchPanel getPanel() {
        return this._panel;
    }

    final SearchActions getActions() {
        return this._actions;
    }

    private final void refreshImpl(final Map args) {
        this.setVisible(true);
        this._args = args;
        if (this._lister == null) {
            return;
        }
        this.getPanel().setEnabled(false);
        String status = this._setup != null ? this._setup.getStatusBusy(this._args) : null;
        this.getPanel().getStatusBar().setText(status);
        if (this.getPanel().getTable() == null) {
            this._tableModel = new SearchTableModel(this._setup);
            ColumnHideDecorator dec = new ColumnHideDecorator(this._tableModel){

                @Override
                protected boolean isColumnVisible(int column) {
                    return SearchControl.this.isColumnVisible(column);
                }

                @Override
                protected void setColumnVisible(int column, boolean visible) {
                    SearchControl.this.setColumnVisible(column, visible);
                    super.setColumnVisible(column, visible);
                }
            };
            this.getPanel().setTable(new SearchTable(dec){

                @Override
                protected final boolean isViewActive() {
                    return SearchControl.this.getWindow() != null && SearchControl.this.getWindow().isViewActive();
                }
            });
        }
        SearchTable table = this.getPanel().getTable();
        final SearchWorker worker = this._lister.getSearchWorker();
        this.setThread(new Thread("SearchControl"){
            private Map arguments;
            {
                super(x0);
                this.arguments = args != null ? new HashMap(args) : null;
            }

            @Override
            public final void run() {
                try {
                    worker.search(this.arguments, SearchControl.this._tableModel);
                    SearchControl.this._tableModel.flushDirty();
                    String status = SearchControl.this._setup != null ? SearchControl.this._setup.getStatusIdle(this.arguments) : "";
                    SearchControl.this.getPanel().getStatusBar().setText(status);
                }
                catch (SearchException se) {
                    SearchControl.this.getPanel().getStatusBar().setText(se.getMessage());
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)SearchControl.this.getPanel(), (Throwable)re, (String)re.getMessage());
                }
                finally {
                    SearchControl.this.getPanel().setEnabled(true);
                    SearchControl.this.setThread(null);
                }
            }
        });
        this._tableModel.markDirty();
        this._thread.start();
    }

    private final void setThread(Thread thread) {
        this._thread = thread;
    }

    private boolean isColumnVisible(int column) {
        if (column == 0) {
            return true;
        }
        return this._columnVisible[column - 1];
    }

    private void setColumnVisible(int column, boolean visible) {
        if (column == 0) {
            return;
        }
        this._columnVisible[column - 1] = visible;
        ClientSetting.findOrCreate((String)this._extensionId).putData(this._setup.getControlId() + "_" + this._optionalKeys[column - 1].toString(), (Copyable)(visible ? BooleanCopyable.TRUE : BooleanCopyable.FALSE));
        try {
            ClientSetting.findOrCreate((String)this._extensionId).save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static class BooleanCopyable
    implements Copyable {
        private boolean _value;
        static final BooleanCopyable TRUE = new BooleanCopyable(true);
        static final BooleanCopyable FALSE = new BooleanCopyable(false);

        public BooleanCopyable() {
            this._value = false;
        }

        public BooleanCopyable(boolean value) {
            this._value = value;
        }

        public boolean getValue() {
            return this._value;
        }

        public void setValue(boolean value) {
            this._value = value;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof BooleanCopyable && ((BooleanCopyable)o)._value == this._value;
        }

        public Object copyTo(Object target) {
            BooleanCopyable copy = target != null ? (BooleanCopyable)target : new BooleanCopyable();
            copy._value = this._value;
            return copy;
        }
    }
}

