/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.net.URL;
import java.util.ListResourceBundle;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.util.ArrayResourceBundle;
import oracle.javatools.util.ImageIconCache;
import oracle.jdeveloper.vcs.spi.VCSStatus;

public class LazyStatus
implements VCSStatus {
    public static final int STATE_UNVERSIONED = 1;
    public static final int STATE_VERSIONED = 2;
    public static final int STATE_OTHER = 3;
    private final BundleType _type;
    private final int _state;
    private ArrayResourceBundle _arb;
    private ArrayResourceBundle _arbIcon;
    private final int _arbIconKey;
    private final int _arbTooltipKey;
    private ListResourceBundle _lrb;
    private final String _lrbIconKey;
    private final String _lrbTooltipKey;
    private IconOverlay _overlay;

    public LazyStatus(boolean versioned, ArrayResourceBundle resource, int tooltipKey) {
        this(versioned, resource, -1, tooltipKey);
    }

    public LazyStatus(boolean versioned, ArrayResourceBundle resource, int iconKey, int tooltipKey) {
        this(versioned, resource, resource, iconKey, tooltipKey);
    }

    public LazyStatus(boolean versioned, ArrayResourceBundle resource, ArrayResourceBundle resourceIcon, int iconKey, int tooltipKey) {
        this._type = BundleType.ARB;
        this._state = versioned ? 2 : 1;
        this._arb = resource;
        this._arbIcon = resourceIcon;
        this._arbIconKey = iconKey;
        this._arbTooltipKey = tooltipKey;
        this._lrb = null;
        this._lrbIconKey = null;
        this._lrbTooltipKey = null;
    }

    public LazyStatus(boolean versioned, ListResourceBundle resource, String iconKey, String tooltipKey) {
        this._type = BundleType.LRB;
        this._state = versioned ? 2 : 1;
        this._arb = null;
        this._arbIcon = null;
        this._arbIconKey = -1;
        this._arbTooltipKey = -1;
        this._lrb = resource;
        this._lrbIconKey = iconKey;
        this._lrbTooltipKey = tooltipKey;
    }

    @Override
    public boolean isVersioned() {
        return this._state == 2;
    }

    @Override
    public boolean isCandidate() {
        return this._state == 1;
    }

    @Override
    public IconOverlay getOverlay() {
        if (this._overlay != null) {
            return this._overlay;
        }
        this._overlay = this._type == BundleType.ARB ? new IconOverlay(this._arbIconKey >= 0 ? this._arbIcon.getIconImpl(this._arbIconKey) : null, null, this._arb.getStringImpl(this._arbTooltipKey)) : new IconOverlay(this._lrbIconKey != null ? ImageIconCache.get((URL)this._lrb.getClass().getResource(this._lrb.getString(this._lrbIconKey))) : null, null, this._lrb.getString(this._lrbTooltipKey));
        this._arb = null;
        this._arbIcon = null;
        this._lrb = null;
        return this._overlay;
    }

    private static enum BundleType {
        ARB,
        LRB;

    }
}

