/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeFactory;

public class DebugUtil {
    private DebugUtil() {
    }

    public static final String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append("Node:");
        sb.append('\n');
        sb.append(DebugUtil.toString((Element)context.getNode()));
        sb.append('\n');
        sb.append("Element:");
        sb.append('\n');
        sb.append(DebugUtil.toString(context.getElement()));
        sb.append('\n');
        sb.append("Event:");
        sb.append('\n');
        sb.append(context.getEvent());
        sb.append('\n');
        sb.append("Project:");
        sb.append('\n');
        sb.append(DebugUtil.toString((Element)context.getProject()));
        sb.append('\n');
        sb.append("Selection:");
        sb.append('\n');
        sb.append(DebugUtil.toString(context.getSelection()));
        sb.append('\n');
        sb.append("View:");
        sb.append('\n');
        sb.append(context.getView());
        sb.append('\n');
        sb.append("Workspace:");
        sb.append('\n');
        sb.append(DebugUtil.toString((Element)context.getWorkspace()));
        return sb.toString();
    }

    public static final String toString(Locatable[] selection) {
        if (selection == null) {
            return "NULL";
        }
        Element[] elements = new Element[selection.length];
        System.arraycopy(selection, 0, elements, 0, selection.length);
        return DebugUtil.toString(elements);
    }

    public static final String toString(Element[] selection) {
        if (selection == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(selection.toString());
        for (int i = 0; selection != null && i < selection.length; ++i) {
            sb.append('\n');
            sb.append('[');
            sb.append(i);
            sb.append(']');
            sb.append('\n');
            sb.append(DebugUtil.toString(selection[i]));
        }
        return sb.toString();
    }

    public static final String toString(Element element) {
        if (element == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(element.toString());
        URL url = null;
        if (element instanceof Locatable) {
            Locatable locatable = (Locatable)element;
            url = locatable.getURL();
            sb.append('\n');
            sb.append("URL=");
            sb.append(url);
        }
        if (url != null) {
            boolean cached = NodeFactory.find(url) == element;
            sb.append('\n');
            sb.append(cached ? "Cached in NodeFactory" : "Not cached in NodeFactory");
        }
        return sb.toString();
    }
}

