/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.changelist;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.jdeveloper.vcs.changelist.AsynchronousChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.PendingChangesAdapter;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.util.VCSConfigUtils;
import oracle.jdevimpl.vcs.generic.VCSProfileImpl;
import oracle.jdevimpl.vcs.generic.changelist.CLUtil;
import oracle.jdevimpl.vcs.generic.changelist.StatusBasedMultiChangeList;
import oracle.jdevimpl.vcs.generic.profile.ChangeListInfo;
import oracle.jdevimpl.vcs.generic.profile.PendingChangesInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionInfo;
import oracle.jdevimpl.vcs.generic.res.Resource;
import oracle.jdevimpl.vcs.generic.util.VCSGenericUtil;

public final class StatusBasedChangeListWindow
extends ChangeListWindow {
    private static final String OPTIONS_VISIBLE_DT_PROP = ".changeListCommentsVisible";
    private final String _displayName;
    private VCSProfileImpl _profile;
    private PendingChangesInfo _pendingChangesInfo;
    private Map<ChangeListInfo, ChangeList> _infos = null;
    private StructureChangeListener _prefsListener;
    private HelpInfo _helpInfo;
    private HashStructureAdapter _prefs;

    public StatusBasedChangeListWindow(String windowId, VCSProfile profile) {
        super(((VCSProfileImpl)profile).getChangeLists(), windowId);
        this._profile = (VCSProfileImpl)profile;
        this._pendingChangesInfo = this._profile.getProfileInfo().getPendingChanges();
        String displayName = this._pendingChangesInfo.getDisplayName();
        if (displayName == null) {
            displayName = Resource.get("PENDING_CHANGES_LABEL");
        }
        this._displayName = displayName;
        for (Map.Entry<ChangeListInfo, ChangeList> entry : this.getInfos().entrySet()) {
            if (!entry.getKey().includeCommentsUI()) continue;
            entry.getValue().addPropertyChangeListener("optionsVisible", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if ("optionsVisible".equals(e.getPropertyName())) {
                        Ide.getDTCache().putBoolean(StatusBasedChangeListWindow.this._profile.getID() + StatusBasedChangeListWindow.OPTIONS_VISIBLE_DT_PROP, (Boolean)e.getNewValue());
                    }
                }
            });
        }
        this.prefsChanged();
    }

    private Map<ChangeListInfo, ChangeList> getInfos() {
        if (this._infos != null) {
            return this._infos;
        }
        this._infos = new HashMap<ChangeListInfo, ChangeList>();
        ChangeList[] changeLists = this._profile.getChangeLists();
        if (this._profile != null) {
            ChangeListInfo[] changeListInfos = this._profile.getProfileInfo().getPendingChanges().getChangeLists().toArray(new ChangeListInfo[0]);
            if (changeLists.length != changeListInfos.length) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < changeLists.length; ++i) {
                this._infos.put(changeListInfos[i], changeLists[i]);
            }
        }
        return this._infos;
    }

    public void resetChangeListInfos() {
        this._infos = null;
    }

    @Override
    public HelpInfo getHelpInfo() {
        if (this._pendingChangesInfo.getHelpId() == null) {
            return super.getHelpInfo();
        }
        if (this._helpInfo == null) {
            this._helpInfo = new HelpInfo(this._pendingChangesInfo.getHelpId());
        }
        return this._helpInfo;
    }

    @Override
    public String getTitleName() {
        return this._displayName;
    }

    @Override
    protected String getBusyStatusMessage(Object modeId) {
        ChangeList changeList = this.getChangeList(modeId);
        for (Map.Entry<ChangeListInfo, ChangeList> entry : this.getInfos().entrySet()) {
            if (changeList != entry.getValue() || entry.getKey().getBusyMessage() == null) continue;
            return entry.getKey().getBusyMessage();
        }
        return super.getBusyStatusMessage();
    }

    @Override
    protected void delayedInitialization() {
        for (Map.Entry<ChangeListInfo, ChangeList> entry : this.getInfos().entrySet()) {
            ChangeList cl = entry.getValue();
            if (cl instanceof StatusBasedMultiChangeList && cl.getStatusCacheBridge() == null) {
                cl.setStatusCacheBridge(this._profile.getStatusCacheBridge());
            }
            if (cl instanceof StatusBasedMultiChangeList && ((StatusBasedMultiChangeList)cl).isInitialized()) continue;
            try {
                cl.setOverlayItemProducer(VCSGenericUtil.newOverlayProducer(this._profile, entry.getKey().getOverlayProducerClass()));
            }
            catch (ClassNotFoundException cnfe) {
                this._profile.getLogger().warning("could not find overlay producer class. using a default instance");
                cl.setOverlayItemProducer(new VCSOverlayItemProducer(this._profile.getId(), this._profile.getStatusCacheBridge()));
            }
            if (entry.getKey().getVisibleStatuses() != null) {
                cl.setVisibleStatuses(CLUtil.toStatusArray(this._profile, entry.getKey().getVisibleStatuses().getStatusRefs()));
            }
            PendingChangesAdapter adapter = this._profile.getPendingChangesAdapter();
            if (!entry.getKey().includeCommentsUI()) continue;
            ChangeListCommentsCustomizer changeListCustomizer = new ChangeListCommentsCustomizer(this._profile.getId());
            if (adapter != null) {
                adapter.initializeCommentsCustomizer(changeListCustomizer, entry.getKey().getID());
            }
            cl.setOptionsCustomizer(changeListCustomizer);
            cl.setOptionsVisible(Ide.getDTCache().getBoolean(this._profile.getID() + OPTIONS_VISIBLE_DT_PROP, false));
        }
        this._prefs = this._pendingChangesInfo.getAdapter().getPreferences();
        if (this._prefs != null) {
            this._prefsListener = new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent e) {
                    if (!VCSConfigUtils.isSignificantStructureChange(e)) {
                        return;
                    }
                    StatusBasedChangeListWindow.this.prefsChanged();
                }
            };
            this._prefs.addStructureChangeListener(this._prefsListener);
        }
    }

    @Override
    public void prefsChanged() {
        if (this._profile != null) {
            super.prefsChanged();
        }
    }

    @Override
    protected void preferencesChanged() {
        super.preferencesChanged();
        AsynchronousChangeList icl = this.getIncomingChangeList();
        if (icl != null) {
            icl.timerIntervalChanged();
        }
    }

    private AsynchronousChangeList getIncomingChangeList() {
        for (ChangeListInfo cli : this.getInfos().keySet()) {
            ChangeList cl = this._infos.get(cli);
            if (cl == null || !(cl instanceof AsynchronousChangeList)) continue;
            return (AsynchronousChangeList)cl;
        }
        return null;
    }

    @Override
    protected void postDeinitialization() {
        super.postDeinitialization();
        if (this._prefs != null) {
            this._prefs.removeStructureChangeListener(this._prefsListener);
            this._prefsListener = null;
        }
    }

    @Override
    protected void updateEllipsisItems() {
        if (this._profile == null) {
            return;
        }
        for (ChangeListInfo cli : this.getInfos().keySet()) {
            if (cli.getToolbar() == null) continue;
            Iterator j = cli.getToolbar().getSections().iterator();
            while (j.hasNext()) {
                for (String actionId : ((SectionInfo)j.next()).getActionRefs()) {
                    Integer cmdId = Ide.findCmdID((String)actionId);
                    if (cmdId == null) continue;
                    this.setEllipsisVisible(this.getLocalAction(cmdId), this._pendingChangesInfo == null || this._pendingChangesInfo.getAdapter() == null || !this._pendingChangesInfo.getAdapter().isActionSilent(this.getChangeList(cli.getID()), actionId));
                }
            }
        }
    }

    @Override
    protected void addToolbarActions(Toolbar toolbar) {
        this.updateVisibleToolbarActions(toolbar);
    }

    @Override
    protected void setCommentsVisible(boolean visible) {
        super.setCommentsVisible(visible);
        this.updateEllipsisItems();
    }

    private ChangeList getActiveChangeList() {
        return this._profile.getChangeList((String)this.getModeId());
    }

    private ChangeListInfo getChangeListInfo(ChangeList changeList) {
        for (Map.Entry<ChangeListInfo, ChangeList> entry : this.getInfos().entrySet()) {
            if (changeList != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected void updateVisibleToolbarActions(Toolbar toolbar) {
        super.updateVisibleToolbarActions(toolbar);
    }

    @Override
    protected void addCommentsToolbarAction(Toolbar toolbar) {
        ChangeList cl = this.getActiveChangeList();
        if (this.getChangeListInfo(cl).includeCommentsUI()) {
            super.addCommentsToolbarAction(toolbar);
        }
    }

    @Override
    protected void addContextMenuListeners(ContextMenu menu) {
        super.addContextMenuListeners(menu);
    }

    @Override
    protected void removeContextMenuListeners(ContextMenu menu) {
        super.removeContextMenuListeners(menu);
    }

    @Override
    protected String[] getPreferencesPath() {
        return this._pendingChangesInfo.getAdapter().getPreferencesPath();
    }
}

