/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.util.HashMap;
import java.util.Map;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.PropertyResolver;
import oracle.ideri.util.BundlePropertyResolver;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;

final class GLazyIdeAction
extends BundlePropertyResolver {
    private static final Map<String, String> sIconReferences = new HashMap<String, String>(10);
    private final String _iconRef;
    private final Icon _icon;

    protected GLazyIdeAction(Icon icon, String resourceClass, ClassLoader resourceClassLoader, Map map) {
        super(resourceClass, resourceClassLoader, map);
        this._iconRef = null;
        this._icon = icon;
    }

    protected GLazyIdeAction(String iconRef, String resourceClass, ClassLoader resourceClassLoader, Map map) {
        super(resourceClass, resourceClassLoader, map);
        this._iconRef = iconRef;
        this._icon = null;
    }

    public static IdeAction getAction(int commandId, MetaClass commandClass, Class resourceClass, String resourcePrefix, Icon icon) {
        return GLazyIdeAction.getAction(commandId, commandClass, resourceClass, resourcePrefix, null, icon);
    }

    public static IdeAction getAction(int commandId, MetaClass commandClass, Class resourceClass, String resourcePrefix, String iconReference) {
        return GLazyIdeAction.getAction(commandId, commandClass, resourceClass, resourcePrefix, iconReference, null);
    }

    private static final IdeAction getAction(int commandId, MetaClass commandClass, Class resourceClass, String resourcePrefix, String iconReference, Icon icon) {
        IdeAction action = IdeAction.find((int)commandId);
        if (action == null) {
            action = IdeAction.get((int)commandId);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("SmallIcon", resourcePrefix + "_ICON");
            map.put("Name", resourcePrefix + "_NAME");
            map.put("NoCtxName", resourcePrefix + "_INDEPENDENT_NAME");
            map.put("MnemonicKey", resourcePrefix + "_MNEMONIC");
            map.put("ShortDescription", resourcePrefix + "_TOOLTIP");
            if (icon != null) {
                action.addPropertyResolver((PropertyResolver)new GLazyIdeAction(icon, resourceClass.getName(), resourceClass.getClassLoader(), map));
            } else {
                action.addPropertyResolver((PropertyResolver)new GLazyIdeAction(iconReference, resourceClass.getName(), resourceClass.getClassLoader(), map));
            }
            action.putValue("Category", (Object)VCSMenuConstants.ACTION_CATEGORY_VERSIONING);
            action.setCommand(commandClass);
            action.setEnabled(false);
        }
        return action;
    }

    public Object get(String key) {
        if (key == "SmallIcon" && this._icon != null) {
            return this._icon;
        }
        if (key == "SmallIcon" && this._iconRef != null) {
            return this.resolveIconReference(this._iconRef);
        }
        return super.get(key);
    }

    private Icon resolveIconReference(String iconRef) {
        String id = sIconReferences.get(iconRef);
        if (id != null) {
            return VCSIconArb.getIcon(id);
        }
        return null;
    }

    static {
        sIconReferences.put("oracle.jdeveloper.vcs.icon.ADD", "add.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.ADD_ALL", "add.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.UNDO_CHECKOUT", "clear.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.COMPARE_PREVIOUS", "compare_previous.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.MERGE", "union.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.SYNCHRONIZE", "update.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.SYNCHRONIZE_ALL", "update.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.CHECK_IN", "commit2.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.CHECK_IN_ALL", "commit2.png");
        sIconReferences.put("oracle.jdeveloper.vcs.icon.PENDING_CHANGES", "pendingchanges.png");
    }
}

