/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.changeset;

import oracle.ide.feedback.FeedbackManager;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetException;
import oracle.jdeveloper.vcs.changeset.ChangeSetRegistry;
import oracle.jdeveloper.vcs.changeset.ChangeSetUpdate;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEBMessage;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;

public final class ChangeSetEBComponent
implements VCSEBComponent {
    @Override
    public final void handleMessage(VCSEBMessage message) {
        VCSNodeUpdate update;
        if (message instanceof ChangeSetUpdate) {
            ChangeSetUpdate update2 = (ChangeSetUpdate)message;
            try {
                if (update2.getWhat() == ChangeSetUpdate.PENDING) {
                    ChangeSetRegistry.lookup(update2.getSystemId()).handlePending(update2.getURLs());
                }
                if (update2.getWhat() == ChangeSetUpdate.COMMITTED) {
                    ChangeSetRegistry.lookup(update2.getSystemId()).handleCommitted(update2.getURLs());
                }
            }
            catch (ChangeSetException cse) {
                FeedbackManager.reportException((Throwable)cse);
            }
            return;
        }
        if (message instanceof VCSNodeUpdate && (update = (VCSNodeUpdate)message).getWhat() == VCSNodeUpdate.RENAMED) {
            VCSExtension extension = VCSExtensionUtils.getActiveExtension(update.getOldURL());
            if (extension == null) {
                return;
            }
            ChangeSetAdapter adapter = ChangeSetRegistry.lookup(extension.getId());
            if (adapter == null) {
                return;
            }
            try {
                adapter.handleRenamed(update.getOldURL(), update.getNode().getURL());
            }
            catch (ChangeSetException cse) {
                FeedbackManager.reportException((Throwable)cse);
            }
            return;
        }
    }
}

