/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.versiontree;

import java.net.URL;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vhv.VHVCommand;
import oracle.ide.vhv.VHVCustomizer;
import oracle.ide.vhv.VHVQuery;
import oracle.ide.vhv.VHVViewer;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommandType;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.util.VCSEditorUtils;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryCommand;
import oracle.jdeveloper.vcs.versiontree.VersionTreeController;

public abstract class VersionTreeCommand
extends VCSCommand {
    public static final String VERSION_TREE_CMD = VersionHistoryCommand.class.getName();
    public static final int VERSION_TREE_CMD_ID = Ide.findOrCreateCmdID((String)VERSION_TREE_CMD);

    public static final IdeAction getVersionTreeAction(String command, String vcsId) {
        int id = Ide.findOrCreateCmdID((String)command);
        IdeAction versionTreeAction = IdeAction.find((int)id);
        if (versionTreeAction != null) {
            return versionTreeAction;
        }
        versionTreeAction = VHVCommand.getVHVAction((int)id, (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader(vcsId), command));
        versionTreeAction.putValue("Category", (Object)VCSMenuConstants.ACTION_CATEGORY_VERSIONING);
        versionTreeAction.addController((Controller)new VersionTreeController(id, vcsId));
        return versionTreeAction;
    }

    public VersionTreeCommand() {
        this(VERSION_TREE_CMD_ID);
    }

    protected VersionTreeCommand(int cmdId) {
        super(cmdId, 1);
        this.initializeCommandStyle(VCSCommandStyle.NORMAL);
        this.initializeCommandType(VCSCommandType.BOTH);
    }

    @Override
    protected URLFilter getURLFilter() {
        return VCSURLFilters.createFileProtocolFilter();
    }

    @Override
    public boolean isAvailable() {
        VCSExtension extension;
        VCSExtension _extension = (VCSExtension)this.getContext().getProperty("VCSController.VCS");
        if (!(_extension == null || (extension = VCSExtensionUtils.getActiveExtension(this.getContext())) != null && extension.getId().equals(_extension.getId()))) {
            return false;
        }
        return super.isAvailable();
    }

    @Override
    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        return locatables.length > 0 && this.isAvailableImpl(this.getContextLocatables()[0]);
    }

    @Override
    protected boolean isAvailableImpl(URL url) throws Exception {
        if (!super.isAvailableImpl(url)) {
            return false;
        }
        return VCSManager.getVCSManager().isVersioned(url);
    }

    @Override
    public int doitImpl() throws Exception {
        Locatable[] locatables = this.getContextLocatables();
        if (locatables.length > 0) {
            URL url = locatables[0].getURL();
            VHVCommand.show((URL)url, (VHVQuery)this.createQuery(), (VHVCustomizer)this.createCustomizer(), (String)this.getVersionPath(url));
        }
        return 0;
    }

    protected abstract VHVQuery createQuery();

    protected abstract String getVersionPath(URL var1);

    protected VHVCustomizer createCustomizer() {
        return null;
    }

    public static final void closeVersionTreeEditors() {
        VCSEditorUtils.closeEditorsForEditorType(VHVViewer.class);
    }
}

