/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.model.Locatable;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.replace.ReplaceMenuManager;
import oracle.ide.vcs.VCSManager;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.javatools.util.Log;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSExtensionInformation;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.util.VCSDefaultUtils;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdevimpl.vcs.VCSManagerImpl;

public class VCSMenuUtils {
    private static ContextMenuListener _compareContextMenuListener;
    private static ContextMenuListener _replaceContextMenuListener;
    private static Map<JMenuItem, String> _compareMenuItems;
    private static Map<JMenuItem, String> _replaceMenuItems;
    private static final Object PROPERTY_DYNAMIC_MENU_LISTENER;
    private static final Log LOG;

    @Deprecated
    public static JMenu getMainVersioningMenu() {
        JMenu menu = MenuManager.getJMenu((String)"VERSIONING_MENU");
        if (menu == null) {
            throw new IllegalStateException("VCS extension trying to initialize with no Versioning menu");
        }
        return menu;
    }

    public static JMenu getWindowTeamSubmenu() {
        return VersioningCoreUtil.getWindowTeamSubmenu();
    }

    @Deprecated
    public static JMenu getViewTeamSubmenu() {
        return VersioningCoreUtil.getViewTeamSubmenu();
    }

    public static JMenuItem installVersionHistoryMenuItem(JMenu menu, int cmdId) {
        return VCSMenuUtils.addMenuItem(menu, cmdId, 99.8f);
    }

    public static JMenu createVersioningSubmenu() {
        float section = MenuConstants.SECTION_ADDITIONAL_CTXT_MENU;
        return Ide.getMenubar().createSubMenu(VCSArb.get("VERSIONING_SUBMENU"), VCSMenuConstants.CONTEXT_MENU_MNEMONIC, 0.1f, section);
    }

    public static JMenu installMainSystemMenu(String vcsId, VCSExtensionInformation information) {
        String menuId = "VERSIONING_MENU." + vcsId;
        String name = information.getShortLabel();
        JMenu submenu = Ide.getMenubar().createSubMenu(name, null, 0.0f, 0.0f);
        submenu.setIcon(information.getIcon());
        MenuManager.putJMenu((String)menuId, (JMenu)submenu);
        return submenu;
    }

    public static void installContextMenuListener(ContextMenuListener listener) {
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().addContextMenuListener(listener, null);
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(listener, null);
        ((VCSManagerImpl)VCSManager.getVCSManager()).registerContextMenuListener(listener);
    }

    public static void uninstallContextMenuListener(ContextMenuListener listener) {
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().removeContextMenuListener(listener);
        }
        EditorManager.getEditorManager().getContextMenu().removeContextMenuListener(listener);
        ((VCSManagerImpl)VCSManager.getVCSManager()).deregisterContextMenuListener(listener);
    }

    public static KeyStrokeContext registerKeyStrokes(Collection<IdeAction> actions, String keyStrokeContextName) {
        IdeAction[] actionArray = new IdeAction[actions.size()];
        actions.toArray(actionArray);
        KeyStrokeContext context = VCSDefaultUtils.createKeyStrokeContext(actionArray, keyStrokeContextName);
        Ide.getKeyStrokeContextRegistry().addContext(context);
        return context;
    }

    public static JMenuItem addMenuItem(JMenu menu, int cmdId, float section) {
        return VCSMenuUtils.addMenuItem(menu, (ToggleAction)IdeAction.find((int)cmdId), section);
    }

    public static JMenuItem addMenuItem(ContextMenu menu, int cmdId, float section) {
        return VCSMenuUtils.addMenuItem(menu, (ToggleAction)IdeAction.find((int)cmdId), section);
    }

    public static JMenuItem addMenuItem(JMenu menu, ToggleAction action, float section) {
        return (JMenuItem)VCSMenuUtils.addMenuItem(menu, Ide.getMenubar().createMenuItem(action), section);
    }

    public static JMenuItem addMenuItem(ContextMenu menu, ToggleAction action, float section) {
        JMenuItem menuItem = Ide.getMenubar().createMenuItem(action);
        menu.add((Component)menuItem, section);
        return menuItem;
    }

    public static Component addMenuItem(JMenu menu, Component component, float section) {
        Ide.getMenubar().add(component, menu, section);
        return component;
    }

    @Deprecated
    public static JMenuItem addDynamicMenuItem(JMenu menu, int cmdId, float section, Context context) {
        DynamicMenuListener l = VCSMenuUtils.getDynamicMenuListener(menu, context);
        VCSMenuUtils.addMenuItem(menu, cmdId, section);
        return l.addDynamicAction(cmdId, section);
    }

    public static void addRawMenuItemNoAction(JMenu menu, JMenuItem item, float section, Context context) {
        DynamicMenuListener l = VCSMenuUtils.getDynamicMenuListener(menu, context);
        VCSMenuUtils.addMenuItem(menu, item, section);
        l.addRawItem(item, section);
    }

    private static final DynamicMenuListener getDynamicMenuListener(JMenu menu, Context context) {
        DynamicMenuListener l = (DynamicMenuListener)menu.getClientProperty(PROPERTY_DYNAMIC_MENU_LISTENER);
        if (l == null) {
            l = new DynamicMenuListener(menu);
            menu.addMenuListener(l);
            menu.putClientProperty(PROPERTY_DYNAMIC_MENU_LISTENER, l);
        }
        l.setContext(context);
        return l;
    }

    public static JMenuItem addDynamicMenuItem(ContextMenu menu, int cmdId, float section) {
        if (!VCSMenuUtils.updateDynamicAction(cmdId, menu.getContext())) {
            return null;
        }
        return VCSMenuUtils.addMenuItem(menu, cmdId, section);
    }

    public static final void addLazyDynamicMenuItem(JMenu menu, int cmdId, float section, Context context) {
        VCSMenuUtils.addDynamicMenuItem(menu, cmdId, section, context);
    }

    public static final void setLazyDynamicMenuDefaultAction(JMenu menu, int cmdId, Context context) {
        DynamicMenuListener l = VCSMenuUtils.getDynamicMenuListener(menu, context);
        l.setDefaultCmdId(cmdId);
    }

    public static JMenuItem addMenuItemToTeamMenu(int cmdId, String alterativeName, float section) {
        JMenu teamMenu;
        IdeAction action = IdeAction.find((int)cmdId);
        if (alterativeName != null) {
            action.setLabelUpdater((LabelUpdater)new TeamItemActionLabelUpdater(alterativeName));
        }
        if ((teamMenu = VCSMenuUtils.getWindowTeamSubmenu()) == null) {
            return null;
        }
        JMenuItem menuItem = VCSMenuUtils.addMenuItem(teamMenu, cmdId, section);
        if (alterativeName != null) {
            menuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)alterativeName));
        }
        return menuItem;
    }

    private static final boolean updateDynamicAction(int cmdId, Context context) {
        IdeAction action = IdeAction.find((int)cmdId);
        if (action == null) {
            return false;
        }
        action.updateAction(context);
        return action.isEnabled();
    }

    public static JMenuItem createMenuItem(int cmdId) {
        return Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)cmdId));
    }

    public static JMenuItem createMenuItem(int cmdId, float weight) {
        return Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)cmdId), weight);
    }

    public static void installCompareMenuItem(final int cmdId, String vcsId) {
        _compareMenuItems.put(VCSMenuUtils.createMenuItem(cmdId), vcsId);
        if (_compareContextMenuListener != null) {
            return;
        }
        _compareContextMenuListener = new ContextMenuListener(){

            public void menuWillShow(ContextMenu contextMenu) {
                CompareViewer compareViewer = CompareViewer.get();
                if (compareViewer == null) {
                    LOG.trace("Compare viewer is not available. Version control menu item \"" + IdeAction.find((int)cmdId).getValue("Name") + "\" could not be installed.");
                    return;
                }
                for (Map.Entry entry : _compareMenuItems.entrySet()) {
                    JMenu menu = compareViewer.getContextCompareMenu();
                    Ide.getMenubar().remove((Component)entry.getKey(), menu);
                    VCSExtension extension = VCSExtensionUtils.getActiveExtension(contextMenu.getContext());
                    if (extension == null || !extension.getId().equals(entry.getValue())) continue;
                    Ide.getMenubar().add((Component)entry.getKey(), menu, 0.5f);
                }
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }
        };
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().getContextMenu().addContextMenuListener(_compareContextMenuListener);
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(_compareContextMenuListener);
    }

    public static void installReplaceMenuItem(int cmdId, String vcsId) {
        _replaceMenuItems.put(VCSMenuUtils.createMenuItem(cmdId), vcsId);
        if (_replaceContextMenuListener == null) {
            _replaceContextMenuListener = new ContextMenuListener(){

                public void menuWillShow(ContextMenu contextMenu) {
                    JMenu menu = ReplaceMenuManager.getInstance().getContextReplaceMenu();
                    VCSMenuUtils.addMenuItems(menu, contextMenu.getContext());
                }

                public void menuWillHide(ContextMenu contextMenu) {
                }

                public boolean handleDefaultAction(Context context) {
                    return false;
                }
            };
        }
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().getContextMenu().addContextMenuListener(_replaceContextMenuListener);
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(_replaceContextMenuListener);
    }

    public static void addCompareSubmenu(Collection<? super JMenuItem> menus, Context context) {
        if (CompareViewer.get() != null) {
            JMenu menu = CompareViewer.get().getContextCompareMenu();
            for (int i = 0; i < menu.getItemCount(); ++i) {
                JMenuItem item = menu.getItem(i);
                if (item != null && item.getAction() instanceof IdeAction) {
                    ((IdeAction)item.getAction()).updateAction(context);
                }
                if (item == null || !item.isEnabled()) continue;
                menus.add(menu);
                break;
            }
        }
    }

    public static final void registerContextMenuForCompare(ContextMenu contextMenu) {
        if (_compareContextMenuListener != null) {
            contextMenu.addContextMenuListener(_compareContextMenuListener);
        }
    }

    public static final void registerContextMenuForReplace(ContextMenu contextMenu) {
        if (_replaceContextMenuListener != null) {
            contextMenu.addContextMenuListener(_replaceContextMenuListener);
        }
    }

    private static void addMenuItems(JMenu menu, Context context) {
        for (Map.Entry<JMenuItem, String> entry : _replaceMenuItems.entrySet()) {
            Ide.getMenubar().remove((Component)entry.getKey(), menu);
            Boolean valid = null;
            VCSExtension extension = VCSExtensionUtils.getActiveExtension(context);
            if (extension == null || !extension.getId().equals(entry.getValue())) continue;
            if (valid == null) {
                valid = VCSMenuUtils.validateSelection(context);
            }
            if (!valid.booleanValue()) continue;
            Ide.getMenubar().add((Component)entry.getKey(), menu, 1.0f);
        }
    }

    private static boolean validateSelection(Context context) {
        Locatable[] selection = context != null ? VCSManager.getVCSManager().getContextLocatables(context) : null;
        boolean validLocatables = false;
        if (context != null && selection != null && selection.length > 0) {
            for (int i = 0; i < selection.length && !validLocatables; ++i) {
                URL url = selection[i].getURL();
                if (url == null || URLFileSystem.isDirectoryPath((URL)url) || !URLFileSystem.exists((URL)url)) continue;
                validLocatables = true;
            }
        }
        return validLocatables;
    }

    static {
        _compareMenuItems = new LinkedHashMap<JMenuItem, String>();
        _replaceMenuItems = new LinkedHashMap<JMenuItem, String>();
        PROPERTY_DYNAMIC_MENU_LISTENER = "VCSMenuUtils.DynamicMenuListener";
        LOG = new Log("vcs");
    }

    private static class TeamItemActionLabelUpdater
    implements LabelUpdater {
        private String _teamMenuLabel;
        private int mnemonic;

        private TeamItemActionLabelUpdater(String teamSubLabel) {
            this._teamMenuLabel = StringUtils.stripMnemonic((String)teamSubLabel);
            this.mnemonic = StringUtils.getMnemonicKeyCode((String)teamSubLabel);
        }

        public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
            JMenu jMenu;
            JMenu teamMenu;
            Object source;
            if (context.getEvent() != null && (source = context.getEvent().getSource()) instanceof JMenu && (teamMenu = VCSMenuUtils.getWindowTeamSubmenu()) == (jMenu = (JMenu)source)) {
                return this._teamMenuLabel;
            }
            return originalLabel;
        }

        public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
            return this.labelWhenEnabled(context, action, originalLabel);
        }

        public void setEnabledFormat(String format) {
        }

        public void setDisabledFormat(String format) {
        }
    }

    private static final class DynamicMenuListener
    implements MenuListener {
        private final JMenu _menu;
        private final Map<Integer, JMenuItem> _items = new LinkedHashMap<Integer, JMenuItem>();
        private final Map<Integer, Float> _sections = new HashMap<Integer, Float>();
        private final Collection<JMenuItem> _rawItems = new ArrayList<JMenuItem>();
        private final Map<JMenuItem, Float> _rawSections = new HashMap<JMenuItem, Float>();
        private Context _context;
        private Integer _defaultCmdId;

        DynamicMenuListener(JMenu menu) {
            this._menu = menu;
        }

        final JMenuItem addDynamicAction(int cmdId, float section) {
            JMenuItem menuItem = Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)cmdId));
            this._items.put(cmdId, menuItem);
            this._sections.put(cmdId, Float.valueOf(section));
            return menuItem;
        }

        final void addRawItem(JMenuItem item, float section) {
            this._rawItems.add(item);
            this._rawSections.put(item, Float.valueOf(section));
        }

        final void setContext(Context context) {
            this._context = context;
        }

        final void setDefaultCmdId(int defaultCmdId) {
            this._defaultCmdId = defaultCmdId;
        }

        @Override
        public final void menuSelected(MenuEvent e) {
            this._menu.removeAll();
            for (Map.Entry<Integer, JMenuItem> entry : this._items.entrySet()) {
                if (!VCSMenuUtils.updateDynamicAction(entry.getKey(), this._context)) continue;
                Ide.getMenubar().add((Component)entry.getValue(), this._menu, this._sections.get(entry.getKey()).floatValue());
            }
            for (JMenuItem item : this._rawItems) {
                Ide.getMenubar().add((Component)item, this._menu, this._rawSections.get(item).floatValue());
            }
            if (this._menu.getItemCount() == 0) {
                if (this._defaultCmdId != null && VCSMenuUtils.updateDynamicAction(this._defaultCmdId, this._context)) {
                    Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)this._defaultCmdId)));
                } else {
                    JMenuItem noOpMenuItem = new JMenuItem(VCSArb.get("NO_OPERATIONS_AVAILABLE"));
                    noOpMenuItem.setEnabled(false);
                    this._menu.add(noOpMenuItem);
                }
            }
            this._menu.removeMenuListener(this);
        }

        @Override
        public final void menuDeselected(MenuEvent e) {
        }

        @Override
        public final void menuCanceled(MenuEvent e) {
        }
    }
}

