/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackApi;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeFilter;
import oracle.ide.model.NodeUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCSManager;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.util.VCSCollectionUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.VCSManagerImpl;

@FeedbackApi(value="VCSBufferUtils")
public class VCSBufferUtils {
    private VCSBufferUtils() {
    }

    public static Map<Node, Long> storeAllTimestamps() {
        HashMap<Node, Long> timestampMap = new HashMap<Node, Long>();
        NodeUtil.storeAllTimestamps(timestampMap, (NodeFilter)new OpenNodeFilter());
        return timestampMap;
    }

    public static Map<Node, Long> storeTimestamps(Collection<?> nodes) {
        HashMap<Node, Long> timestampMap = new HashMap<Node, Long>();
        Node[] nodeArray = (Node[])VCSCollectionUtils.toArrayType(nodes, Node.class);
        NodeUtil.storeTimestamps(timestampMap, Arrays.asList(nodeArray), (NodeFilter)new OpenNodeFilter());
        return timestampMap;
    }

    public static void reloadBuffers(Map<Node, Long> timestampMap) {
        if (timestampMap != null) {
            if (!EventQueue.isDispatchThread() && FeedbackManager.isOn() && Ide.getIdeArgs().getCreateUI()) {
                FeedbackManager.reportAPIException((String)"Misuse of VCSBufferUtils", (Throwable)new IllegalStateException("reloadBuffers(Map) called from non-event thread"), (String)"VCSBufferUtils");
            }
            NodeUtil.reloadBuffers(timestampMap, EnumSet.of(NodeUtil.ReloadMode.RELOAD_PROMPTED_IF_DIRTY, NodeUtil.ReloadMode.SILENT_RELOAD));
        }
        VCSBufferUtils.fileTimestampsCheck(timestampMap);
    }

    public static void reloadBuffer(URL url) {
        Node node = NodeFactory.find((URL)url);
        if (node == null) {
            return;
        }
        NodeUtil.reloadNodes(Collections.singleton(node), EnumSet.of(NodeUtil.ReloadMode.SILENT_RELOAD));
        if (node.isDirty()) {
            Assert.printStackTrace((Throwable)new Throwable("Warning: see bug 8478454: reload lost in-memory changes for node with URL " + node.getURL()));
        }
        VCSBufferUtils.fileTimestampsCheck(Collections.singletonMap(node, new Long(Long.MIN_VALUE)));
    }

    public static void reloadBuffer(URL[] urls) {
        HashMap<Node, Long> nodes = new HashMap<Node, Long>();
        Long time = new Long(Long.MIN_VALUE);
        for (int u = 0; u < urls.length; ++u) {
            Node node = NodeFactory.find((URL)urls[u]);
            if (node == null) continue;
            nodes.put(node, time);
        }
        if (nodes.isEmpty()) {
            return;
        }
        NodeUtil.reloadNodes(nodes.keySet(), EnumSet.of(NodeUtil.ReloadMode.SILENT_RELOAD));
        for (Node node : nodes.keySet()) {
            if (!node.isDirty()) continue;
            Assert.printStackTrace((Throwable)new Throwable("Warning: see bug 8478454: reload lost in-memory changes for node with URL " + node.getURL()));
        }
        VCSBufferUtils.fileTimestampsCheck(nodes);
    }

    private static final void fileTimestampsCheck(Map<Node, Long> timestampMap) {
        ArrayList<Node> changedTimestampNodes = new ArrayList<Node>();
        for (Map.Entry<Node, Long> entry : timestampMap.entrySet()) {
            Node node = entry.getKey();
            Long storedTimestamp = entry.getValue();
            if (node == null || URLFileSystem.lastModified((URL)node.getURL()) == storedTimestamp) continue;
            changedTimestampNodes.add(node);
        }
        if (changedTimestampNodes.isEmpty()) {
            return;
        }
        VCSFileEventSender.fireFilesModified(VCSModelUtils.convertNodesToURLs(changedTimestampNodes));
    }

    private static class OpenNodeFilter
    implements NodeUtil.NodeFilter {
        private OpenNodeFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean accept(Node node) {
            if (node != null && node.isLoaded()) {
                return true;
            }
            URL url = node.getURL();
            if (url == null) {
                return false;
            }
            Class<VCSBufferUtils> clazz = VCSBufferUtils.class;
            synchronized (VCSBufferUtils.class) {
                Iterator<URLFilter> itr = ((VCSManagerImpl)VCSManager.getVCSManager()).getMgrVCSListenerFilters().iterator();
                while (itr.hasNext()) {
                    if (!itr.next().accept(url)) continue;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
        }
    }
}

