/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import oracle.ide.Ide;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.spi.VCSApplicationSystem;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;

public class VCSSingleWorkingCopyLocator {
    private static final Map<String, VCSSingleWorkingCopyLocator> _locators = new HashMap<String, VCSSingleWorkingCopyLocator>();
    private final String _vcsId;
    private final String _adminPath;
    private Set<URL> _roots = null;
    private Set<VCSHashURL> _notRoots = null;
    private final Lock _updateLock = new ReentrantLock();
    private ExecutorService _executor;

    private VCSSingleWorkingCopyLocator(String vcsId, String adminPath) {
        this._vcsId = vcsId;
        this._adminPath = adminPath;
        Observer o = new Observer(){

            @Override
            public final void update(Observable o, Object arg) {
                if (arg == null || arg.equals(VCSSingleWorkingCopyLocator.this._vcsId)) {
                    VCSSingleWorkingCopyLocator.this.updateRoots(false);
                }
            }
        };
        VCSApplicationSystem.getApplicationSystem().addObserver(o);
        VCSControlCache.getInstance().addObserver(o);
        this.updateRoots(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final VCSSingleWorkingCopyLocator getLocatorInstance(String vcsId, String adminPath) {
        Map<String, VCSSingleWorkingCopyLocator> map = _locators;
        synchronized (map) {
            VCSSingleWorkingCopyLocator instance = _locators.get(vcsId);
            if (instance == null) {
                instance = new VCSSingleWorkingCopyLocator(vcsId, adminPath);
                _locators.put(vcsId, instance);
            }
            return instance;
        }
    }

    public final URL[] getRoots() {
        this.acquireUpdateLock();
        try {
            Set<URL> roots = this.getNonNullRoots();
            URL[] uRLArray = roots.toArray(new URL[roots.size()]);
            return uRLArray;
        }
        finally {
            this._updateLock.unlock();
        }
    }

    public final URL getRootContaining(URL url) {
        return this._getRootContaining(url);
    }

    private boolean isAdministered(URL dirUrl) {
        return URLFileSystem.exists((URL)URLFactory.newURL((URL)dirUrl, (String)this._adminPath));
    }

    private final void updateRoots(final boolean notify) {
        this.getExecutor().submit(new Runnable(){

            @Override
            public final void run() {
                VCSSingleWorkingCopyLocator.this._updateRoots(notify);
            }
        });
    }

    private final synchronized ExecutorService getExecutor() {
        if (this._executor == null) {
            this._executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private final ThreadFactory _delegate = Executors.defaultThreadFactory();

                @Override
                public final Thread newThread(Runnable r) {
                    Thread t = this._delegate.newThread(r);
                    t.setName("VCSSingleWorkingCopyLocator@" + VCSSingleWorkingCopyLocator.this._vcsId);
                    return t;
                }
            });
        }
        return this._executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _updateRoots(boolean notify) {
        Collection workspaces = Ide.getWorkspaces().workspaces();
        HashMap<Project, Collection> contentSetRootMap = new HashMap<Project, Collection>();
        for (Workspace workspace : workspaces) {
            Iterator<Object> iterator = workspace.projects().iterator();
            while (iterator.hasNext()) {
                Project project;
                contentSetRootMap.put(project, (project = (Project)iterator.next()).isOpen() ? ContentSetRoot.getContentSetRoots((Project)project) : null);
            }
        }
        this._updateLock.lock();
        try {
            LinkedHashSet<URL> roots = new LinkedHashSet<URL>();
            LinkedHashSet<VCSHashURL> notRoots = new LinkedHashSet<VCSHashURL>();
            for (Workspace workspace : workspaces) {
                this.populateRoot(URLFileSystem.getParent((URL)workspace.getURL()), roots, notRoots);
            }
            for (Map.Entry entry : contentSetRootMap.entrySet()) {
                this.populateRoot(URLFileSystem.getParent((URL)((Project)entry.getKey()).getURL()), roots, notRoots);
                if (entry.getValue() == null) continue;
                for (ContentSetRoot contentSetRoot : (Collection)entry.getValue()) {
                    if (JarUtil.isJarURL((URL)contentSetRoot.getURL())) continue;
                    this.populateRoot(VCSFileSystemUtils.getDirectoryPathURL(contentSetRoot.getURL()), roots, notRoots);
                }
            }
            if (this._roots == null) {
                this._roots = new LinkedHashSet<URL>();
            }
            this._roots.addAll(roots);
            if (this._notRoots == null) {
                this._notRoots = new LinkedHashSet<VCSHashURL>();
            } else {
                this._notRoots.clear();
            }
            this._notRoots.addAll(notRoots);
        }
        finally {
            this._updateLock.unlock();
        }
        if (notify) {
            VCSControlCache.getInstance().fireControlStateChanged(this._vcsId);
        }
    }

    private final void populateRoot(URL dirUrl, Set<URL> roots, Set<VCSHashURL> notRoots) {
        if (this._getRootContaining(dirUrl, roots) != null) {
            return;
        }
        if (this.isRootEqual(dirUrl, notRoots)) {
            return;
        }
        if (this.isAdministered(dirUrl)) {
            roots.add(dirUrl);
            notRoots.clear();
            return;
        }
        URL parent = URLFileSystem.getParent((URL)dirUrl);
        if (parent != null && !parent.equals(dirUrl)) {
            notRoots.add(new VCSHashURL(dirUrl));
            this.populateRoot(parent, roots, notRoots);
        }
    }

    private final URL _getRootContaining(URL url) {
        this.acquireUpdateLock();
        try {
            URL uRL = this._getRootContaining(url, this.getNonNullRoots());
            return uRL;
        }
        finally {
            this._updateLock.unlock();
        }
    }

    private final void acquireUpdateLock() {
        this._updateLock.lock();
    }

    private final Set<URL> getNonNullRoots() {
        return this._roots != null ? this._roots : Collections.emptySet();
    }

    private final URL _getRootContaining(URL url, Set<URL> roots) {
        for (URL root : roots) {
            if (!URLFileSystem.isBaseURLFor((URL)root, (URL)url)) continue;
            return root;
        }
        return null;
    }

    private final boolean isRootEqual(URL url, Set<VCSHashURL> roots) {
        return roots.contains(new VCSHashURL(url));
    }
}

