/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.cache;

import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.jdeveloper.vcs.cache.Depth;

public final class StatusCacheUtil {
    private StatusCacheUtil() {
    }

    public static final URLFilter createDepthFilter(URL[] urls, Depth depth) {
        if (urls == null) {
            return StatusCacheUtil.createNullFilter();
        }
        if (depth == null || depth == Depth.EMPTY) {
            return StatusCacheUtil.createSpecificURLFilter(urls);
        }
        if (depth == Depth.IMMEDIATES) {
            return StatusCacheUtil.createDirectoryContentsFilter(urls);
        }
        if (depth == Depth.INFINITY) {
            return StatusCacheUtil.createBaseURLContentsFilter(urls);
        }
        throw new IllegalArgumentException();
    }

    private static final URLFilter createNullFilter() {
        return new URLFilter(){

            public boolean accept(URL url) {
                return true;
            }
        };
    }

    private static final URLFilter createSpecificURLFilter(URL[] urls) {
        final URL[] urls2 = VersioningCoreUtil.removeRefAndQueryParts((URL[])urls);
        return new URLFilter(){

            public boolean accept(URL url) {
                for (URL url2 : urls2) {
                    if (!URLFileSystem.equals((URL)url, (URL)url2)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static final URLFilter createDirectoryContentsFilter(URL[] directoryUrls) {
        final URL[] directoryUrls2 = VersioningCoreUtil.removeRefAndQueryParts((URL[])directoryUrls);
        return new URLFilter(){

            public boolean accept(URL url) {
                URL parent = URLFileSystem.getParent((URL)url);
                for (int i = 0; i < directoryUrls2.length; ++i) {
                    if (!URLFileSystem.equals((URL)directoryUrls2[i], (URL)parent)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static final URLFilter createBaseURLContentsFilter(URL[] baseUrls) {
        final URL[] baseUrls2 = VersioningCoreUtil.removeRefAndQueryParts((URL[])baseUrls);
        return new URLFilter(){

            public boolean accept(URL url) {
                for (int i = 0; i < baseUrls2.length; ++i) {
                    if (!VersioningCoreUtil.isBaseURLFor((URL)baseUrls2[i], (URL)url)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

