/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.cache;

import java.net.URI;
import java.net.URL;
import java.util.Map;
import oracle.javatools.util.Maps;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.cache.StatusCacheEvent;
import oracle.jdeveloper.vcs.cache.StatusCacheListener;

public class LocalStatusCache<V>
extends StatusCache<V> {
    private final StatusCache<V> _masterCache;
    private final StatusCacheListener _l = new StatusCacheListener(){

        @Override
        public final void statusesCleared(StatusCacheEvent e) {
            if (e.isInvalidate()) {
                LocalStatusCache.this.invalidate();
            } else {
                LocalStatusCache.this.clear(e.getURLs(), e.getDepth());
            }
        }
    };
    private boolean _canShare = true;

    LocalStatusCache(Class<V> valueType, StatusCache<V> master) {
        super(valueType);
        this._masterCache = master;
        this._masterCache.addCacheListener(this._l);
    }

    public final StatusCache<V> getMasterCache() {
        return this._masterCache;
    }

    @Override
    protected final Map<URI, V> createCache(int bound) {
        return new Maps.CacheMap(bound, Maps.CacheMap.NOT_CANONICAL);
    }

    @Override
    protected void _get3(URL[] urls, V[] values) throws Exception {
        if (this._canShare && !this.mustFetch()) {
            V[] values2 = this._masterCache.get(urls);
            System.arraycopy(values2, 0, values, 0, values.length);
            return;
        }
        super._get3(urls, values);
    }

    @Override
    protected final void getNatively(URL[] urls, V[] statuses) throws Exception {
        this._masterCache.getNatively(urls, statuses);
    }

    public final void dispose() {
        this._masterCache.removeCacheListener(this._l);
    }

    @Override
    public final LocalStatusCache<V> newLocalCache() {
        return this;
    }

    @Override
    public final boolean isLocalCache() {
        return true;
    }

    protected boolean mustFetch() {
        return false;
    }

    public final void unshare() {
        this._canShare = false;
    }

    public final void reshare() {
        this._canShare = true;
    }
}

