/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.util.Collection;
import java.util.Iterator;
import oracle.ide.model.Element;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.algorithm.ProgressCompareAlgorithm;
import oracle.jdeveloper.compare.CompareMethod;
import oracle.jdevimpl.compare.CompareOpenHint;

public class CompareInvocation {
    private final Collection<CompareMethod> _compareMethods;
    private final Iterator<CompareMethod> _compareMethodItr;
    private CompareMethod _currentMethod;
    private CompareAlgorithm _currentAlgorithm;
    private Element _contextNode;
    private boolean _canceled;
    private CompareFailedException _failure;
    private boolean _duplicates = false;
    private CompareOpenHint _hints;

    public CompareInvocation(Element contextNode, Collection<CompareMethod> compareMethods) {
        this._contextNode = contextNode;
        this._compareMethods = compareMethods;
        this._compareMethodItr = this._compareMethods.iterator();
        if (this.hasMoreMethods()) {
            this.nextMethod();
        }
    }

    public final Element getContextNode() {
        return this._contextNode;
    }

    public void setDuplicates(boolean dup) {
        this._duplicates = dup;
    }

    public boolean duplicatesAllowed() {
        return this._duplicates;
    }

    public synchronized CompareMethod getCurrentMethod() {
        return this._currentMethod;
    }

    public synchronized CompareAlgorithm getCurrentAlgorithm() {
        return this._currentAlgorithm;
    }

    public synchronized boolean hasMoreMethods() {
        return this._compareMethodItr.hasNext();
    }

    public synchronized void nextMethod() {
        this._currentMethod = this._compareMethodItr.next();
        this._currentAlgorithm = CompareModelFactory.createCompareAlgorithm((CompareType)this._currentMethod.getCompareType());
    }

    public synchronized void cancel() {
        if (this._currentAlgorithm instanceof ProgressCompareAlgorithm) {
            ((ProgressCompareAlgorithm)this._currentAlgorithm).cancel();
        }
        while (this.hasMoreMethods()) {
            this.nextMethod();
        }
        this._canceled = true;
    }

    public synchronized boolean isCancelable() {
        for (CompareMethod compareMethod : this._compareMethods) {
            CompareAlgorithm compareAlgorithm = CompareModelFactory.createCompareAlgorithm((CompareType)compareMethod.getCompareType());
            if (!(compareAlgorithm instanceof ProgressCompareAlgorithm)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isCanceled() {
        return this._canceled;
    }

    public final CompareFailedException getFailure() {
        return this._failure;
    }

    public final void setFailure(CompareFailedException failure) {
        this._failure = failure;
    }

    public void setHint(CompareOpenHint _hints) {
        this._hints = _hints;
    }

    public CompareOpenHint getHint() {
        return this._hints;
    }
}

