/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import oracle.ide.util.IdeUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.jdeveloper.compare.IdeTextCompareContributor;
import oracle.jdeveloper.compare.PatchCompareContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.compare.Stream;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.compare.StreamType;

public class InputStreamTextContributor
extends IdeTextCompareContributor
implements PatchCompareContributor {
    private final TextBuffer _buffer;
    private final String _longLabel;
    private final String _shortLabel;
    private final String _type;
    private final String _charsetName;
    private final StreamType _streamType;
    private PatchCompareDescriptor _patchDescriptor;

    public InputStreamTextContributor(InputStream inStream, String shortLabel, String longLabel, String type) throws IOException {
        this(StreamDecoder.getStream(type, inStream, IdeUtil.getIdeEncoding()), shortLabel, longLabel, type);
    }

    public InputStreamTextContributor(InputStream inStream, String defaultEncoding, String shortLabel, String longLabel, String type) throws IOException {
        this(StreamDecoder.getStream(type, inStream, defaultEncoding), shortLabel, longLabel, type);
    }

    @Deprecated
    public InputStreamTextContributor(Reader inStream, String shortLabel, String longLabel, String type) throws IOException {
        this(inStream, null, null, shortLabel, longLabel, type);
    }

    private InputStreamTextContributor(Stream stream, String shortLabel, String longLabel, String type) throws IOException {
        this(stream.getReader(), stream.getType(), stream.getEncoding(), shortLabel, longLabel, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStreamTextContributor(Reader inStream, StreamType streamType, String charsetName, String shortLabel, String longLabel, String type) throws IOException {
        try {
            this._buffer = TextBufferFactory.createTextBuffer();
            this._buffer.read(inStream);
            this._buffer.setReadOnly(true);
            this._longLabel = longLabel;
            this._shortLabel = shortLabel;
            int lastDot = type.lastIndexOf(46);
            if (lastDot >= 0) {
                type = type.substring(lastDot + 1);
            }
            this._type = type;
            this._charsetName = charsetName;
            this._streamType = streamType;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public TextBuffer getTextBuffer() {
        return this._buffer;
    }

    public String getLongLabel() {
        return this._longLabel;
    }

    public String getShortLabel() {
        return this._shortLabel;
    }

    public String getType() {
        return this._type;
    }

    public void setPatchDescriptor(PatchCompareDescriptor patchDescriptor) {
        this._patchDescriptor = patchDescriptor;
    }

    @Override
    public PatchCompareDescriptor getPatchDescriptor() {
        return this._patchDescriptor;
    }

    public StreamType getStreamType() {
        return this._streamType;
    }

    public String getStreamEncoding() {
        return this._charsetName;
    }
}

