/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ide.extension.DeferredElementVisitorHook;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionRegistry;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.ide.model.Element;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.jndi.Names;
import oracle.jdeveloper.compare.CompareMethod;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdevimpl.compare.CompareHandler;
import oracle.jdevimpl.compare.CompareManagerImpl;

public abstract class CompareManager {
    private static final Lock _managerLock = new ReentrantLock();
    protected static final String JNDI_NAME = "jdeveloper/compare-manager";
    private List<CompareMethod> _compareMethods = new ArrayList<CompareMethod>();

    public static final CompareManager getCompareManager() {
        _managerLock.lock();
        try {
            InitialContext ic = Names.newInitialContext();
            CompareManager compareManager = (CompareManager)Names.lookup((Context)ic, (String)JNDI_NAME);
            if (compareManager == null) {
                compareManager = new CompareManagerImpl();
                Names.bind((Context)ic, (String)JNDI_NAME, (Object)compareManager);
                DeferredElementVisitorHook hookHandler = (DeferredElementVisitorHook)ExtensionRegistry.getExtensionRegistry().getHook(CompareHandler.NAME);
                hookHandler.attachElementVisitor((ElementVisitor)new CompareHandler());
            }
            CompareManager compareManager2 = compareManager;
            return compareManager2;
        }
        finally {
            _managerLock.unlock();
        }
    }

    @Deprecated
    public final void registerCompareMethod(CompareMethod compareMethod) {
        for (int i = 0; i <= this._compareMethods.size(); ++i) {
            if (i >= this._compareMethods.size()) {
                this._compareMethods.add(compareMethod);
                break;
            }
            CompareType[] fallbackTypes = compareMethod.getFallbackCompareTypes();
            if (fallbackTypes == null || !Arrays.asList(fallbackTypes).contains(this._compareMethods.get(i).getCompareType())) continue;
            this._compareMethods.add(i, compareMethod);
            break;
        }
    }

    public final Collection<CompareMethod> getCompareMethods() {
        return Collections.unmodifiableCollection(this._compareMethods);
    }

    public final boolean isContentComparable(URL url) {
        for (CompareMethod compareMethod : this.getCompareMethods()) {
            if (!compareMethod.recognizeContent(url)) continue;
            return true;
        }
        return false;
    }

    public final CompareModel createCompareModel(CompareContributor first, CompareContributor second) throws CompareFailedException {
        return CompareModelFactory.createCompareModel((CompareContributor)first, (CompareContributor)second);
    }

    public final CompareModel createMergeModel(CompareContributor first, CompareContributor second, CompareContributor ancestor) throws CompareFailedException {
        return CompareModelFactory.createMergeModel((CompareContributor)first, (CompareContributor)second, (CompareContributor)ancestor);
    }

    public final CompareView createCompareView(CompareModel model) {
        return CompareViewFactory.createCompareView((CompareModel)model);
    }

    public final CompareView createMergeView(CompareModel model) {
        return CompareViewFactory.createMergeView((CompareModel)model);
    }

    @Deprecated
    public static final void registerXMLNodeClass(Class<? extends Element> cls) {
        StreamDecoder.registerXMLNodeClass(cls);
    }
}

