/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.todo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.config.Preferences;
import oracle.ide.extension.HashStructureHookAggregator;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.todo.TaskPriority;

public interface TaskTag
extends Comparable<TaskTag> {
    public static final Pair<Integer, Integer> NOT_FOUND = new Pair((Object)-1, (Object)-1);

    public String name();

    public void name(String var1);

    public TaskPriority priority();

    public void priority(TaskPriority var1);

    public boolean enabled();

    public void enabled(boolean var1);

    public String searchString();

    public void searchString(String var1);

    public Pair<Integer, Integer> indexOf(String var1);

    public Pair<Integer, Integer> indexOf(String var1, int var2);

    public boolean isUserDefined();

    public static final class Factory {
        private static final String PREFS_KEY = "TaskTagsPreferences";
        private static final String PREFS_TAGS_KEY = "task-tags";
        private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "todo-sourcetag-hook");
        private static final HashStructureHookAggregator AGGREGATOR = new HashStructureHookAggregator(HOOK_NAME, new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                Factory.addExtensionTags(e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                Factory.addExtensionTags(e.getCombinedHashStructure());
            }
        });
        private static final CopyOnWriteArrayList<TaskTag> EXT_TAGS = new CopyOnWriteArrayList();
        private static List<TaskTag> ALL_TAGS;

        public static TaskTag newTag(String name, String searchString, TaskPriority priority) {
            TaskTag tag = (TaskTag)AdapterManager.Factory.getAdapterManager().adapt((Object)HashStructure.newInstance(), TaskTag.class);
            tag.name(name);
            tag.searchString(searchString);
            tag.priority(priority);
            return tag;
        }

        public static List<TaskTag> getTaskTags() {
            AGGREGATOR.initialize();
            if (null == ALL_TAGS) {
                ALL_TAGS = new ArrayList<TaskTag>();
                ALL_TAGS.addAll(Factory.getPreferredTags());
                for (TaskTag tag : EXT_TAGS) {
                    if (ALL_TAGS.contains(tag)) continue;
                    ALL_TAGS.add(tag);
                }
                Collections.sort(ALL_TAGS);
            }
            return Collections.unmodifiableList(ALL_TAGS);
        }

        public static void setPreferredTags(List<TaskTag> tags) {
            ALL_TAGS = null;
            HashStructure hash = Preferences.getPreferences().getProperties().getOrCreateHashStructure(PREFS_KEY);
            ListStructure tagsList = hash.getOrCreateListStructure(PREFS_TAGS_KEY);
            tagsList.clear();
            for (TaskTag tag : tags) {
                HashStructure tagHash = (HashStructure)AdapterManager.Factory.getAdapterManager().adapt((Object)tag, HashStructure.class);
                if (null == tagHash) continue;
                tagsList.add((Object)tagHash);
            }
        }

        private static void addExtensionTags(HashStructure hash) {
            ALL_TAGS = null;
            if (null == hash) {
                return;
            }
            List list = hash.getAsList("tag");
            for (Object obj : list) {
                TaskTag tag = (TaskTag)AdapterManager.Factory.getAdapterManager().adapt(obj, TaskTag.class);
                if (null == tag) continue;
                EXT_TAGS.addIfAbsent(tag);
            }
        }

        private static List<TaskTag> getPreferredTags() {
            ArrayList<TaskTag> tags = new ArrayList<TaskTag>();
            HashStructure hash = Preferences.getPreferences().getProperties().getOrCreateHashStructure(PREFS_KEY);
            List list = hash.getAsList(PREFS_TAGS_KEY);
            if (null == list) {
                return tags;
            }
            for (Object obj : list) {
                TaskTag tag = (TaskTag)AdapterManager.Factory.getAdapterManager().adapt(obj, TaskTag.class);
                if (null == tag) continue;
                tags.add(tag);
            }
            return tags;
        }
    }
}

