/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.net.URL;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ApplicationCacheSettings
extends HashStructureAdapter {
    private final URL _workspaceURL;
    public static final String APPLICATION_STORAGE_KEY = "application-storage-directory";

    public static ApplicationCacheSettings getInstance(PropertyStorage psWorkspace, URL workspaceURL) {
        return new ApplicationCacheSettings(psWorkspace.getProperties(), workspaceURL);
    }

    public static ApplicationCacheSettings getInstance(HashStructure hash, URL workspaceURL) {
        return new ApplicationCacheSettings(hash, workspaceURL);
    }

    public static ApplicationCacheSettings getInstance(Workspace workspace) {
        return new ApplicationCacheSettings(workspace.getProperties(), workspace.getURL());
    }

    private ApplicationCacheSettings(HashStructure hash, URL workspaceURL) {
        super(hash);
        if (workspaceURL == null) {
            throw new NullPointerException("workspaceURL must be specified");
        }
        this._workspaceURL = workspaceURL;
    }

    public URL getStorageURL() {
        URL url = this._hash.getURL(APPLICATION_STORAGE_KEY);
        if (url == null) {
            return this.getDefaultApplicationStorageURL();
        }
        return url;
    }

    public void setStorageURL(URL url) {
        if (url == null) {
            this._hash.remove(APPLICATION_STORAGE_KEY);
        } else {
            URL oldStorageURL = this._hash.getURL(APPLICATION_STORAGE_KEY);
            if (!URLFileSystem.equals((URL)url, (URL)oldStorageURL)) {
                if (oldStorageURL == null) {
                    oldStorageURL = this.getDefaultApplicationStorageURL();
                }
                this._hash.putURL(APPLICATION_STORAGE_KEY, url);
            }
        }
    }

    public URL getDefaultApplicationStorageURL() {
        String outputPath = System.getProperty("oracle.ide.persistence.defaultApplicationStorageArea");
        if (outputPath != null && outputPath.trim().length() > 0) {
            return URLFactory.newURL((String)outputPath.trim());
        }
        return this.getApplicationHomeURL();
    }

    public URL getOverrideApplicationStorageURL() {
        URL storageURL = this._hash.getURL(APPLICATION_STORAGE_KEY);
        if (this.getDefaultApplicationStorageURL().equals(storageURL)) {
            return null;
        }
        return storageURL;
    }

    private URL getApplicationHomeURL() {
        return URLFileSystem.getParent((URL)this._workspaceURL);
    }
}

