/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.externaltools.program.ExternalProgramTool;
import oracle.ideimpl.externaltools.program.ExternalProgramType;
import oracle.xml.parser.v2.XMLDocument;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ToolPersistence {
    static final String TOOL_DEFINITION_FILENAME = "tools.xml";
    private static final String TOP_TAG = "tools";
    private static final String NS_905 = "http://xmlns.oracle.com/jdeveloper/905/externaltools";
    private static final String STYLE_904_TO_905 = "tools-904-to-905.xsl";
    private static final String ENCODING = "UTF-8";
    static final int VERSION_904 = 0;
    static final int VERSION_905 = 1;
    static final int VERSION_UNRECOGNIZED = -1;
    static final int SUPPORTED_VERSION = 1;

    ToolPersistence() {
    }

    static int getDefinitionRevision(File f) throws IOException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setValidating(false);
        ToolFileRecognizerHandler handler = new ToolFileRecognizerHandler();
        try {
            SAXParser parser = parserFactory.newSAXParser();
            parser.parse(f, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new IOException(pce.getMessage());
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
            throw new IOException(saxe.getMessage());
        }
        return handler.getVersion();
    }

    static ArrayList loadDefinitions1013(File file) throws IOException {
        Object2Dom o2d = Object2Dom.newInstance();
        URL u = URLFactory.newFileURL((File)file);
        o2d.setDocumentURL(u);
        return (ArrayList)o2d.toObject(u, ToolPersistence.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveDefinitions(File file, List definitions) throws IOException {
        if (definitions == null) {
            return;
        }
        Object2Dom o2d = Object2Dom.newInstance();
        o2d.setNamespaceURI(NS_905);
        o2d.setDocumentURL(URLFactory.newFileURL((File)file));
        XMLDocument xmlDoc = o2d.toDocument((Object)definitions, TOP_TAG);
        xmlDoc.setEncoding(ENCODING);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
            xmlDoc.print(writer);
        }
    }

    static void convertDefinitions(File sourceFile, File destinationFile, int sourceFormat) throws IOException {
        if (sourceFormat == -1) {
            sourceFormat = ToolPersistence.getDefinitionRevision(sourceFile);
        }
        if (sourceFormat == 1) {
            ToolPersistence.fixClassNames(sourceFile, destinationFile);
            ToolPersistence.convert905ToLatest(destinationFile, destinationFile);
        } else if (sourceFormat == 0) {
            ToolPersistence.convert904To905(sourceFile, destinationFile);
            ToolPersistence.convert905ToLatest(destinationFile, destinationFile);
        }
    }

    private static void fixClassNames(File sourceFile, File destinationFile) throws IOException {
        ToolPersistence.xslt(sourceFile, destinationFile, "tools-905-to-11.xsl");
    }

    private static void convert905ToLatest(File sourceFile, File destinationFile) throws IOException {
        ArrayList definitions = ToolPersistence.loadDefinitions1013(sourceFile);
        for (ExternalTool tool : definitions) {
            ExternalProgramTool ept;
            URL iconURL;
            if (!(tool instanceof ExternalProgramTool) || (iconURL = (ept = (ExternalProgramTool)tool).getIconURL()) == null || !iconURL.getPath().endsWith("programtool.gif")) continue;
            ept.setIconURL(ExternalProgramType.class.getResource("programtool.gif"));
        }
        ToolPersistence.saveDefinitions(destinationFile, definitions);
    }

    private static void xslt(File sourceFile, File destinationFile, String xslResource) throws IOException {
        try (FileOutputStream fos = null;){
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource stylesheetSource = new StreamSource(ToolPersistence.class.getResource(xslResource).toString());
            Transformer transformer = transformerFactory.newTransformer(stylesheetSource);
            StreamSource oldSource = new StreamSource(sourceFile);
            if (!destinationFile.exists()) {
                destinationFile.createNewFile();
            }
            fos = new FileOutputStream(destinationFile);
            StreamResult outputFile = new StreamResult(fos);
            transformer.transform(oldSource, outputFile);
        }
    }

    private static void convert904To905(File sourceFile, File destinationFile) throws IOException {
        ToolPersistence.xslt(sourceFile, destinationFile, STYLE_904_TO_905);
        ArrayList definitions = ToolPersistence.loadDefinitions1013(destinationFile);
        boolean changedSomething = false;
        for (ExternalTool et : definitions) {
            ExternalProgramTool ept;
            if (!(et instanceof ExternalProgramTool) || (ept = (ExternalProgramTool)et).getIconURL() != null) continue;
            ept.setIconURL(ExternalProgramType.class.getResource("programtool.gif"));
            changedSomething = true;
        }
        if (changedSomething) {
            ToolPersistence.saveDefinitions(destinationFile, definitions);
        }
    }

    private static class ToolFileRecognizerHandler
    extends DefaultHandler {
        private int m_version = -1;

        private ToolFileRecognizerHandler() {
        }

        public int getVersion() {
            return this.m_version;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes attributes) throws SAXException {
            if (ToolPersistence.TOP_TAG.equals(localName)) {
                this.m_version = ToolPersistence.NS_905.equals(namespaceURI) ? 1 : 0;
            }
        }
    }
}

