/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.externaltools.Availability;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.IntegrationPoint;
import oracle.ide.keyboard.DefaultKeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.externaltools.ExternalToolAction;
import oracle.ideimpl.externaltools.ExternalToolAddin;
import oracle.javatools.controls.JMenuSorter;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.SwingClosure;

final class MenuManager
implements IdeListener {
    private ExternalToolAddin m_externalToolAddin;
    private ArrayList m_menuItems;
    private ArrayList m_mainToolBarItems;
    private ToolKeyStrokeContext m_keyStrokeContext;
    private static final int EXTERNAL_TOOLS_CMD_ID = Ide.findCmdID((String)"ExternalTools");

    MenuManager(ExternalToolAddin eta) {
        this.m_externalToolAddin = eta;
    }

    private void deregisterAction(ExternalTool t) {
        IdeAction action = this.getIdeActionForTool(t);
        if (action != null) {
            IdeAction.remove((int)action.getCommandId());
        }
    }

    private void removeMenu(ExternalTool t) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        if (this.m_menuItems != null && props.isIntegrated(IntegrationPoint.TOOLS_MENU)) {
            IdeAction action = this.getIdeActionForTool(t);
            for (JMenuItem b : this.m_menuItems) {
                if (b.getAction() != action) continue;
                Ide.getMenubar().remove((Component)b, oracle.ide.controller.MenuManager.getJMenu((String)"Tools"));
                b.setAction(null);
                this.m_menuItems.remove(b);
                if (this.m_menuItems.size() != 0) break;
                this.m_menuItems = null;
                break;
            }
        }
    }

    private void removeToolBarItems(ExternalTool t) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        if (this.m_mainToolBarItems != null && props.isIntegrated(IntegrationPoint.MAIN_TOOLBAR)) {
            IdeAction action = this.getIdeActionForTool(t);
            for (JMenuItem b : this.m_mainToolBarItems) {
                if (b.getAction() != action) continue;
                Ide.getToolbar().remove((Component)b);
                b.setAction(null);
                this.m_mainToolBarItems.remove(b);
                if (this.m_mainToolBarItems.size() == 0) {
                    this.m_mainToolBarItems = null;
                }
                Ide.getToolbar().invalidate();
                Ide.getToolbar().validate();
                Ide.getToolbar().repaint();
                break;
            }
        }
    }

    private void addMenu(ExternalTool t) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        if (props.isIntegrated(IntegrationPoint.TOOLS_MENU)) {
            if (this.m_menuItems == null) {
                this.m_menuItems = new ArrayList();
            }
            JMenu toolsMenu = oracle.ide.controller.MenuManager.getJMenu((String)"Tools");
            IdeAction action = this.getIdeActionForTool(t);
            JMenuItem item = Ide.getMenubar().createMenuItem((ToggleAction)action);
            this.m_menuItems.add(item);
            Ide.getMenubar().add((Component)item, toolsMenu, MenuConstants.SECTION_TOOLS_EXTERNAL_TOOLS);
            if (JMenuSorter.isSorted((JMenu)toolsMenu)) {
                JMenuSorter.registerExclusionGroup((JMenu)toolsMenu, (Component)item);
            }
        }
    }

    private void createMenus() {
        for (ExternalTool tool : this.m_externalToolAddin.tools()) {
            this.addMenu(tool);
        }
    }

    private void deregisterActions() {
        for (ExternalTool tool : this.m_externalToolAddin.tools()) {
            this.deregisterAction(tool);
        }
    }

    private void removeMenus() {
        if (this.m_menuItems == null) {
            return;
        }
        JMenu toolsMenu = oracle.ide.controller.MenuManager.getJMenu((String)"Tools");
        for (JMenuItem mi : this.m_menuItems) {
            mi.setAction(null);
            Ide.getMenubar().remove((Component)mi, toolsMenu);
        }
        this.m_menuItems = null;
    }

    private void addToolBarItem(ExternalTool t, boolean repaint, int position) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        if (props.isIntegrated(IntegrationPoint.MAIN_TOOLBAR)) {
            if (this.m_mainToolBarItems == null) {
                this.m_mainToolBarItems = new ArrayList();
            }
            IdeAction action = this.getIdeActionForTool(t);
            ToolButton button = new ToolButton((Action)action);
            Ide.getToolbar().add((Component)button, position);
            this.m_mainToolBarItems.add(button);
            if (repaint) {
                Ide.getToolbar().validate();
                Ide.getToolbar().repaint();
            }
        }
    }

    private void addToolBarItem(ExternalTool t, boolean repaint) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        if (props.isIntegrated(IntegrationPoint.MAIN_TOOLBAR)) {
            if (this.m_mainToolBarItems == null) {
                this.m_mainToolBarItems = new ArrayList();
            }
            IdeAction action = this.getIdeActionForTool(t);
            this.m_mainToolBarItems.add(Ide.getToolbar().add((ToggleAction)action));
            if (repaint) {
                Ide.getToolbar().validate();
                Ide.getToolbar().repaint();
            }
        }
    }

    private void createToolBarItems() {
        this.m_mainToolBarItems = new ArrayList();
        boolean needMainSep = true;
        int lastButtonPosition = this.findFileBugButtonPosition();
        if (lastButtonPosition == -1) {
            lastButtonPosition = this.findGcButtonPosition();
        }
        if (lastButtonPosition == -1) {
            lastButtonPosition = Ide.getToolbar().getComponentCount() - 1;
        }
        for (ExternalTool t : this.m_externalToolAddin.tools()) {
            ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
            if (!props.isIntegrated(IntegrationPoint.MAIN_TOOLBAR)) continue;
            if (needMainSep) {
                JToolBar.Separator separator = new JToolBar.Separator();
                Ide.getToolbar().add((Component)separator, lastButtonPosition++);
                this.m_mainToolBarItems.add(separator);
                needMainSep = false;
            }
            this.addToolBarItem(t, false, lastButtonPosition++);
        }
        if (!needMainSep) {
            Ide.getToolbar().validate();
            Ide.getToolbar().repaint();
        }
    }

    private int findGcButtonPosition() {
        return this.findToolbarButtonPosition("DebugGCCommand");
    }

    private int findFileBugButtonPosition() {
        return this.findToolbarButtonPosition("oracle.jdeveloper.bugfiler.fileABug");
    }

    private int findToolbarButtonPosition(String id) {
        Integer beforeActionAsInteger = Ide.findCmdID((String)id);
        if (beforeActionAsInteger == null) {
            return -1;
        }
        int beforeActionId = beforeActionAsInteger;
        Toolbar tb = Ide.getToolbar();
        for (int i = 0; i < tb.getComponentCount(); ++i) {
            IdeAction ideAction;
            int cmdId;
            Action action;
            Component c = tb.getComponent(i);
            if (!(c instanceof AbstractButton) || !((action = ((AbstractButton)c).getAction()) instanceof IdeAction) || (cmdId = (ideAction = (IdeAction)action).getCommandId()) != beforeActionId) continue;
            return i + 1;
        }
        return -1;
    }

    private void removeToolBarItems() {
        if (this.m_mainToolBarItems != null) {
            for (Component item : this.m_mainToolBarItems) {
                Ide.getToolbar().remove(item);
                if (!(item instanceof AbstractButton)) continue;
                ((AbstractButton)item).setAction(null);
            }
            Ide.getToolbar().invalidate();
            Ide.getToolbar().validate();
            Ide.getToolbar().repaint();
            this.m_mainToolBarItems = null;
        }
    }

    IdeAction getIdeActionForTool(ExternalTool t) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        String strippedTitle = "ExternalTool." + StringUtils.stripMnemonic((String)props.getCaption()).replace(' ', '_');
        return ExternalToolAction.getExternalToolAction(Ide.findOrCreateCmdID((String)strippedTitle), t);
    }

    private IdeAction getExternalToolsAction() {
        return IdeAction.find((int)EXTERNAL_TOOLS_CMD_ID);
    }

    void addItem(ExternalTool t) {
        this.addMenu(t);
        this.addToolBarItem(t, true);
        this.deinstallKeystrokes();
        this.installKeystrokes();
    }

    void removeItem(ExternalTool t) {
        this.removeMenu(t);
        this.removeToolBarItems(t);
        this.deinstallKeystrokes();
        this.deregisterAction(t);
        this.installKeystrokes();
    }

    void delayedInstallItems() {
        Ide.addIdeListener((IdeListener)this);
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        try {
            new SwingClosure(){

                protected void runImpl() {
                    MenuManager.this.installItems();
                    Ide.removeIdeListener((IdeListener)MenuManager.this);
                }
            }.run();
        }
        catch (ClosureException closureException) {
            // empty catch block
        }
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    void installItems() {
        this.createMenus();
        this.createToolBarItems();
        this.installKeystrokes();
    }

    void uninstallItems() {
        this.removeMenus();
        this.removeToolBarItems();
        this.deinstallKeystrokes();
        this.deregisterActions();
    }

    private void installKeystrokes() {
        this.m_keyStrokeContext = new ToolKeyStrokeContext();
        Ide.getKeyStrokeContextRegistry().addContext((KeyStrokeContext)this.m_keyStrokeContext);
        Ide.getSettings().getKeyStrokeOptions().solvePostponedMaps();
    }

    private void deinstallKeystrokes() {
        if (this.m_keyStrokeContext != null) {
            Ide.getKeyStrokeContextRegistry().removeContext((KeyStrokeContext)this.m_keyStrokeContext);
        }
    }

    private static URL getURLifValidElement(Element e, Context ctx) {
        Node node;
        if (e != null && e instanceof Locatable && ((Locatable)e).getURL() != null) {
            return ((Locatable)e).getURL();
        }
        if (ctx != null && (node = ctx.getNode()) != null && node.getURL() != null) {
            return node.getURL();
        }
        return null;
    }

    private static boolean isValidElement(Element e, Context ctx) {
        Node node;
        if (e != null && e instanceof Locatable && ((Locatable)e).getURL() != null) {
            return true;
        }
        return ctx != null && (node = ctx.getNode()) != null && node.getURL() != null;
    }

    static boolean isToolEnabledInContext(ExternalTool tool, Context ctx) {
        URL u;
        Object e = ctx.getElement() != null ? ctx.getElement() : ctx.getNode();
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(tool);
        if (props.getAvailability() == Availability.ALWAYS) {
            return true;
        }
        if (props.getAvailability() == Availability.ANY_SELECTION) {
            return MenuManager.isValidElement(e, ctx);
        }
        if (props.getAvailability() == Availability.SELECTED_TYPES && (u = MenuManager.getURLifValidElement(e, ctx)) != null) {
            String fileExtension = URLFileSystem.getSuffix((URL)u);
            List<String> types = props.getAvailableTypes();
            boolean caseSensitive = URLFileSystem.isLocalFileSystemCaseSensitive();
            for (File extension : FileTypesRecognizer.allMappedExtensionsToNodes()) {
                String docClassName = FileTypesRecognizer.getClassNameForExtension((String)extension.getPath());
                if (!types.contains(docClassName)) continue;
                for (String thisExtension : FileTypesRecognizer.getNodeExtensions((String)docClassName)) {
                    if ((!caseSensitive || !thisExtension.equals(fileExtension)) && (caseSensitive || !thisExtension.equalsIgnoreCase(fileExtension))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private class ToolKeyStrokeContext
    extends DefaultKeyStrokeContext {
        private ToolKeyStrokeContext() {
        }

        public String getName() {
            return "ToolManager";
        }

        public Set getAllActions(boolean global) {
            if (global) {
                HashSet<IdeAction> set = new HashSet<IdeAction>();
                for (ExternalTool t : MenuManager.this.m_externalToolAddin.tools()) {
                    set.add(MenuManager.this.getIdeActionForTool(t));
                }
                set.add(MenuManager.this.getExternalToolsAction());
                return set;
            }
            return null;
        }

        protected void addGlobalKeyStrokes(KeyStrokeMap map) {
        }
    }
}

