/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.utilities;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CpatFileUtils {
    public static File getUniqueDir(String fileName) {
        return CpatFileUtils.getUniqueDirPath(fileName).toFile();
    }

    public static String getUniqueDirName(String fileName) {
        return CpatFileUtils.getUniqueDirPath(fileName).toString();
    }

    public static Path getUniqueDirPath(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return path;
        }
        int i = 1;
        String newFile = null;
        File file = new File(fileName);
        String dir = file.getParent();
        String name = file.getName();
        while (Files.exists(path, new LinkOption[0])) {
            newFile = name + i;
            ++i;
            path = Paths.get(dir + File.separator + newFile, new String[0]);
        }
        return path;
    }

    public static File getUniqueFile(String fileName) {
        return CpatFileUtils.getUniquePath(fileName).toFile();
    }

    public static File getUniqueFile(String dir, String fileName) {
        return CpatFileUtils.getUniquePath(dir, fileName).toFile();
    }

    public static String getUniqueFileName(String fileName) {
        return CpatFileUtils.getUniquePath(fileName).toString();
    }

    public static String getUniqueFileName(String dir, String fileName) {
        return CpatFileUtils.getUniquePath(dir, fileName).toString();
    }

    public static Path getUniquePath(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return path;
        }
        int i = 1;
        String newFile = null;
        File file = new File(fileName);
        String dir = file.getParent();
        String name = file.getName();
        while (Files.exists(path, new LinkOption[0])) {
            newFile = name.replace(".", i + ".");
            ++i;
            path = Paths.get(dir + File.separator + newFile, new String[0]);
        }
        return path;
    }

    public static Path getUniquePath(String dir, String fileName) {
        Path path = Paths.get(dir + "/" + fileName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return path;
        }
        int i = 1;
        String newFile = null;
        while (Files.exists(path, new LinkOption[0])) {
            newFile = fileName.replace(".", i + ".");
            ++i;
            path = Paths.get(dir + "/" + newFile, new String[0]);
        }
        return path;
    }

    public static Path concatDir(String root, String subdir) {
        return Paths.get(root + (String)(root.endsWith(File.separator) ? subdir : File.separator + subdir), new String[0]);
    }
}

