/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.ReportFormat;
import com.oracle.premigration.commons.enums.TargetCloud;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.AbstractCommandConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.BooleanValidator;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.DbSchemaListValidator;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.PositiveIntegerValidator;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.StringListValidator;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.StringValidator;

public class MigrateAdvisorOptions
extends AbstractCommandConstants {
    public static final String CMD_PARMS = "migrateadvisor.parms";
    public static final String BASE_COMMAND = "migrateadvisor";
    public static final String BASE_COMMAND_S = "ma";
    public static final String ADVISE = "advise";
    public static final String ADVISE_S = "ad";
    public static final String VERSION = "version";
    public static final String VERSION_S = "ve";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTIES_S = "pr";
    public static final Map<String, String> commandAliases = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(MigrateAdvisorOptions.ADVISE_S, MigrateAdvisorOptions.ADVISE);
            this.put(MigrateAdvisorOptions.PROPERTIES_S, MigrateAdvisorOptions.PROPERTIES);
            this.put("ve", MigrateAdvisorOptions.VERSION);
        }
    };
    public static final String ANALYSISPROPS = "analysisprops";
    public static final String ANALYSISPROPS_S = "a";
    public static final StandardParameter ANALYSISPROPS_P = StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).build();
    public static final String DEBUG = "debug";
    public static final String DEBUG_S = "de";
    public static final StandardParameter DEBUG_P = StandardParameter.withValidator(BooleanValidator.class).isStandard().allowedValues("true,false").build();
    public static final String EXCLUDESCHEMAS = "excludeschemas";
    public static final String EXCLUDESCHEMAS_S = "x";
    public static final StandardParameter EXCLUDESCHEMAS_P = StandardParameter.withValidator(DbSchemaListValidator.class).isStandard().paramCase(StandardParameter.CASE.UPPER).build();
    public static final String FULL = "full";
    public static final String FULL_S = "f";
    public static final StandardParameter FULL_P = StandardParameter.withValidator(BooleanValidator.class).isStandard().defaultValue("false").allowedValues("true,false").build();
    public static final String MAXRELEVANTOBJECTS = "maxrelevantobjects";
    public static final String MAXRELEVANTOBJECTS_S = "m";
    public static final StandardParameter MAXRELEVANTOBJECTS_P = StandardParameter.withValidator(PositiveIntegerValidator.class).isStandard().build();
    public static final String MAXTEXTDATAROWS = "maxtextdatarows";
    public static final String MAXTEXTDATAROWS_S = "d";
    public static final StandardParameter MAXTEXTDATAROWS_P = StandardParameter.withValidator(PositiveIntegerValidator.class).isStandard().build();
    public static final String MIGRATIONMETHOD = "migrationmethod";
    public static final String MIGRATIONMETHOD_S = "mm";
    public static final StandardParameter MIGRATIONMETHOD_P = StandardParameter.withValidator(StringListValidator.class).isStandard().defaultValue("datapump").allowedValues(MigrateAdvisorOptions.getMigrationMethodVV()).build();
    public static final String NOEXEC = "noexec";
    public static final String NOEXEC_S = "ne";
    public static final StandardParameter NOEXEC_P = StandardParameter.withValidator(BooleanValidator.class).isStandard().allowedValues("true,false").build();
    public static final String OUTDIR = "outdir";
    public static final String OUTDIR_S = "o";
    public static final StandardParameter OUTDIR_P = StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).build();
    public static final String OUTFILEPREFIX = "outfileprefix";
    public static final String OUTFILEPREFIX_S = "p";
    public static final StandardParameter OUTFILEPREFIX_P = StandardParameter.withValidator(StringValidator.class).isStandard().paramCase(StandardParameter.CASE.PERSIST).build();
    public static final String REPORTFORMAT = "reportformat";
    public static final String HTML = "html";
    public static final String REPORTFORMAT_S = "r";
    public static final StandardParameter REPORTFORMAT_P = StandardParameter.withValidator(StringListValidator.class).isStandard().paramCase(StandardParameter.CASE.UPPER).defaultValue("html").allowedValues(MigrateAdvisorOptions.getReportFormatVV()).build();
    public static final String SCHEMAS = "schemas";
    public static final String SCHEMAS_S = "s";
    public static final StandardParameter SCHEMAS_P = StandardParameter.withValidator(DbSchemaListValidator.class).isStandard().paramCase(StandardParameter.CASE.UPPER).build();
    public static final String SQLTEXT = "sqltext";
    public static final String SQLTEXT_S = "q";
    public static final StandardParameter SQLTEXT_P = StandardParameter.withValidator(BooleanValidator.class).isStandard().defaultValue("false").allowedValues("true,false").build();
    public static final String TARGETTYPE = "targettype";
    public static final String TARGETTYPE_S = "t";
    public static final StandardParameter TARGETTYPE_P = StandardParameter.withValidator(StringValidator.class).isStandard().isRequired(true).allowedValues(MigrateAdvisorOptions.getTargetTypeVV()).build();
    public static final String VERBOSE = "verbose";
    public static final String VERBOSE_S = "ve";
    public static final StandardParameter VERBOSE_P = StandardParameter.withValidator(BooleanValidator.class).isStandard().defaultValue("false").allowedValues("true,false").build();
    public static final Map<String, String> parameterAliases = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(MigrateAdvisorOptions.ANALYSISPROPS_S, MigrateAdvisorOptions.ANALYSISPROPS);
            this.put(MigrateAdvisorOptions.EXCLUDESCHEMAS_S, MigrateAdvisorOptions.EXCLUDESCHEMAS);
            this.put(MigrateAdvisorOptions.FULL_S, MigrateAdvisorOptions.FULL);
            this.put(MigrateAdvisorOptions.MAXRELEVANTOBJECTS_S, MigrateAdvisorOptions.MAXRELEVANTOBJECTS);
            this.put(MigrateAdvisorOptions.MAXTEXTDATAROWS_S, MigrateAdvisorOptions.MAXTEXTDATAROWS);
            this.put(MigrateAdvisorOptions.MIGRATIONMETHOD_S, MigrateAdvisorOptions.MIGRATIONMETHOD);
            this.put(MigrateAdvisorOptions.OUTDIR_S, MigrateAdvisorOptions.OUTDIR);
            this.put(MigrateAdvisorOptions.OUTFILEPREFIX_S, MigrateAdvisorOptions.OUTFILEPREFIX);
            this.put(MigrateAdvisorOptions.REPORTFORMAT_S, MigrateAdvisorOptions.REPORTFORMAT);
            this.put(MigrateAdvisorOptions.SCHEMAS_S, MigrateAdvisorOptions.SCHEMAS);
            this.put(MigrateAdvisorOptions.SQLTEXT_S, MigrateAdvisorOptions.SQLTEXT);
            this.put(MigrateAdvisorOptions.TARGETTYPE_S, MigrateAdvisorOptions.TARGETTYPE);
            this.put("ve", MigrateAdvisorOptions.VERBOSE);
        }
    };
    public static final Map<String, Map<String, StandardParameter>> commandModel = new HashMap<String, Map<String, StandardParameter>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(MigrateAdvisorOptions.ADVISE, new HashMap(Map.ofEntries(Map.entry(MigrateAdvisorOptions.ANALYSISPROPS, ANALYSISPROPS_P), Map.entry(MigrateAdvisorOptions.EXCLUDESCHEMAS, EXCLUDESCHEMAS_P), Map.entry(MigrateAdvisorOptions.FULL, FULL_P), Map.entry(MigrateAdvisorOptions.MAXRELEVANTOBJECTS, MAXRELEVANTOBJECTS_P), Map.entry(MigrateAdvisorOptions.MAXTEXTDATAROWS, MAXTEXTDATAROWS_P), Map.entry(MigrateAdvisorOptions.MIGRATIONMETHOD, MIGRATIONMETHOD_P), Map.entry(MigrateAdvisorOptions.OUTDIR, OUTDIR_P), Map.entry(MigrateAdvisorOptions.OUTFILEPREFIX, OUTFILEPREFIX_P), Map.entry(MigrateAdvisorOptions.REPORTFORMAT, REPORTFORMAT_P), Map.entry(MigrateAdvisorOptions.SCHEMAS, SCHEMAS_P), Map.entry(MigrateAdvisorOptions.SQLTEXT, SQLTEXT_P), Map.entry(MigrateAdvisorOptions.TARGETTYPE, TARGETTYPE_P), Map.entry(MigrateAdvisorOptions.VERBOSE, VERBOSE_P))));
            this.put(MigrateAdvisorOptions.PROPERTIES, new HashMap(Map.ofEntries(Map.entry(MigrateAdvisorOptions.OUTDIR, OUTDIR_P), Map.entry(MigrateAdvisorOptions.OUTFILEPREFIX, OUTFILEPREFIX_P), Map.entry(MigrateAdvisorOptions.VERBOSE, VERBOSE_P))));
            this.put(MigrateAdvisorOptions.VERSION, new HashMap());
        }
    };

    private static final String getMigrationMethodVV() {
        Object mm = "";
        for (MigrationMethod v : MigrationMethod.values()) {
            mm = (String)mm + v.toString().toLowerCase() + ",";
        }
        return ((String)mm).substring(0, ((String)mm).length() - 1);
    }

    private static final String getReportFormatVV() {
        Object rf = "";
        for (ReportFormat v : ReportFormat.values()) {
            rf = (String)rf + v.toString().toLowerCase() + ",";
        }
        rf = (String)rf + HTML;
        return rf;
    }

    private static final String getTargetTypeVV() {
        Object tt = "";
        for (TargetCloud v : TargetCloud.values()) {
            tt = (String)tt + v.toString().toLowerCase() + ",";
        }
        return ((String)tt).substring(0, ((String)tt).length() - 1);
    }

    public String getBaseCommandName() {
        return BASE_COMMAND;
    }

    public String getBaseCommandShortName() {
        return BASE_COMMAND_S;
    }

    public Map<String, String> getCommandAliases() {
        return commandAliases;
    }

    public Map<String, Map<String, StandardParameter>> getCommandModel() {
        return commandModel;
    }

    public String getHelpPropertiesFilename() {
        return "oracle.dbtools.migrateadvisor.help.Help";
    }

    public Map<String, String> getParameterAliases() {
        return parameterAliases;
    }

    public String getParameterSetName() {
        return CMD_PARMS;
    }

    public String getBackupHelpPropertiesFilename() {
        return null;
    }
}

