/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.Collections;
import java.util.List;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;

public class PlSqlFragmentElement
extends DBObjectFolder {
    private Boolean m_isPlSqlReference;
    private String m_label;

    public PlSqlFragmentElement(DBObject dBObject, DBObjectProvider dBObjectProvider, String string) {
        super(dBObject, dBObjectProvider, string);
    }

    public PlSqlFragmentElement(DBObjectNode dBObjectNode) {
        super(dBObjectNode);
    }

    public int getStartOffset() {
        DBObject dBObject = this.getDBObject();
        Integer n = null;
        if (dBObject instanceof DBObjectPlSqlFragment) {
            n = ((DBObjectPlSqlFragment)dBObject).getStartOffset();
        }
        return n == null ? 0 : n;
    }

    @Override
    protected DBObjectProvider useDBRunnable() {
        return this.getProvider();
    }

    @Override
    protected List<Element> createChildren(List<Element> list) throws CancelledException {
        boolean bl = true;
        DBObject dBObject = this.getObject();
        if (dBObject instanceof PlSqlSourceObject) {
            PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)((PlSqlSourceObject)dBObject), (DBObjectProvider)this.getProvider());
            bl = plSqlParser != null && !plSqlParser.isWrapped();
        }
        return bl ? super.createChildren(list) : Collections.emptyList();
    }

    @Override
    protected boolean isIgnoredProperty(PropertyInfo propertyInfo, DBObjectProvider dBObjectProvider, Object object) {
        String string = propertyInfo.getPropertyName();
        boolean bl = super.isIgnoredProperty(propertyInfo, dBObjectProvider, object);
        if (!bl && ("startOffset".equals(string) || "endOffset".equals(string) || "statementType".equals(string) || "properties".equals(string))) {
            bl = true;
        }
        if (!bl) {
            Class<?> clazz = propertyInfo.getPropertyClass();
            if (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            if (!(!DBObjectPlSqlFragment.class.isAssignableFrom(clazz) || "dataTypeReference".equals(string) || "returnTypeReference".equals(string) || PlSqlDatum.class.isAssignableFrom(clazz) || PlSqlSubProgram.class.isAssignableFrom(clazz))) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean mayHaveChildren() {
        if (this.isPlSqlReference()) {
            return false;
        }
        return super.mayHaveChildren();
    }

    @Override
    public String getShortLabel() {
        if (this.m_label == null) {
            if (this.isPlSqlReference()) {
                PlSqlReference plSqlReference = (PlSqlReference)this.getDBObject();
                this.m_label = this.createPropertyLabel(this.getProperty(), plSqlReference.toString(), plSqlReference.getParent());
            } else {
                this.m_label = super.getShortLabel();
            }
        }
        return this.m_label;
    }

    private boolean isPlSqlReference() {
        if (this.m_isPlSqlReference == null) {
            this.m_isPlSqlReference = Metadata.getInstance().isTypeOf(PlSqlReference.class, this.getObjectType());
        }
        return this.m_isPlSqlReference;
    }
}

