/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.model.ObjectFolder;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.ideimpl.db.explorer.model.PropertyNode;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.icons.OracleIcons;

final class DBTypeFolder
extends PropertyNode
implements DBObjectTypeNode {
    private Icon m_icon;

    public DBTypeFolder(PropertyInfo propertyInfo, DBObject dBObject, DBObjectProvider dBObjectProvider) {
        super(propertyInfo, dBObject, dBObjectProvider, true);
    }

    @Override
    protected List<Element> createChildren(List<Element> list) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        DBObjectProvider dBObjectProvider = this.getProvider();
        PropertyInfo propertyInfo = this.getPropertyInfo();
        Object object = propertyInfo.getPropertyValue(this.getParentObject());
        this.setObject(object);
        if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                DBExplorerElement dBExplorerElement = null;
                if (object2 instanceof DBObject) {
                    dBExplorerElement = ExplorerModelHelper.find(list, ExplorerModelHelper.getKeyForObject((DBObject)object2, propertyInfo.getPropertyName()));
                    if (dBExplorerElement instanceof DBObjectFolder) {
                        ((DBObjectFolder)dBExplorerElement).setObject((DBObject)object2);
                    } else {
                        dBExplorerElement = object2 instanceof DBObjectPlSqlFragment ? new PlSqlFragmentElement((DBObject)object2, dBObjectProvider, null) : new DBObjectFolder((DBObject)object2, dBObjectProvider, null);
                    }
                } else {
                    dBExplorerElement = new ObjectFolder(object2, dBObjectProvider, null);
                }
                if (dBExplorerElement == null) continue;
                dBExplorerElement.setHelper(this.getHelper());
                arrayList.add(dBExplorerElement);
            }
        } else if (object != null) {
            throw new IllegalStateException(this.getPropertyName() + ": DBTypeFolder is only valid for array props");
        }
        return arrayList;
    }

    public String getSchemaName() {
        return null;
    }

    public String getObjectType() {
        Class<?> clazz = this.getPropertyInfo().getPropertyClass();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return Metadata.getType((Class)clazz);
    }

    public Object getProviderIdentifier() {
        return this.getProvider().getProviderIdentifier();
    }

    public String getProviderType() {
        return this.getProvider().getProviderType();
    }

    @Override
    public Icon getIcon() {
        if (this.m_icon == null) {
            this.m_icon = DBTypeDisplayRegistry.getFolderIcon((String)this.getObjectType());
            if (this.m_icon == null) {
                this.m_icon = OracleIcons.getIcon((String)"folder.png");
            }
        }
        return this.m_icon;
    }

    @Override
    protected String createLabel() {
        return PropertyDisplayRegistry.getDisplayName((String)this.getPropertyName(), (DBObjectProvider)this.getProvider(), (DBObject)this.getParentDBObject());
    }

    @Override
    protected boolean sortChildren() {
        String string = this.getPropertyName();
        return "constraints".equals(string) || "indexes".equals(string);
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }
}

