/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.awt.Component;
import java.util.logging.Level;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.model.BasePlSqlTextNode;
import oracle.ideimpl.db.explorer.ExplorerController;
import oracle.ideimpl.db.explorer.resource.ExplorerBundle;
import oracle.javatools.db.DBLog;

public class ExplorerContextMenuListener
implements ContextMenuListener {
    public boolean handleDefaultAction(Context context) {
        boolean bl = false;
        if (ExplorerController.isEnabled(context)) {
            try {
                ExplorerController.getAction().performAction(context);
            }
            catch (Exception exception) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Error in Go to Source for pl/sql", exception);
            }
            bl = true;
        }
        return bl;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (ExplorerController.isEnabled(context)) {
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ExplorerController.getAction());
            if (context.getNode() instanceof BasePlSqlTextNode) {
                String string = ExplorerBundle.get("EXPLORER_GOTO_SOURCE");
                jMenuItem.setText(StringUtils.stripMnemonic((String)string));
                jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            }
            contextMenu.add((Component)jMenuItem);
        }
    }
}

