/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.DBObjectFolderFactory;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.util.Maps;

public final class ErrorSupport {
    private final Map<String, ErrorProvider> m_reg = new HashMap<String, ErrorProvider>();
    private final Map<URL, Element> m_folders = new Maps.WeakHashMap();

    public void registerErrorProvider(String string, ErrorProvider errorProvider) {
        this.m_reg.put(string, errorProvider);
    }

    public void setErrors(URL uRL, List<Element> list) {
        Element element = this.m_folders.get(uRL);
        if (element != null) {
            DBObjectFolderFactory.setErrors(element, list);
        }
    }

    private ErrorProvider getErrorProvider(DBObjectNode dBObjectNode) {
        String string;
        ErrorProvider errorProvider = null;
        if (dBObjectNode != null && (string = DBObjectNodeUtil.getProviderType((Object)dBObjectNode)) != null) {
            errorProvider = this.m_reg.get(string);
        }
        return errorProvider;
    }

    void startObserving(DBObjectNode dBObjectNode, Element element) {
        ErrorProvider errorProvider = this.getErrorProvider(dBObjectNode);
        if (errorProvider != null) {
            this.m_folders.put(dBObjectNode.getURL(), element);
            errorProvider.startObserving(dBObjectNode);
        }
    }

    void stopObserving(DBObjectNode dBObjectNode) {
        ErrorProvider errorProvider = this.getErrorProvider(dBObjectNode);
        if (errorProvider != null) {
            errorProvider.stopObserving(dBObjectNode);
            this.m_folders.remove(dBObjectNode.getURL());
        }
    }

    void update(DBObjectNode dBObjectNode, Element element) {
        ErrorProvider errorProvider = this.getErrorProvider(dBObjectNode);
        if (errorProvider != null && this.m_folders.containsKey(dBObjectNode.getURL())) {
            errorProvider.update(dBObjectNode, element);
        }
    }

    public static synchronized ErrorSupport getInstance() {
        DBCore dBCore = DBCore.getInstance();
        ErrorSupport errorSupport = (ErrorSupport)dBCore.get(ErrorSupport.class);
        if (errorSupport == null) {
            errorSupport = new ErrorSupport();
            dBCore.put((Object)errorSupport);
        }
        return errorSupport;
    }

    public static abstract class ErrorProvider {
        public void startObserving(DBObjectNode dBObjectNode) {
        }

        public void stopObserving(DBObjectNode dBObjectNode) {
        }

        public void update(DBObjectNode dBObjectNode, Element element) {
        }
    }
}

