/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server.parser.sparql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.FilterFuncHandler;
import oracle.spatial.rdf.server.OrderCond;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SelectExpression;
import oracle.spatial.rdf.server.TypeException;
import oracle.spatial.rdf.server.parser.sparql.ASTConditionalAndExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupClause;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupCondition;
import oracle.spatial.rdf.server.parser.sparql.ASTHavingClause;
import oracle.spatial.rdf.server.parser.sparql.ASTHavingCondition;
import oracle.spatial.rdf.server.parser.sparql.ASTLimitOffsetClauses;
import oracle.spatial.rdf.server.parser.sparql.ASTOrderClause;
import oracle.spatial.rdf.server.parser.sparql.ASTOrderCondition;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class SparqlSolnModDesc {
    private boolean solnModExists = false;
    private int solnOffset = -1;
    private int solnLimit = -1;
    private SQLGenContext ctx;
    private List<OrderCond> orderCondList = new ArrayList<OrderCond>();
    private List<SelectExpression> groupByList = new ArrayList<SelectExpression>();
    private Filter havingCond = null;
    private boolean havingModExist = false;
    private Node havingTree = null;

    public void setSQLGenCtx(SQLGenContext sQLGenContext) {
        this.ctx = sQLGenContext;
    }

    public void setInScopeVars(Set<String> set) {
        for (OrderCond object : this.orderCondList) {
            object.setInScopeVars(set);
        }
        for (SelectExpression selectExpression : this.groupByList) {
            selectExpression.setInScopeVars(set);
        }
        if (this.havingCond != null) {
            Set<String> set2 = this.getGroupByVars();
            this.havingCond.setInScopeVars(set2, set2);
        }
    }

    public void setDefBoundVars(Set<String> set) {
        for (OrderCond object : this.orderCondList) {
            object.setDefBoundVars(set);
        }
        for (SelectExpression selectExpression : this.groupByList) {
            selectExpression.setDefBoundVars(set);
        }
        if (this.havingCond != null) {
            this.havingCond.setDefBoundVars(set);
        }
    }

    public void initExpressions(SQLGenContext sQLGenContext) {
        this.setSQLGenCtx(sQLGenContext);
        for (OrderCond object : this.orderCondList) {
            object.initExpression(sQLGenContext);
        }
        for (SelectExpression selectExpression : this.groupByList) {
            selectExpression.initExpression(sQLGenContext);
        }
        if (this.havingTree != null) {
            this.havingCond = new Filter((SimpleNode)this.havingTree, sQLGenContext);
        }
    }

    public void prepareExpressions() throws RDFException {
        for (OrderCond object : this.orderCondList) {
            object.prepareExpression();
        }
        for (SelectExpression selectExpression : this.groupByList) {
            selectExpression.prepareExpression();
        }
        if (this.havingCond != null) {
            this.havingCond.init();
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        SparqlSolnModDesc sparqlSolnModDesc = new SparqlSolnModDesc();
        sparqlSolnModDesc.setSolnModExists(this.solnModExists);
        sparqlSolnModDesc.setLimit(this.solnLimit);
        sparqlSolnModDesc.setOffset(this.solnOffset);
        sparqlSolnModDesc.setSQLGenCtx(this.ctx);
        sparqlSolnModDesc.setHavingCond(this.havingCond, this.havingModExist);
        sparqlSolnModDesc.setHavingTree(this.havingTree);
        for (OrderCond object : this.orderCondList) {
            try {
                sparqlSolnModDesc.addOrderCond((OrderCond)object.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                System.out.println("Error cloning query tree [SparqlSolnModDesc]");
                cloneNotSupportedException.printStackTrace();
            }
        }
        for (SelectExpression selectExpression : this.groupByList) {
            try {
                sparqlSolnModDesc.addGroupCond((SelectExpression)selectExpression.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                System.out.println("Error cloning query tree [SparqlSolnModDesc]");
                cloneNotSupportedException.printStackTrace();
            }
        }
        return sparqlSolnModDesc;
    }

    public void populateSolnMod(Node node) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.offer(node);
        while (!linkedList.isEmpty()) {
            Node node2 = (Node)linkedList.remove();
            int n = ((SimpleNode)node2).id;
            if (n == 18) {
                this.populateOrderConds((ASTOrderClause)node2);
                continue;
            }
            if (n == 20) {
                this.populateLimitOffset((ASTLimitOffsetClauses)node2);
                continue;
            }
            if (n == 14) {
                this.populateGroupByList((ASTGroupClause)node2);
                continue;
            }
            if (n == 16) {
                this.populateHavingCond((ASTHavingClause)node2);
                continue;
            }
            if (n == 48 || n == 8) continue;
            for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
                linkedList.offer(node2.jjtGetChild(i));
            }
        }
    }

    public void cleanupOrderConds(Set<String> set) throws RDFException {
        for (OrderCond orderCond : this.orderCondList) {
            orderCond.processUnDefVars(set);
        }
    }

    public Set<String> getVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (OrderCond orderCond : this.orderCondList) {
            hashSet.addAll(orderCond.getVars());
        }
        return hashSet;
    }

    public Set<String> getGroupByVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (SelectExpression selectExpression : this.groupByList) {
            Filter filter = selectExpression.getExpr();
            if (filter != null) continue;
            hashSet.addAll(selectExpression.getVars());
        }
        return hashSet;
    }

    public Set<String> getAllGroupByVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (SelectExpression selectExpression : this.groupByList) {
            hashSet.addAll(selectExpression.getVars());
        }
        return hashSet;
    }

    public Set<String> getAllGroupByJoinVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (SelectExpression selectExpression : this.groupByList) {
            hashSet.addAll(selectExpression.getJoinVars());
        }
        return hashSet;
    }

    private void populateLimitOffset(ASTLimitOffsetClauses aSTLimitOffsetClauses) {
        for (int i = 0; i < aSTLimitOffsetClauses.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode = (SimpleNode)aSTLimitOffsetClauses.jjtGetChild(i);
            if (simpleNode.id == 21) {
                this.solnLimit = Integer.parseInt(((ASTTripleAtom)simpleNode.jjtGetChild((int)0)).name);
                continue;
            }
            if (simpleNode.id != 22) continue;
            this.solnOffset = Integer.parseInt(((ASTTripleAtom)simpleNode.jjtGetChild((int)0)).name);
        }
    }

    private void populateOrderConds(ASTOrderClause aSTOrderClause) {
        for (int i = 0; i < aSTOrderClause.jjtGetNumChildren(); ++i) {
            ASTOrderCondition aSTOrderCondition = (ASTOrderCondition)aSTOrderClause.jjtGetChild(i);
            OrderCond orderCond = new OrderCond();
            orderCond.setDir(aSTOrderCondition.dir);
            SimpleNode simpleNode = (SimpleNode)aSTOrderCondition.jjtGetChild(0);
            if (simpleNode.id == 73) {
                if (((ASTTripleAtom)simpleNode).type == 0) {
                    orderCond.setVar((ASTTripleAtom)simpleNode);
                } else {
                    orderCond.setExprTree(simpleNode);
                }
            } else {
                orderCond.setExprTree(simpleNode);
            }
            this.orderCondList.add(orderCond);
        }
    }

    private void populateGroupByList(ASTGroupClause aSTGroupClause) {
        for (int i = 0; i < aSTGroupClause.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode;
            ASTGroupCondition aSTGroupCondition = (ASTGroupCondition)aSTGroupClause.jjtGetChild(i);
            SelectExpression selectExpression = new SelectExpression();
            if (aSTGroupCondition.jjtGetNumChildren() > 1) {
                simpleNode = (SimpleNode)aSTGroupCondition.jjtGetChild(0);
                SimpleNode simpleNode2 = (SimpleNode)aSTGroupCondition.jjtGetChild(1);
                selectExpression.setVar((ASTTripleAtom)simpleNode2);
                selectExpression.setExprTree(simpleNode);
            } else {
                simpleNode = (SimpleNode)aSTGroupCondition.jjtGetChild(0);
                if (simpleNode.id == 73) {
                    if (((ASTTripleAtom)simpleNode).type == 0) {
                        selectExpression.setVar((ASTTripleAtom)simpleNode);
                    } else {
                        selectExpression.setExprTree(simpleNode);
                    }
                } else {
                    selectExpression.setExprTree(simpleNode);
                }
            }
            this.groupByList.add(selectExpression);
        }
    }

    private void populateHavingCond(ASTHavingClause aSTHavingClause) {
        int n = aSTHavingClause.jjtGetNumChildren();
        if (n > 1) {
            this.havingTree = new ASTHavingCondition(17);
            ASTConditionalAndExpression aSTConditionalAndExpression = new ASTConditionalAndExpression(79);
            this.havingTree.jjtAddChild(aSTConditionalAndExpression, 0);
            aSTConditionalAndExpression.jjtSetParent(this.havingTree);
            for (int i = 0; i < n; ++i) {
                SimpleNode simpleNode = (SimpleNode)aSTHavingClause.jjtGetChild(i).jjtGetChild(0);
                aSTConditionalAndExpression.jjtAddChild(simpleNode, i);
                simpleNode.jjtSetParent(aSTConditionalAndExpression);
            }
        } else {
            this.havingTree = (SimpleNode)aSTHavingClause.jjtGetChild(0);
        }
        this.havingModExist = true;
    }

    public void validateFilters() throws RDFException {
        try {
            for (SelectExpression object : this.groupByList) {
                object.validateFilter();
            }
            if (this.havingCond != null) {
                this.havingCond.validateFilter(this.ctx.funcTypeMap);
            }
            for (OrderCond orderCond : this.orderCondList) {
                orderCond.validateFilter();
            }
        }
        catch (TypeException typeException) {
            throw new RDFException(typeException.getMessage());
        }
        catch (RDFException rDFException) {
            throw rDFException;
        }
    }

    public void processUnDefVarsForGroupBy(Set<String> set) throws RDFException {
        for (SelectExpression selectExpression : this.groupByList) {
            selectExpression.processUnDefVars(set);
        }
        if (this.havingCond != null) {
            QueryUtils.processUnDefVars(this.havingCond, set, this.ctx);
            this.havingTree = this.havingCond.getFilterTree();
        }
    }

    public String toString() {
        String string = "";
        string = string + "=======================================\n";
        string = string + "Solution Modifier\n";
        string = string + "=======================================\n";
        string = string + "solnModExists: " + this.solnModExists + "\n";
        string = string + "Group By: \n";
        for (SelectExpression object : this.groupByList) {
            string = string + object.toString("");
        }
        if (this.havingTree != null) {
            string = string + "having: " + ((SimpleNode)this.havingTree).dumpToStr("");
        }
        string = string + "solnOffset: " + this.solnOffset + "\n";
        string = string + "solnLimit: " + this.solnLimit + "\n";
        string = string + "Order By: \n";
        for (OrderCond orderCond : this.orderCondList) {
            string = string + orderCond.toString();
        }
        string = string + "=======================================\n";
        return string;
    }

    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "=======================================\n";
        string2 = string2 + string + "Solution Modifier\n";
        string2 = string2 + string + "=======================================\n";
        string2 = string2 + string + "solnModExists: " + this.solnModExists + "\n";
        string2 = string2 + string + "Group By: \n";
        for (SelectExpression object : this.groupByList) {
            string2 = string2 + object.toString(string);
        }
        if (this.havingTree != null) {
            string2 = string2 + string + "Having:\n" + ((SimpleNode)this.havingTree).dumpToStr(string);
        }
        string2 = string2 + string + "solnOffset: " + this.solnOffset + "\n";
        string2 = string2 + string + "solnLimit: " + this.solnLimit + "\n";
        string2 = string2 + string + "Order By: \n";
        for (OrderCond orderCond : this.orderCondList) {
            string2 = string2 + orderCond.toString(string);
        }
        string2 = string2 + string + "=======================================\n";
        return string2;
    }

    public String toString(Map<String, String> map, Map<String, String> map2, Map<String, FilterFuncHandler> map3) {
        String string = "";
        string = string + "=======================================\n";
        string = string + "Solution Modifier\n";
        string = string + "=======================================\n";
        string = string + "solnModExists: " + this.solnModExists + "\n";
        string = string + "solnOffset: " + this.solnOffset + "\n";
        string = string + "solnLimit: " + this.solnLimit + "\n";
        string = string + "Order By: \n";
        for (OrderCond orderCond : this.orderCondList) {
            string = string + orderCond.toString(map, map2, map3);
        }
        string = string + "=======================================\n";
        return string;
    }

    public List<OrderCond> getOrderConds() {
        return this.orderCondList;
    }

    public void setOrderConds(List<OrderCond> list) {
        this.orderCondList = list;
    }

    public List<SelectExpression> getGroupByConds() {
        return this.groupByList;
    }

    public void setGroupByConds(List<SelectExpression> list) {
        this.groupByList = list;
    }

    public Filter getHavingConds() {
        return this.havingCond;
    }

    public void setSolnModExists(boolean bl) {
        this.solnModExists = bl;
    }

    public boolean solnModExists() {
        return this.solnModExists;
    }

    public boolean hasLimit() {
        return this.solnLimit >= 0;
    }

    public boolean hasOffset() {
        return this.solnOffset >= 0;
    }

    public boolean hasGroupBy() {
        return this.groupByList.size() > 0;
    }

    public boolean hasHaving() {
        return this.havingModExist;
    }

    public int getLimit() {
        return this.solnLimit;
    }

    public int getOffset() {
        return this.solnOffset;
    }

    public void setLimit(int n) {
        this.solnLimit = n;
    }

    public void setOffset(int n) {
        this.solnOffset = n;
    }

    public void addOrderCond(OrderCond orderCond) {
        this.orderCondList.add(orderCond);
    }

    public void addGroupCond(SelectExpression selectExpression) {
        this.groupByList.add(selectExpression);
    }

    public void setHavingCond(Filter filter, boolean bl) {
        this.havingCond = filter;
        this.havingModExist = bl;
    }

    public Node getHavingTree() {
        return this.havingTree;
    }

    public void setHavingTree(Node node) {
        this.havingTree = node;
    }

    public void setLexVars(Set<String> set) {
        for (OrderCond object : this.getOrderConds()) {
            object.setLexVars(set);
        }
        for (SelectExpression selectExpression : this.getGroupByConds()) {
            selectExpression.setLexVars(set);
        }
        if (this.havingModExist) {
            this.havingCond.setLexVars(set);
        }
    }
}

