/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Arrays;
import java.util.List;
import oracle.spatial.rdf.server.FilterFuncHandler;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;

public class XSDConstructFilterHandler
implements FilterFuncHandler {
    public static final String BOOL_OP = "sem_apis.castToBoolean";
    public static final String DOUBLE_OP = "sem_apis.castToDouble";
    public static final String FLOAT_OP = "sem_apis.castToFloat";
    public static final String DECIMAL_OP = "sem_apis.castToDecimal";
    public static final String INTEGER_OP = "sem_apis.castToInteger";
    public static final String DATETIME_OP = "sem_apis.castToDateTime";
    public static final String STRING_OP = "sem_apis.castToString";

    @Override
    public String genSQL(List<String[]> list, String string, String string2) throws RDFException {
        String string3 = "";
        String string4 = "";
        int[] nArray = new int[]{1, 2, 3, 4, 5};
        if (list.size() != 1) {
            throw new RDFException("Invalid number of arguments to " + string + ". Expecting 1 argument");
        }
        if (string.equals("http://www.w3.org/2001/XMLSchema#string")) {
            string4 = STRING_OP;
            nArray = new int[]{1, 2, 3, 4, 5, 6};
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#boolean")) {
            string4 = BOOL_OP;
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#dateTime")) {
            if (string2.contains(" TABLE_REWRITE=FALSE ") && !string2.contains(" SQL_XSD_CAST=FALSE ")) {
                return this.castToDateTime(list);
            }
            string4 = DATETIME_OP;
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#integer") || string.equals("http://www.w3.org/2001/XMLSchema#int")) {
            if (!string2.contains(" SQL_XSD_CAST=FALSE ")) {
                return "FLOOR(" + this.castToDecimal(list) + ")";
            }
            string4 = INTEGER_OP;
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#decimal")) {
            if (!string2.contains(" SQL_XSD_CAST=FALSE ")) {
                return this.castToDecimal(list);
            }
            string4 = DECIMAL_OP;
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#double")) {
            if (!string2.contains(" SQL_XSD_CAST=FALSE ")) {
                return "TO_BINARY_DOUBLE(" + this.castToDecimal(list) + ")";
            }
            string4 = DOUBLE_OP;
        } else if (string.equals("http://www.w3.org/2001/XMLSchema#float")) {
            if (!string2.contains(" SQL_XSD_CAST=FALSE ")) {
                return "TO_BINARY_FLOAT(" + this.castToDecimal(list) + ")";
            }
            string4 = FLOAT_OP;
        } else {
            throw new RDFException("Unrecognized XSD constructor function");
        }
        string3 = QueryUtils.buildFuncCall(string4, nArray, Arrays.asList((Object[])list.get(0)));
        if (string4 == BOOL_OP) {
            string3 = "(" + string3 + " = 1)";
        }
        return string3;
    }

    private String castToDecimal(List<String[]> list) {
        return "(CASE WHEN " + list.get(0)[4] + "='" + "http://www.w3.org/2001/XMLSchema#boolean" + "' THEN\nDECODE(UPPER(" + list.get(0)[2] + "), '1', 1, 'TRUE', 1, '0', 0, 'FALSE', 0)\nWHEN " + list.get(0)[1] + " NOT IN ('UR','URI','BN','BLN') AND (" + list.get(0)[4] + " IS NULL OR " + list.get(0)[4] + " IN ('" + "http://www.w3.org/2001/XMLSchema#string" + "','" + "http://www.w3.org/2001/XMLSchema#double" + "','" + "http://www.w3.org/2001/XMLSchema#float" + "','" + "http://www.w3.org/2001/XMLSchema#decimal" + "','" + "http://www.w3.org/2001/XMLSchema#integer" + "','" + "http://www.w3.org/2001/XMLSchema#int" + "','" + "http://www.w3.org/2001/XMLSchema#nonPositiveInteger" + "','" + "http://www.w3.org/2001/XMLSchema#negativeInteger" + "','" + "http://www.w3.org/2001/XMLSchema#long" + "','" + "http://www.w3.org/2001/XMLSchema#short" + "','" + "http://www.w3.org/2001/XMLSchema#byte" + "','" + "http://www.w3.org/2001/XMLSchema#nonNegativeInteger" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedLong" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedInt" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedShort" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedByte" + "','" + "http://www.w3.org/2001/XMLSchema#positiveInteger" + "')) THEN\nTO_NUMBER(" + list.get(0)[2] + " DEFAULT NULL ON CONVERSION ERROR)\nELSE NULL END)";
    }

    private String castToDateTime(List<String[]> list) {
        return "(CASE WHEN " + list.get(0)[1] + " NOT IN ('UR','URI','BN','BLN') AND\n(" + list.get(0)[4] + " IS NULL OR " + list.get(0)[4] + " IN('" + "http://www.w3.org/2001/XMLSchema#dateTime" + "','" + "http://www.w3.org/2001/XMLSchema#date" + "','" + "http://www.w3.org/2001/XMLSchema#string" + "'))\nTHEN COALESCE(TO_TIMESTAMP_TZ(" + list.get(0)[2] + "||" + "'Z'" + " DEFAULT NULL ON CONVERSION ERROR," + "'SYYYY-MM-DDTZH:TZM'" + "),TO_TIMESTAMP_TZ(" + list.get(0)[2] + " DEFAULT NULL ON CONVERSION ERROR," + "'SYYYY-MM-DDTZH:TZM'" + "),TO_TIMESTAMP_TZ(" + list.get(0)[2] + "||" + "'Z'" + " DEFAULT NULL ON CONVERSION ERROR," + "'SYYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM'" + "),TO_TIMESTAMP_TZ(" + list.get(0)[2] + " DEFAULT NULL ON CONVERSION ERROR," + "'SYYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM'" + ")) ELSE NULL END)";
    }
}

