/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SparqlFilterOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTBooleanSpecialNode;
import oracle.spatial.rdf.server.parser.sparql.ASTBuiltInCall;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class UnDefVarFilterOptimizer
implements SparqlFilterOptimizer {
    private Set<String> patternVars;
    private Map<String, String> funcTypeMap;
    private Set<String> allInScopeVars;
    private Set<String> pfInScopeVars;
    private static final String[] EXISTS_FUNCS = new String[]{"EXISTS", "NOT EXISTS"};
    private static final String[] COALESCE_FUNC = new String[]{"COALESCE"};
    private static final String[] BOUND_FUNC = new String[]{"BOUND"};
    private SQLGenContext ctx;

    public UnDefVarFilterOptimizer(Set<String> set, SQLGenContext sQLGenContext) {
        this(set, new HashSet<String>(), new HashSet<String>(), sQLGenContext);
    }

    public UnDefVarFilterOptimizer(Set<String> set, Set<String> set2, Set<String> set3, SQLGenContext sQLGenContext) {
        this.patternVars = set;
        this.funcTypeMap = sQLGenContext.funcTypeMap;
        this.allInScopeVars = set2;
        this.pfInScopeVars = set3;
        this.ctx = sQLGenContext;
    }

    @Override
    public Node optimizeFilter(Node node) throws RDFException, FilterException {
        int n;
        if (this.isBuiltInFuncNode((SimpleNode)node, EXISTS_FUNCS)) {
            return node;
        }
        boolean bl = OptimizerUtils.containsTextFilter(node);
        Node node2 = node.cloneSubTree();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Node[] nodeArray = new Node[1];
        boolean[] blArray = new boolean[1];
        arrayList.add(node2);
        arrayList2.add(new Integer(0));
        nodeArray[0] = node2;
        blArray[0] = true;
        for (n = 0; blArray[0] && n < 10000; ++n) {
            blArray[0] = false;
            this.removeSingleBadVar(nodeArray[0], arrayList, arrayList2, nodeArray, blArray, bl);
        }
        if (n >= 10000) {
            throw new FilterException("UnDefVarFilterOptimizer: entered infinite loop when optimizing query tree");
        }
        Node node3 = nodeArray[0];
        return nodeArray[0];
    }

    private void removeSingleBadVar(Node node, List<Node> list, List<Integer> list2, Node[] nodeArray, boolean[] blArray, boolean bl) throws RDFException {
        block10: {
            Node node2;
            block11: {
                Node node3;
                Node node4 = null;
                node2 = null;
                Node node5 = null;
                if (blArray[0]) break block10;
                if (!this.isBadVarNode((SimpleNode)node)) break block11;
                if (bl) {
                    String string = "";
                    try {
                        string = nodeArray[0].printSPARQLText();
                    }
                    catch (ParseException parseException) {
                        throw new RDFException(parseException.getMessage());
                    }
                    throw new RDFException("Undefined variable ?" + ((ASTTripleAtom)node).name + " appears in " + string);
                }
                for (int i = list.size() - 2; i >= 0 && !blArray[0]; --i) {
                    node4 = list.get(i);
                    if (Filter.getNodeRetType((SimpleNode)node4, this.funcTypeMap, this.ctx) == 2) {
                        blArray[0] = true;
                        node3 = new ASTBooleanSpecialNode(((SimpleNode)node4).parser, -1);
                        ((ASTBooleanSpecialNode)node3).name = this.isBuiltInFuncNode((SimpleNode)node4, BOUND_FUNC) ? "(1=0)" : "(null=null)";
                        if (i != 0) {
                            node5 = list.get(i - 1);
                            node5.jjtAddChild(node3, list2.get(i));
                            ((SimpleNode)node3).jjtSetParent(node5);
                            continue;
                        }
                        nodeArray[0] = node3;
                        continue;
                    }
                    if (!this.isBuiltInFuncNode((SimpleNode)node4, COALESCE_FUNC)) continue;
                    blArray[0] = true;
                    node3 = new ASTBooleanSpecialNode(((SimpleNode)nodeArray[0]).parser, -1);
                    ((ASTBooleanSpecialNode)node3).name = "(null=null)";
                    node4.jjtAddChild(node3, list2.get(i + 1));
                    ((SimpleNode)node3).jjtSetParent(node4);
                }
                if (!blArray[0]) {
                    ASTBooleanSpecialNode aSTBooleanSpecialNode = new ASTBooleanSpecialNode(((SimpleNode)nodeArray[0]).parser, -1);
                    aSTBooleanSpecialNode.name = "(null=null)";
                    if (((SimpleNode)nodeArray[0]).id == 56) {
                        node3 = nodeArray[0].cloneNode();
                        node3.jjtSetParent(nodeArray[0].jjtGetParent());
                        aSTBooleanSpecialNode.jjtSetParent(node3);
                        node3.jjtAddChild(aSTBooleanSpecialNode, 0);
                        nodeArray[0] = node3;
                    } else {
                        nodeArray[0] = aSTBooleanSpecialNode;
                    }
                    blArray[0] = true;
                }
                break block10;
            }
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node2 = node.jjtGetChild(i);
                if (this.isBuiltInFuncNode((SimpleNode)node2, EXISTS_FUNCS)) continue;
                list.add(node2);
                list2.add(new Integer(i));
                this.removeSingleBadVar(node2, list, list2, nodeArray, blArray, bl);
                list.remove(list.size() - 1);
                list2.remove(list2.size() - 1);
            }
        }
    }

    private boolean isBadVarNode(SimpleNode simpleNode) throws RDFException {
        boolean bl = false;
        if (simpleNode.id == 73) {
            ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
            if (aSTTripleAtom.type == 0 && !this.patternVars.contains(aSTTripleAtom.name) && !this.pfInScopeVars.contains(aSTTripleAtom.name)) {
                bl = true;
                if (this.allInScopeVars.contains(aSTTripleAtom.name)) {
                    throw new RDFException("Illegal reference of variable " + aSTTripleAtom.name + " inside FILTER within EXISTS pattern");
                }
            }
        }
        return bl;
    }

    private boolean isBuiltInFuncNode(SimpleNode simpleNode, String[] stringArray) {
        boolean bl = false;
        if (simpleNode.id == 88) {
            String string = ((ASTBuiltInCall)simpleNode).name;
            for (int i = 0; i < stringArray.length && !bl; ++i) {
                if (!string.equals(stringArray[i])) continue;
                bl = true;
            }
        }
        return bl;
    }
}

