/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.spatial.rdf.server.BasicGraphPattern;
import oracle.spatial.rdf.server.HintEngine;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SelectivityEstimator;
import oracle.spatial.rdf.server.SelectivityOptimizer;
import oracle.spatial.rdf.server.TriplesBlock;

public class SimpleSelectivityOptimizer
implements SelectivityOptimizer {
    SelectivityEstimator estimator;

    public SimpleSelectivityOptimizer(SelectivityEstimator selectivityEstimator) {
        if (selectivityEstimator == null) {
            throw new IllegalArgumentException("can not create optimizer with null estimator");
        }
        this.estimator = selectivityEstimator;
    }

    public SelectivityEstimator getSelectivityEstimator() {
        return this.estimator;
    }

    @Override
    public SelectivityOptimizer.Plan optimize(SQLGenContext sQLGenContext, SPARQLBGP sPARQLBGP) throws SQLException {
        boolean bl = HintEngine.getSessionContext().isLogStats();
        long l = 0L;
        BasicGraphPattern basicGraphPattern = new BasicGraphPattern();
        basicGraphPattern.addAll(sPARQLBGP.getTriplesBlocks(), sQLGenContext);
        HashSet<TriplesBlock> hashSet = new HashSet<TriplesBlock>(basicGraphPattern.getTriplesList());
        if (hashSet.isEmpty()) {
            return null;
        }
        HashSet<SelectivityEstimator.Model> hashSet2 = new HashSet<SelectivityEstimator.Model>();
        boolean bl2 = false;
        if (sQLGenContext.vmViewName != null) {
            if (sQLGenContext.models.length != 1) {
                System.err.printf("[%5s] %7s: %s\n", "stats", "warning", "multiple models specified with virtual model");
            }
            bl2 = true;
        }
        for (String object : sQLGenContext.models) {
            hashSet2.add(new SelectivityEstimator.Model(object, bl2));
        }
        ArrayList<SelectivityEstimator.Stats> arrayList = new ArrayList<SelectivityEstimator.Stats>();
        if (bl) {
            l = System.currentTimeMillis();
        }
        Set<SelectivityEstimator.Stats> set = this.estimator.getTripleStats(sQLGenContext.conn, hashSet2, sPARQLBGP, hashSet);
        if (bl) {
            SimpleSelectivityOptimizer.logDuration("Collected stats", l);
        }
        block1: for (TriplesBlock triplesBlock : basicGraphPattern.getTriplesList()) {
            for (SelectivityEstimator.Stats stats : set) {
                if (!triplesBlock.equals(stats.getTriple())) continue;
                arrayList.add(stats);
                continue block1;
            }
            System.err.printf("[%5s] %7s: %s\n", "stats", "warning", "could not find statistics for triple: " + triplesBlock);
        }
        LinkedList<SelectivityEstimator.Stats> linkedList = new LinkedList<SelectivityEstimator.Stats>();
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.addAll(sPARQLBGP.getJoinVarsForHint());
        SimpleComparator simpleComparator = new SimpleComparator(hashSet3, linkedList);
        Collections.sort(arrayList, simpleComparator);
        assert (arrayList.size() == hashSet.size()) : "sorted query not the same size as original. found, " + arrayList.size() + ", expected " + hashSet.size();
        while (!arrayList.isEmpty()) {
            SelectivityEstimator.Stats stats = (SelectivityEstimator.Stats)arrayList.remove(0);
            linkedList.add(stats);
            hashSet3.addAll(stats.getVars());
            Collections.sort(arrayList, simpleComparator);
        }
        if (bl) {
            l = System.currentTimeMillis();
        }
        SelectivityOptimizer.Plan plan = SimpleSelectivityOptimizer.createExecutionPlan(sPARQLBGP, linkedList);
        if (bl) {
            SimpleSelectivityOptimizer.logDuration("Execution plan created", l);
        }
        return plan;
    }

    private static SelectivityOptimizer.Plan createExecutionPlan(SPARQLBGP sPARQLBGP, List<SelectivityEstimator.Stats> list) {
        SelectivityOptimizer.Op op = null;
        for (SelectivityEstimator.Stats stats : list) {
            SelectivityOptimizer.Op.Data data = new SelectivityOptimizer.Op.Data(stats);
            if (op == null) {
                op = SimpleSelectivityOptimizer.determineAccess(data, stats);
                continue;
            }
            SelectivityOptimizer.Op.Access access = SimpleSelectivityOptimizer.determineAccess(data, stats);
            op = new SelectivityOptimizer.Op.Join(SelectivityOptimizer.Op.Join.Type.HASH, op, access);
        }
        return new SelectivityOptimizer.Plan(op);
    }

    private static SelectivityOptimizer.Op.Access determineAccess(SelectivityOptimizer.Op.Data data, SelectivityEstimator.Stats stats) {
        return new SelectivityOptimizer.Op.Access(SelectivityOptimizer.Op.Access.Type.FULL, data);
    }

    private static void logDuration(String string, long l) {
        System.out.printf("[%5s] %7s: %s\n", "stats", "debug", String.format("%2$6.2f s | %1$s", string, (double)(System.currentTimeMillis() - l) / 1000.0));
    }

    private static class SimpleComparator
    implements Comparator<SelectivityEstimator.Stats> {
        private Collection<String> variables;
        private Collection<SelectivityEstimator.Stats> triplesSoFar;

        public SimpleComparator(Collection<String> collection, Collection<SelectivityEstimator.Stats> collection2) {
            this.triplesSoFar = collection2;
            this.variables = collection;
        }

        private boolean isTripleSimilar(SelectivityEstimator.Stats stats) {
            TriplesBlock triplesBlock = stats.getTriple();
            TriplesBlock.Element[] elementArray = new TriplesBlock.Element[]{triplesBlock.getSubject(), triplesBlock.getPredicate(), triplesBlock.getObject()};
            block0: for (SelectivityEstimator.Stats stats2 : this.triplesSoFar) {
                TriplesBlock triplesBlock2 = stats2.getTriple();
                TriplesBlock.Element[] elementArray2 = new TriplesBlock.Element[]{triplesBlock2.getSubject(), triplesBlock2.getPredicate(), triplesBlock2.getObject()};
                for (int i = 0; i < elementArray.length; ++i) {
                    if (!elementArray[i].equals(elementArray2[i]) && (!elementArray[i].isVariable() || this.variables.contains(elementArray[i].getName()))) continue block0;
                }
                return true;
            }
            return false;
        }

        @Override
        public int compare(SelectivityEstimator.Stats stats, SelectivityEstimator.Stats stats2) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2;
            if (this.variables.isEmpty()) {
                bigDecimal2 = BigDecimal.ZERO;
                bigDecimal = BigDecimal.ZERO;
            } else {
                int n = stats.numVarsInCommon(this.variables);
                int n2 = stats2.numVarsInCommon(this.variables);
                bigDecimal2 = new BigDecimal(n);
                if (n == 0) {
                    bigDecimal2 = BigDecimal.ZERO;
                }
                bigDecimal = new BigDecimal(n2);
                if (n2 == 0) {
                    bigDecimal = BigDecimal.ZERO;
                }
                if (bigDecimal2 != BigDecimal.ZERO) {
                    bigDecimal2 = bigDecimal2.divide(new BigDecimal(stats.getNumVars()), MathContext.DECIMAL64);
                }
                if (bigDecimal != BigDecimal.ZERO) {
                    bigDecimal = bigDecimal.divide(new BigDecimal(stats2.getNumVars()), MathContext.DECIMAL64);
                }
            }
            boolean bl = this.isTripleSimilar(stats);
            boolean bl2 = this.isTripleSimilar(stats2);
            if (bigDecimal2.compareTo(bigDecimal) == 0) {
                if (bl && !bl2) {
                    return 1;
                }
                if (!bl && bl2) {
                    return -1;
                }
                int n = stats.getSelectivity().compareTo(stats2.getSelectivity());
                if (n != 0) {
                    return n;
                }
                return stats.getNumVars() - stats2.getNumVars();
            }
            if (bigDecimal2 == BigDecimal.ZERO && bigDecimal != BigDecimal.ZERO) {
                return 1;
            }
            if (bigDecimal2 != BigDecimal.ZERO && bigDecimal == BigDecimal.ZERO) {
                return -1;
            }
            if (bl && !bl2) {
                return 1;
            }
            if (!bl && bl2) {
                return -1;
            }
            if (bigDecimal2.compareTo(bigDecimal) < 0) {
                return 1;
            }
            if (bigDecimal2.compareTo(bigDecimal) > 0) {
                return -1;
            }
            System.err.printf("[stats] warning: reached unreachable statement. Enable assertions for more details.\n", new Object[0]);
            assert (false) : "SimpleComparator reached unreachable statement. \n\tcommon1 : " + bigDecimal2 + "\n\tcommon2 : " + bigDecimal + "\n\ts1 nums : " + stats.getNumMatching() + "\n\ts2 nums : " + stats2.getNumMatching() + "\n\ts1 vars : " + stats.getNumVars() + "\n\ts2 vars : " + stats2.getNumVars();
            return 0;
        }
    }
}

