/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.AbstractSPARQLTreeNode;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.ServiceSPARQLTreeNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class SimpleSPARQLTreeNode
extends AbstractSPARQLTreeNode
implements SPARQLTreeNode {
    private Set<String> rejectedBGPProjections;
    private Set<String> rejectedBGPLexVars;
    private String valuesTab;

    public SimpleSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2) {
        this(n, sQLGenContext, n2, null);
    }

    public SimpleSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2, String string) {
        super(n, sQLGenContext, n2);
        this.setSparqlText(string);
        this.rejectedBGPProjections = new HashSet<String>();
        this.rejectedBGPLexVars = new HashSet<String>();
        this.valuesTab = QueryUtils.getLocalValueDollarName(sQLGenContext.clnPfxForRdfObjName);
        if (sQLGenContext.localValues != null) {
            this.valuesTab = sQLGenContext.localValues;
        }
    }

    @Override
    public Set<String> getRequiredLexVars() {
        if (this.myRequiredLexVars == null) {
            this.myRequiredLexVars = new HashSet();
            if (this.myBGP != null) {
                this.myRequiredLexVars.addAll(this.myBGP.getRequiredLexVars());
            }
            for (int i = 0; i < this.getNumChildren(); ++i) {
                this.myRequiredLexVars.addAll(QueryUtils.getCommonVars(this.getChild(i).getRequiredLexVars(), this.getChild(i).getCumulativeVars()));
            }
            for (Object object : this.myFilters) {
                this.myRequiredLexVars.addAll(((Filter)object).getRequiredLexVars());
            }
            if (!this.ctx.disableVidLexOpt) {
                Object object;
                Set<String> set = this.getDefBoundVidVars();
                object = set.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    this.myRequiredLexVars.remove(string);
                }
            }
            this.myRequiredLexVars = Collections.unmodifiableSet(this.myRequiredLexVars);
        }
        return this.myRequiredLexVars;
    }

    @Override
    public void setProjections() throws RDFException {
        Set<String> set;
        int n;
        int n2 = this.getNumChildren();
        SPARQLTreeNode sPARQLTreeNode = null;
        HashSet<String> hashSet = new HashSet<String>(this.getProjectVars());
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String set22 : hashSet) {
            if (this.myBGP.getBGPVars().contains(set22) && !this.localBGPFilters.contains(set22)) {
                hashSet2.add(set22);
            }
            for (int i = 0; i < n2; ++i) {
                sPARQLTreeNode = this.getChild(i);
                if (!sPARQLTreeNode.getCumulativeVars().contains(set22) || sPARQLTreeNode.getPushCandidates().contains(set22)) continue;
                hashSet2.add(set22);
            }
        }
        hashSet.removeAll(hashSet2);
        HashSet hashSet3 = new HashSet();
        Object var6_7 = null;
        ArrayList arrayList = new ArrayList(n2 + 1);
        for (int i = 0; i < n2 + 1; ++i) {
            arrayList.add(new HashSet());
        }
        HashSet<String> hashSet4 = new HashSet<String>();
        hashSet4.addAll(this.getJoinVarsForFilters(this.localBGPFilters));
        hashSet4.addAll(this.myBGP.getBindVars());
        hashSet4.addAll(this.myBGP.getSPMAuxValueVars());
        Set<String> set2 = QueryUtils.getCommonVars(this.getProjectVars(), hashSet4);
        hashSet3.addAll(set2);
        ((Set)arrayList.get(0)).addAll(hashSet3);
        this.rejectedBGPProjections.addAll(this.myBGP.addProjectVars(set2));
        for (int i = 0; i < n2; ++i) {
            sPARQLTreeNode = this.getChild(i);
            n = sPARQLTreeNode.getType();
            set = QueryUtils.getCommonVars(QueryUtils.getCommonVars(this.getProjectVars(), sPARQLTreeNode.getPushCandidates()), sPARQLTreeNode.getCumulativeVars());
            if (n == 0) {
                Set<String> set3 = QueryUtils.getCommonVars(set, sPARQLTreeNode.getDefiniteBoundVars());
                hashSet3.addAll(set3);
                sPARQLTreeNode.addProjectVars(set3);
            }
            Set<String> set4 = QueryUtils.getCommonVars(set, hashSet);
            sPARQLTreeNode.addProjectVars(set4);
            Set<String> set5 = QueryUtils.getCommonVars(this.getJoinVarsForFilters(sPARQLTreeNode.getNonLocalFilters()), sPARQLTreeNode.getCumulativeVars());
            if (n == 0) {
                hashSet3.addAll(QueryUtils.getCommonVars(sPARQLTreeNode.getDefiniteBoundVars(), set5));
            }
            sPARQLTreeNode.addProjectVars(set5);
            ((Set)arrayList.get(i + 1)).addAll(hashSet3);
        }
        HashSet<String> hashSet5 = new HashSet<String>();
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            set = QueryUtils.getDistinctVars(this.getJoinVarsForFilters(sPARQLTreeNode.getNonLocalFilters()), sPARQLTreeNode.getCumulativeVars());
            set.removeAll((Collection)arrayList.get(n));
            set.removeAll(hashSet5);
            for (String string : set) {
                SPARQLTreeNode sPARQLTreeNode2;
                int n3;
                boolean bl = false;
                for (n3 = n - 1; n3 >= 0 && !bl; --n3) {
                    sPARQLTreeNode2 = this.getChild(n3);
                    if (sPARQLTreeNode2.getType() != 0 || !sPARQLTreeNode2.getDefiniteBoundVars().contains(string)) continue;
                    sPARQLTreeNode2.addProjectVar(string);
                    hashSet5.add(string);
                    bl = true;
                }
                if (!bl && this.myBGP.getBGPVars().contains(string)) {
                    n3 = this.myBGP.addProjectVar(string) ? 1 : 0;
                    if (n3 == 0) {
                        this.rejectedBGPProjections.add(string);
                    }
                    hashSet5.add(string);
                    bl = true;
                }
                if (bl) continue;
                for (n3 = n - 1; n3 >= 0; --n3) {
                    sPARQLTreeNode2 = this.getChild(n3);
                    if (!sPARQLTreeNode2.getCumulativeVars().contains(string)) continue;
                    sPARQLTreeNode2.addProjectVar(string);
                }
            }
        }
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            sPARQLTreeNode.setProjections();
        }
    }

    @Override
    public void setLexVars() throws RDFException {
        int n;
        this.rejectedBGPLexVars.addAll(this.myBGP.addLexVars(QueryUtils.getCommonVars(this.getRequiredLexVars(), this.getBGPVars())));
        SPARQLTreeNode sPARQLTreeNode = null;
        int n2 = this.getNumChildren();
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            sPARQLTreeNode.addLexVars(QueryUtils.getCommonVars(this.getRequiredLexVars(), sPARQLTreeNode.getCumulativeVars()));
        }
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            sPARQLTreeNode.setLexVars();
        }
    }

    @Override
    public String toSQL() throws RDFException {
        return this.toSQL(null, null, null, null, null, null);
    }

    public String toSQL(String string, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5) throws RDFException {
        Set<Integer> set6 = Collections.emptySet();
        List<Filter> list = Collections.emptyList();
        int n = -1;
        int n2 = 0;
        return this.toSQL(string, set6, list, n2, n, set, set2, set3, set4, set5);
    }

    public String toSQL(String string, Set<Integer> set, List<Filter> list, int n, int n2, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        HashSet<String> hashSet = null;
        HashSet<String> hashSet2 = null;
        HashSet<String> hashSet3 = null;
        HashSet<String> hashSet4 = null;
        HashSet<String> hashSet5 = null;
        HashSet<String> hashSet6 = null;
        HashSet<String> hashSet7 = null;
        Set<String> set7 = null;
        HashSet<Integer> hashSet8 = null;
        HashSet<Integer> hashSet9 = null;
        HashSet<String> hashSet10 = null;
        HashSet<String> hashSet11 = null;
        HashSet<String> hashSet12 = new HashSet<String>();
        int n3 = this.getNumChildren();
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (this.myBGP.refsNonExistingTerm() && string == null) {
            String string9 = this.buildAllNullSelect(this.getCumulativeAndPushedVars(), this.getProjectVars(), this.getAllLexVars());
            String string10 = "FROM " + QueryUtils.getLocalNamespaceDollarName(this.ctx.clnPfxForRdfObjName);
            String string11 = "WHERE 1=0";
            stringBuffer.append(string9).append("\n");
            stringBuffer.append(string10).append("\n");
            stringBuffer.append(string11);
        } else {
            HashSet<String> hashSet13;
            String[] stringArray;
            String[] stringArray2;
            Set<String> set8;
            boolean[] blArray;
            if (string != null) {
                bl2 = true;
                string2 = string;
                hashSet = new HashSet<String>(set2);
                hashSet3 = new HashSet<String>(set3);
                hashSet5 = new HashSet<String>(set4);
                hashSet7 = new HashSet<String>(set5);
                hashSet10 = new HashSet<String>(set6);
                hashSet8 = new HashSet<Integer>(set);
                string3 = "";
                hashSet2 = new HashSet();
                hashSet4 = new HashSet();
                hashSet6 = new HashSet<String>();
                set7 = new HashSet<String>();
                hashSet11 = new HashSet();
                blArray = new boolean[1];
                hashSet12 = new HashSet();
                hashSet9 = new HashSet<Integer>();
                hashSet9.add(this.getBGPId());
                try {
                    string3 = this.translateMyBGP(hashSet2, hashSet4, hashSet6, set7, hashSet11, blArray, hashSet12);
                }
                catch (SQLException sQLException) {
                    throw new RDFException(sQLException.getMessage(), sQLException);
                }
                bl = blArray[0];
                set8 = this.getJoinVarsForFilters(list);
                set8.addAll(QueryUtils.getCommonVars(this.getAllLexVars(), this.myBGP.getBGPVars()));
                set8.removeAll(QueryUtils.getDistinctVars(set8, this.getCumulativeVars()));
                set8.removeAll(hashSet6);
                if (set8.size() > 0) {
                    String[] stringArray3 = new String[]{""};
                    String[] stringArray4 = new String[]{""};
                    stringArray2 = new String[]{""};
                    stringArray = new String[]{""};
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashSet13 = new HashMap();
                    try {
                        this.buildFinalValueJoin(set8, set8, this.getDefiniteBoundVars(), this.getAllLexVars(), stringArray3, stringArray4, stringArray2, stringArray, hashMap);
                    }
                    catch (SQLException sQLException) {
                        throw new RDFException(sQLException.getMessage(), sQLException);
                    }
                    string3 = "SELECT R.*" + stringArray3[0] + "\nFROM (" + string3 + ") R" + stringArray4[0] + "\nWHERE (1=1)" + stringArray2[0];
                    hashSet6.addAll(set8);
                }
                string6 = this.getJoinHint("r1", "r2");
                try {
                    string5 = this.buildSelect(hashSet, hashSet2, hashSet5, hashSet6, hashSet7, set7, hashSet8, hashSet9, "r1", "r2", string6);
                }
                catch (SQLException sQLException) {
                    throw new RDFException(sQLException.getMessage(), sQLException);
                }
                string7 = this.buildFrom(string2, string3, this.getType());
                string8 = this.buildOn(hashSet, hashSet2, hashSet3, hashSet4, hashSet7, set7, hashSet10, hashSet11, list, bl, n, n2);
                string2 = string4 = string5 + "\n" + string7 + "\n" + string8;
                hashSet.addAll(hashSet2);
                hashSet10.addAll(hashSet11);
                hashSet5.addAll(hashSet6);
                hashSet7.addAll(set7);
                hashSet8.addAll(hashSet9);
                hashSet3.addAll(hashSet4);
                hashSet12.addAll(QueryUtils.getCommonVars(hashSet6, hashSet4));
            } else {
                string2 = "";
                hashSet = new HashSet();
                hashSet3 = new HashSet();
                hashSet5 = new HashSet();
                hashSet7 = new HashSet();
                hashSet8 = new HashSet<Integer>();
                hashSet8.add(this.getBGPId());
                hashSet10 = new HashSet();
                blArray = new boolean[1];
                hashSet12 = new HashSet();
                try {
                    string2 = this.translateMyBGP(hashSet, hashSet3, hashSet5, hashSet7, hashSet10, blArray, hashSet12);
                }
                catch (SQLException sQLException) {
                    throw new RDFException(sQLException.getMessage(), sQLException);
                }
                bl = blArray[0];
            }
            for (int i = n4; i < n3; ++i) {
                set8 = this.getChild(i);
                hashSet2 = set8.getCumulativeAndPushedVars();
                hashSet4 = set8.getDefiniteBoundAndPushedVars();
                hashSet11 = set8.getCumulativeVars();
                hashSet6 = new HashSet<String>(set8.getProjectVars());
                set7 = set8.getAllLexVars();
                hashSet9 = new HashSet();
                if (set8 instanceof SimpleSPARQLTreeNode) {
                    hashSet9.add(set8.getBGPId());
                }
                boolean bl3 = false;
                if (set8 instanceof ServiceSPARQLTreeNode && this.ctx.serviceJoinPushDown) {
                    string3 = ((ServiceSPARQLTreeNode)((Object)set8)).toSQL(hashSet, string2);
                } else if ((set8.getOverloadedServiceInfo() & 2) != 0) {
                    bl3 = (set8.getOverloadedServiceInfo() & 4) != 0;
                    try {
                        string3 = ((SimpleSPARQLTreeNode)((Object)set8)).getInnerSQL(hashSet, hashSet5, hashSet7, hashSet2, hashSet6, set7, string2, bl3);
                    }
                    catch (SQLException sQLException) {
                        throw new RDFException(sQLException.getMessage(), sQLException);
                    }
                    if (string3 == null) {
                        bl3 = false;
                        string3 = set8.toSQL();
                    }
                } else if (this.ctx.topDownOpt && this.isTdwnCompatible((SPARQLTreeNode)((Object)set8), (Set<String>)hashSet)) {
                    SimpleSPARQLTreeNode simpleSPARQLTreeNode = (SimpleSPARQLTreeNode)((Object)set8);
                    string3 = simpleSPARQLTreeNode.toSQL(string2, hashSet8, (List)this.childJoinFilters.get(i), this.getType(), this.getBGPId(), hashSet, hashSet3, hashSet5, hashSet7, hashSet10);
                    bl3 = true;
                } else {
                    string3 = set8.toSQL();
                }
                int n5 = set8.getType();
                if (n5 == 2) {
                    string6 = set8.getAntiJoinHint();
                    try {
                        string2 = this.wrapForMinus(hashSet, hashSet2, hashSet3, hashSet4, hashSet5, hashSet6, hashSet7, set7, hashSet8, string2, string3, "r1", "r2", string6);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        throw new RDFException(sQLException.getMessage(), sQLException);
                    }
                }
                if (!bl3) {
                    string6 = set8.getJoinHint("r1", "r2");
                    if (i == 0 && this.myBGP.getNumTriples() == 0) {
                        string6 = "";
                    }
                    bl = bl || set8.containsEmptyBGP();
                    try {
                        string5 = this.buildSelect(hashSet, hashSet2, hashSet5, hashSet6, hashSet7, set7, hashSet8, hashSet9, "r1", "r2", string6);
                    }
                    catch (SQLException sQLException) {
                        throw new RDFException(sQLException.getMessage(), sQLException);
                    }
                    string7 = this.buildFrom(string2, string3, set8.getType());
                    string8 = this.buildOn(hashSet, hashSet2, hashSet3, hashSet4, hashSet7, set7, hashSet10, hashSet11, (List)this.childJoinFilters.get(i), bl, n, -1);
                    string4 = string5 + "\n" + string7 + "\n" + string8;
                } else {
                    string4 = string3;
                }
                string2 = string4;
                hashSet.addAll(hashSet2);
                hashSet10.addAll(hashSet11);
                hashSet5.addAll(hashSet6);
                hashSet7.addAll(set7);
                hashSet8.addAll(hashSet9);
                if (set8.getType() != 0) continue;
                hashSet3.addAll(hashSet4);
                hashSet12.addAll(QueryUtils.getCommonVars(hashSet6, hashSet4));
            }
            Set<String> set9 = this.getJoinVarsForFilters(this.localNonBGPFilters);
            set9.removeAll(this.getBindVarsForFilters(this.localNonBGPFilters));
            set9.addAll(this.getProjectVars());
            set8 = new HashSet<String>(hashSet5);
            for (int i = 0; i < n3; ++i) {
                SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
                set8.removeAll(QueryUtils.getDistinctVars(sPARQLTreeNode.getCumulativeVars(), sPARQLTreeNode.getProjectVars()));
            }
            set8.removeAll(QueryUtils.getDistinctVars(this.myBGP.getBGPVars(), this.myBGP.getProjectVars()));
            hashSet12.addAll(set8);
            set9 = QueryUtils.getDistinctVars(set9, hashSet12);
            Set<String> set10 = QueryUtils.getDistinctVars(this.getProjectVars(), hashSet12);
            HashSet<String> hashSet14 = new HashSet<String>(this.getAllLexVars());
            stringArray2 = QueryUtils.getCommonVars(hashSet12, hashSet14);
            stringArray = new HashSet();
            stringArray.addAll(QueryUtils.getCommonVars(stringArray2, QueryUtils.getDistinctVars(this.myBGP.getProjectVars(), this.myBGP.getAllLexVars())));
            for (int i = 0; i < n3; ++i) {
                hashSet13 = this.getChild(i);
                stringArray.addAll(QueryUtils.getCommonVars((Set<String>)stringArray2, QueryUtils.getDistinctVars(hashSet13.getProjectVars(), hashSet13.getAllLexVars())));
            }
            if (this.localNonBGPFilters.isEmpty() && this.limit < 0 && !this.pushingMyBGP && set9.isEmpty() && stringArray.isEmpty()) {
                stringBuffer.append(string2);
            } else {
                String string12 = "";
                if (this.pushingMyBGP) {
                    try {
                        string12 = this.buildBGPWith();
                    }
                    catch (SQLException sQLException) {
                        throw new RDFException(sQLException.getMessage(), sQLException);
                    }
                }
                hashSet13 = hashSet14;
                HashSet<String> hashSet15 = hashSet12;
                if (bl2) {
                    hashSet13.addAll(hashSet7);
                    hashSet15.addAll(QueryUtils.getDistinctVars(hashSet5, set10));
                }
                String[] stringArray5 = new String[]{""};
                String[] stringArray6 = new String[]{""};
                String[] stringArray7 = new String[]{""};
                String[] stringArray8 = new String[]{""};
                HashMap<String, String> hashMap = new HashMap<String, String>();
                Set<String> set11 = set3;
                if (!bl2) {
                    set11 = this.getDefiniteBoundVars();
                }
                try {
                    this.buildFinalValueJoin(set9, set10, set11, hashSet14, stringArray5, stringArray6, stringArray7, stringArray8, hashMap);
                }
                catch (SQLException sQLException) {
                    throw new RDFException(sQLException.getMessage(), sQLException);
                }
                String string13 = "";
                try {
                    string13 = this.buildSelect(hashSet, new HashSet<String>(), hashSet15, new HashSet<String>(), hashSet13, new HashSet<String>(), hashSet8, new HashSet<Integer>(), (Set<String>)stringArray, "R", "", stringArray8[0]);
                }
                catch (SQLException sQLException) {
                    throw new RDFException(sQLException.getMessage(), sQLException);
                }
                String string14 = "FROM (" + string2 + ") " + "R";
                String string15 = "WHERE (1=1) ";
                string13 = string13 + stringArray5[0];
                string14 = string14 + stringArray6[0];
                string15 = string15 + stringArray7[0];
                for (ASTTripleAtom.BindVar bindVar : this.getBindVarObjsForFilters(this.localNonBGPFilters)) {
                    string14 = string14 + ", " + bindVar.getAlias() + " " + bindVar.getAlias();
                }
                stringBuffer.append(string12);
                stringBuffer.append(string13);
                stringBuffer.append("\n");
                stringBuffer.append(string14);
                stringBuffer.append("\n");
                stringBuffer.append(string15);
                stringBuffer.append(this.buildFinalWhere(hashMap, this.localNonBGPFilters, stringBuffer.toString(), this.getCumulativeAndPushedVars(), this.getProjectVars(), this.getAllLexVars(), this.getCumulativeVars()));
                if (this.limit >= 0) {
                    stringBuffer.append(" AND ROWNUM <= " + this.limit);
                }
            }
        }
        return stringBuffer.toString();
    }

    private boolean isTdwnCompatible(SPARQLTreeNode sPARQLTreeNode, Set<String> set) {
        boolean bl = true;
        if (!(sPARQLTreeNode instanceof SimpleSPARQLTreeNode)) {
            bl = false;
        } else if (sPARQLTreeNode.getType() != 0 && sPARQLTreeNode.getType() != 1) {
            bl = false;
        } else {
            int n;
            if (sPARQLTreeNode.hasExistsFilter()) {
                bl = false;
            }
            for (n = 0; n < sPARQLTreeNode.getNumChildren() && bl; ++n) {
                SPARQLTreeNode sPARQLTreeNode2 = sPARQLTreeNode.getChild(n);
                if (sPARQLTreeNode2.getType() != 2) continue;
                bl = false;
            }
            if (bl) {
                Set<String> set2 = sPARQLTreeNode.getBGPVars();
                for (int i = 0; i < sPARQLTreeNode.getNumChildren() && bl; ++i) {
                    SPARQLTreeNode sPARQLTreeNode3 = sPARQLTreeNode.getChild(i);
                    if (sPARQLTreeNode3.getType() != 1) continue;
                    HashSet<String> hashSet = new HashSet<String>(sPARQLTreeNode3.getCumulativeVars());
                    hashSet.removeAll(set2);
                    for (String string : hashSet) {
                        if (!set.contains(string)) continue;
                        bl = false;
                    }
                }
            }
            if (bl && sPARQLTreeNode.getType() == 1) {
                if (sPARQLTreeNode.hasChildVarFilter()) {
                    bl = false;
                }
                for (n = 0; n < sPARQLTreeNode.getNumChildren() && bl; ++n) {
                    SPARQLTreeNode sPARQLTreeNode4 = sPARQLTreeNode.getChild(n);
                    if (sPARQLTreeNode4 instanceof SimpleSPARQLTreeNode && sPARQLTreeNode4.getType() == 1) continue;
                    bl = false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private String getInnerSQL(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, String string, boolean bl) throws SQLException {
        void var23_36;
        CharSequence charSequence2;
        Set<String> set7;
        Set<String> set8;
        Set<String> set9;
        Set<String> set10 = QueryUtils.getCommonVars(set, set4);
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (set10.size() > 0) {
            stringBuffer.append("'");
            for (String string2 : set10) {
                QueryUtils.appendToList(stringBuffer, string2, " ", "'");
                if (set3.contains(string2)) {
                    QueryUtils.appendToList(stringBuffer, "1", " ", "'");
                    continue;
                }
                QueryUtils.appendToList(stringBuffer, "0", " ", "'");
            }
            stringBuffer.append("'");
            stringBuffer2.append("cursor(");
            if (bl) {
                stringBuffer2.append(string);
            } else {
                stringBuffer2.append(this.buildDistinct(set10, set3, string));
            }
        } else {
            return null;
        }
        stringBuffer2.append(")");
        StringBuffer stringBuffer3 = new StringBuffer("'");
        for (int i = 0; i < this.ctx.models.length; ++i) {
            QueryUtils.appendToList(stringBuffer3, this.ctx.models[i], " ", "'");
        }
        stringBuffer3.append("'");
        if (bl) {
            set9 = QueryUtils.getUnion(set, set4);
            set8 = QueryUtils.getUnion(set2, set5);
            set7 = QueryUtils.getUnion(set3, set6);
        } else {
            set9 = set4;
            set8 = set5;
            set7 = set6;
        }
        StringBuffer stringBuffer4 = new StringBuffer("'");
        for (String object32 : set9) {
            if (set7.contains(object32) || set8.contains(object32)) continue;
            QueryUtils.appendToList(stringBuffer4, object32, " ", "'");
        }
        stringBuffer4.append("'");
        StringBuffer stringBuffer5 = new StringBuffer("'");
        for (String string2 : set8) {
            if (set7.contains(string2)) continue;
            QueryUtils.appendToList(stringBuffer5, string2, " ", "'");
        }
        stringBuffer5.append("'");
        StringBuffer stringBuffer6 = new StringBuffer("'");
        for (CharSequence charSequence2 : set7) {
            if (!set8.contains(charSequence2)) continue;
            QueryUtils.appendToList(stringBuffer6, charSequence2, " ", "'");
        }
        stringBuffer6.append("'");
        StringBuffer stringBuffer7 = new StringBuffer("'INVALID'");
        charSequence2 = new StringBuffer("''' ").append("PLUS_RDFT=VC").append(" ").append(this.ctx.queryOptions).append(" '''");
        StringBuffer stringBuffer8 = new StringBuffer("'");
        for (String string3 : this.ctx.defaultGraphList) {
            QueryUtils.appendToList(stringBuffer8, string3, " ", "'");
        }
        stringBuffer8.append("'");
        StringBuffer stringBuffer9 = new StringBuffer("'");
        for (String string4 : this.ctx.namedGraphsList) {
            QueryUtils.appendToList(stringBuffer9, string4, " ", "'");
        }
        stringBuffer9.append("'");
        String string5 = "";
        if (this.ctx.topDownOpt) {
            void var23_34;
            if (set4.size() > 0) {
                String string6 = ", " + set4.iterator().next() + "$RDFVID";
            } else {
                String string7 = ", 1";
            }
            String string8 = (String)var23_34 + " AS BGP$" + this.getBGPId();
        }
        StringBuffer stringBuffer10 = new StringBuffer("").append("select SM.*" + (String)var23_36 + " from table(sem_match_nl(").append("\nstr_query=>").append(QueryUtils.enquoteLiteral(this.getSparqlText())).append(",\nstr_models=>").append(stringBuffer3).append(",\nstr_index_status=>").append(stringBuffer7).append(",\nstr_options=>").append((StringBuffer)charSequence2).append(",\nstr_graphs=>").append(stringBuffer8).append(",\nstr_named_graphs=>").append(stringBuffer9).append(",\nid_vars=>").append(stringBuffer4).append(",\nval_vars=>").append(stringBuffer5).append(",\nterm_vars=>").append(stringBuffer6).append(",\njoin_vars=>").append(stringBuffer).append(",\npushed_results=>").append(stringBuffer2).append(",\nnetwork_owner=>").append(QueryUtils.enquoteLiteral(this.ctx.clnNetworkOwner)).append(",\nnetwork_name=>").append(QueryUtils.enquoteLiteral(this.ctx.clnNetworkName)).append(")) SM");
        return stringBuffer10.toString();
    }

    private String buildDistinct(Set<String> set, Set<String> set2, String string) {
        String string2 = "$ISCLOB";
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("SELECT DISTINCT ");
        int n = 0;
        for (String string3 : set) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            if (!set2.contains(string3)) {
                stringBuffer.append(string3).append("$RDFVID");
            } else {
                stringBuffer.append(QueryUtils.shortenVNforTerm(string3 + "$RDFCLOB", string3 + "$RDFLANG", string3 + "$RDFLTYP", this.ctx)).append(" AS ").append(string3).append(string2).append(",").append(string3).append("$RDFTERM");
            }
            ++n;
        }
        stringBuffer.append(" FROM(").append(string).append(")");
        return stringBuffer.toString();
    }

    private String translateMyBGP(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, boolean[] blArray, Set<String> set6) throws RDFException, SQLException {
        String string = "";
        string = this.pushingMyBGP ? this.myBgpWithAlias : this.genBGPSubquery();
        set.addAll(this.myBGP.getBGPAndPushedVars());
        set2.addAll(this.myBGP.getDefiniteBoundAndPushedVars());
        set3.addAll(this.myBGP.getProjectVars());
        set3.addAll(this.rejectedBGPProjections);
        set3.addAll(this.rejectedBGPLexVars);
        set4.addAll(this.myBGP.getAllLexVars());
        set5.addAll(this.myBGP.getBGPVars());
        blArray[0] = this.myBGP.getNumTriples() == 0;
        set6.addAll(QueryUtils.getCommonVars(set3, set2));
        return string;
    }

    private Set<String> getDefBoundVidVars() {
        HashSet<String> hashSet = new HashSet<String>();
        Set<String> set = this.myBGP.getRequiredLexVars();
        for (String object : this.myBGP.getDefiniteBoundVars()) {
            if (set.contains(object)) continue;
            hashSet.add(object);
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            set = sPARQLTreeNode.getRequiredLexVars();
            if (sPARQLTreeNode.getType() != 0) continue;
            for (String string : sPARQLTreeNode.getDefiniteBoundVars()) {
                if (set.contains(string)) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private String genBGPSubquery() throws RDFException, SQLException {
        String string = this.myBGP.toSQL();
        if (!(this.rejectedBGPFilters.isEmpty() && this.rejectedBGPProjections.isEmpty() && this.rejectedBGPLexVars.isEmpty())) {
            Cloneable cloneable2;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(this.rejectedBGPProjections);
            for (Cloneable cloneable2 : this.rejectedBGPFilters) {
                hashSet.addAll(((Filter)cloneable2).getfJoinVars());
            }
            hashSet.addAll(this.rejectedBGPLexVars);
            hashSet.removeAll(this.myBGP.getProjectVars());
            Set<String> set = this.myBGP.getAllLexVars();
            cloneable2 = new HashSet<String>(this.rejectedBGPProjections);
            cloneable2.addAll(this.rejectedBGPLexVars);
            String[] stringArray = new String[]{""};
            String[] stringArray2 = new String[]{""};
            String[] stringArray3 = new String[]{""};
            String[] stringArray4 = new String[]{""};
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.buildFinalValueJoin(hashSet, (Set<String>)((Object)cloneable2), this.myBGP.getDefiniteBoundVars(), set, stringArray, stringArray2, stringArray3, stringArray4, hashMap);
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            hashSet2.add(this.getBGPId());
            Set<Integer> set2 = Collections.emptySet();
            String string2 = "";
            string2 = this.buildSelect(this.myBGP.getBGPAndPushedVars(), new HashSet<String>(), this.myBGP.getProjectVars(), new HashSet<String>(), set, new HashSet<String>(), hashSet2, set2, "R", "", stringArray4[0]);
            String string3 = "FROM (" + string + ") " + "R";
            String string4 = "WHERE (1=1) ";
            string2 = string2 + stringArray[0];
            string3 = string3 + stringArray2[0];
            string4 = string4 + stringArray3[0];
            string = string2 + "\n" + string3 + "\n" + string4;
            String string5 = this.buildFinalWhere(hashMap, this.rejectedBGPFilters, string, this.myBGP.getBGPAndPushedVars(), this.myBGP.getProjectVars(), this.myBGP.getAllLexVars(), this.myBGP.getBGPVars());
            string = string + string5;
        }
        return string;
    }

    private void buildFinalValueJoin(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, Map<String, String> map) throws SQLException {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        this.genOuterSelectComponents(set, set3, hashMap, stringArray2, stringArray3, map, this.getLobVars());
        StringBuffer stringBuffer = new StringBuffer("");
        for (Map.Entry entry : hashMap.entrySet()) {
            if (set2.contains(entry.getKey())) {
                stringBuffer.append(",\n");
                stringBuffer.append(this.buildNonVidSelect((String)entry.getKey(), (List)entry.getValue()));
            }
            if (!set4.contains(entry.getKey())) continue;
            stringBuffer.append(", ");
            stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, this.buildRDFTForVar("", (String)entry.getKey(), hashMap, false, true, false, true), (String)entry.getKey() + this.term_alias));
        }
        stringArray[0] = stringBuffer.toString();
        stringArray4[0] = this.myBGP.getValueJoinHint(map.values(), "R");
    }

    private String buildNonVidSelect(String string, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer("");
        String[] stringArray = new String[]{"", this.vid_alias, this.prefix_alias, this.suffix_alias, this.vtype_alias, this.longLit_alias, this.litType_alias, this.langType_alias};
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 1) continue;
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, list.get(i), string + stringArray[i]));
        }
        return stringBuffer.toString();
    }

    private String buildBGPWith() throws RDFException, SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("WITH " + this.myBgpWithAlias + " AS (\n");
        stringBuffer.append(this.genBGPSubquery());
        stringBuffer.append("\n)\n");
        return stringBuffer.toString();
    }

    private String buildFinalWhere(Map<String, String> map, List<Filter> list, String string, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        Map<String, String> map2 = this.buildFilterAliasMap(this.getCumulativeVars(), new HashSet<String>(), "R", "");
        map2.putAll(map);
        for (Filter filter : list) {
            filter.setCurrSQL(string, set, set2, set3, set4);
            QueryUtils.appendToList(stringBuffer, "(" + filter.toSQL(map2, this.ctx.funcTypeMap, this.ctx.funcHandMap) + ")", " AND\n", "dummy");
        }
        return stringBuffer.toString();
    }

    private Map<String, String> buildFilterAliasMap(Set<String> set, Set<String> set2, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object2 : set2) {
            hashMap.put(object2, string2 + "." + object2);
        }
        Set<String> set3 = QueryUtils.getDistinctVars(set, set2);
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            hashMap.put(string3, string + "." + string3);
        }
        return hashMap;
    }

    private String buildCoalesceForVar(String string, String string2, String string3, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        int n2 = 0;
        if (set.contains(string3)) {
            ++n2;
        }
        if (set2.contains(string3)) {
            n2 += 2;
        }
        int n3 = 0;
        if (set3.contains(string3)) {
            ++n3;
        }
        if (set4.contains(string3)) {
            n3 += 2;
        }
        n = n2 > 0 || n3 > 0 ? 8 : 1;
        boolean bl = (n2 & 1) == 1 || (n3 & 1) == 1;
        boolean bl2 = (n2 & 2) == 2 || (n3 & 2) == 2;
        for (int i = 0; i < n; ++i) {
            if (i == 0 || bl && bl2) {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, "COALESCE (" + string + "." + string3 + this.varProjColumns[i] + ", " + string2 + "." + string3 + this.varProjColumns[i] + ") ", string3 + this.varProjColumns[i]), ", ", "");
                continue;
            }
            if (bl) {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string + "." + string3 + this.varProjColumns[i], string3 + this.varProjColumns[i]), ", ", "");
                continue;
            }
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string2 + "." + string3 + this.varProjColumns[i], string3 + this.varProjColumns[i]), ", ", "");
        }
        if (n3 > 0) {
            if ((n3 & 3) > 2) {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, "COALESCE (" + string + "." + string3 + this.varProjColumns[8] + ", " + string2 + "." + string3 + this.varProjColumns[8] + ") ", string3 + this.varProjColumns[8]), ", ", "");
            } else if ((n3 & 1) > 0) {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string + "." + string3 + this.varProjColumns[8], string3 + this.varProjColumns[8]), ", ", "");
            } else {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string2 + "." + string3 + this.varProjColumns[8], string3 + this.varProjColumns[8]), ", ", "");
            }
        }
        return stringBuffer.toString();
    }

    private String buildSelect(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, String string, String string2, String string3) throws SQLException {
        Set<String> set7 = Collections.emptySet();
        Set<Integer> set8 = Collections.emptySet();
        return this.buildSelect(set, set2, set3, set4, set5, set6, set8, set8, set7, string, string2, string3);
    }

    private String buildSelect(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, Set<Integer> set7, Set<Integer> set8, String string, String string2, String string3) throws SQLException {
        Set<String> set9 = Collections.emptySet();
        return this.buildSelect(set, set2, set3, set4, set5, set6, set7, set8, set9, string, string2, string3);
    }

    private String buildSelect(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, Set<String> set7, String string, String string2, String string3) throws SQLException {
        Set<Integer> set8 = Collections.emptySet();
        return this.buildSelect(set, set2, set3, set4, set5, set6, set8, set8, set7, string, string2, string3);
    }

    private String buildSelect(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, Set<Integer> set7, Set<Integer> set8, Set<String> set9, String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set10 = QueryUtils.getDistinctVars(set, set2);
        Set<String> set11 = QueryUtils.getCommonVars(set, set2);
        Set<String> set12 = QueryUtils.getDistinctVars(set2, set);
        if (set10.size() == 0 && set11.size() == 0 && set12.size() > 0) {
            String string4 = string + ".*, ";
            if (!this.ctx.topDownOpt) {
                string4 = "";
            }
            QueryUtils.appendToList(stringBuffer, string4 + string2 + ".*", ",\n", "");
        } else {
            String string4;
            for (String object : set10) {
                string4 = this.buildSelectForVar(string, object, set3, set5, set9);
                QueryUtils.appendToList(stringBuffer, string4, ",\n", "");
            }
            for (String string5 : set11) {
                string4 = this.buildCoalesceForVar(string, string2, string5, set3, set4, set5, set6);
                QueryUtils.appendToList(stringBuffer, string4, ",\n", "");
            }
            for (String string6 : set12) {
                string4 = this.buildSelectForVar(string2, string6, set4, set6, set9);
                QueryUtils.appendToList(stringBuffer, string4, ",\n", "");
            }
            if (this.ctx.topDownOpt) {
                for (Integer n : set7) {
                    QueryUtils.appendToList(stringBuffer, "BGP$" + n, ",\n", "");
                }
                for (Integer n : set8) {
                    QueryUtils.appendToList(stringBuffer, "BGP$" + n, ",\n", "");
                }
            }
            if ((this.ctx.contextFlags & 3) > 0) {
                if (string2.equals("")) {
                    QueryUtils.appendToList(stringBuffer, " " + string + ".T0_CTXT2 as T0_CTXT2 ", ",\n ", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, " nvl(" + string + ".T0_CTXT2, " + string2 + ".T0_CTXT2) as T0_CTXT2 ", ",\n ", "");
                }
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("1\n");
        }
        return "SELECT " + string3 + " " + stringBuffer.toString();
    }

    private String buildAllNullSelect(Set<String> set, Set<String> set2, Set<String> set3) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (String string : set) {
            String string2 = this.buildAllNullSelectForVar(string, set2, set3);
            QueryUtils.appendToList(stringBuffer, string2, ",\n", "");
        }
        if ((this.ctx.contextFlags & 3) > 0) {
            QueryUtils.appendToList(stringBuffer, "NULL as T0_CTXT2 ", ",\n ", "");
        }
        if (this.ctx.topDownOpt) {
            QueryUtils.appendToList(stringBuffer, "NULL as BGP$" + this.getBGPId(), ",\n", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("1\n");
        }
        return "SELECT " + stringBuffer.toString();
    }

    private String buildAllNullSelectForVar(String string, Set<String> set, Set<String> set2) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        int n2 = 7;
        int n3 = 0;
        if (set.contains(string)) {
            n3 = 8;
            if (set2.contains(string)) {
                n3 = 9;
            }
        } else {
            n3 = 1;
        }
        for (int i = 0; i < n3; ++i) {
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.buildNullValueForVar(i, n, n2), string + this.varProjColumns[i]), ", ", "");
        }
        return stringBuffer.toString();
    }

    private String buildFrom(String string, String string2, int n) {
        String string3 = "INNER JOIN";
        if (n == 1) {
            string3 = "LEFT OUTER JOIN";
        }
        return "FROM (" + string + ") " + "r1" + "\n" + string3 + "\n(" + string2 + ") " + "r2";
    }

    /*
     * WARNING - void declaration
     */
    private String buildOn(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, Set<String> set7, Set<String> set8, List<Filter> list, boolean bl, int n, int n2) throws RDFException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set9 = QueryUtils.getCommonVars(set, set2);
        for (String object : set9) {
            void var17_18;
            String string2 = "";
            string = "r1." + object + this.vid_alias;
            String string3 = "r2." + object + this.vid_alias;
            String string4 = "0";
            if (set5.contains(object) && set6.contains(object)) {
                string = "r1." + object + this.term_alias;
                string3 = "r2." + object + this.term_alias;
                string4 = "'RDF$NULL'";
            } else if (set5.contains(object)) {
                string = this.buildRes2VidCall("r1." + object + this.term_alias, "r1." + object + this.litType_alias, "r1." + object + this.langType_alias, this.valuesTab);
            } else if (set6.contains(object)) {
                string3 = this.buildRes2VidCall("r2." + object + this.term_alias, "r2." + object + this.litType_alias, "r2." + object + this.langType_alias, this.valuesTab);
            }
            if (this.ctx.disableNullJoin) {
                String string5 = "(" + string + " = " + string3 + ")";
            } else if ((this.ctx.optJoinFlags & 1) > 0) {
                void var17_25;
                String string6 = "(" + string + " = " + string3;
                if (!set3.contains(object)) {
                    String string7 = string6 + " OR " + string + " IS NULL";
                }
                if (!set4.contains(object)) {
                    void var17_23;
                    String string8 = (String)var17_23 + " OR " + string3 + " IS NULL";
                }
                String string9 = (String)var17_25 + ")";
            } else {
                String string10 = string;
                if (!set3.contains(object)) {
                    string10 = "COALESCE(" + string10 + "," + string3 + "," + string4 + ")";
                }
                String string11 = string3;
                if (!set4.contains(object)) {
                    string11 = "COALESCE(" + string11 + "," + string + "," + string4 + ")";
                }
                String string12 = "(" + string10 + " = " + string11 + ")";
            }
            QueryUtils.appendToList(stringBuffer, (String)var17_18, " AND\n", "");
        }
        if (bl && (this.ctx.contextFlags & 3) > 0 || (this.ctx.contextFlags & 2) > 0) {
            QueryUtils.appendToList(stringBuffer, "(coalesce(r1.T0_CTXT2,r2.T0_CTXT2,'RDFCTX$NULLCTX') = coalesce(r2.T0_CTXT2,r1.T0_CTXT2,'RDFCTX$NULLCTX'))", " AND\n", "");
        } else if ((this.ctx.contextFlags & 1) > 0) {
            QueryUtils.appendToList(stringBuffer, "(r1.T0_CTXT2 = r2.T0_CTXT2)", " AND\n", "");
        }
        Map<String, String> map = this.buildFilterAliasMap(set7, set8, "r1", "r2");
        for (Filter filter : list) {
            string = "(" + filter.toSQL(map, this.ctx.funcTypeMap, this.ctx.funcHandMap) + ")";
            QueryUtils.appendToList(stringBuffer, string, " AND\n", "");
        }
        if (this.ctx.topDownOpt && n == 1 && n2 >= 0) {
            QueryUtils.appendToList(stringBuffer, "r1.BGP$" + n2 + " IS NOT NULL", " AND\n", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("(1=1)");
        }
        return "ON (" + stringBuffer.toString() + ")";
    }

    private String wrapForMinus(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, Set<String> set7, Set<String> set8, Set<Integer> set9, String string, String string2, String string3, String string4, String string5) throws RDFException, SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set10 = QueryUtils.getCommonVars(set, set2);
        if (set10.isEmpty()) {
            stringBuffer.append(string);
        } else {
            CharSequence charSequence;
            Set<String> set11 = Collections.emptySet();
            Set<Integer> set12 = Collections.emptySet();
            String string6 = "";
            string6 = this.buildSelect(set, set11, set5, set11, set7, set11, set9, set12, string3, "", "");
            String string7 = "FROM (" + string + ") " + string3;
            String[] stringArray = set10.toArray(new String[0]);
            String[] stringArray2 = new String[set10.size()];
            String[] stringArray3 = new String[set10.size()];
            String[] stringArray4 = new String[set10.size()];
            String[] stringArray5 = new String[set10.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                charSequence = stringArray[i];
                if (set7.contains(charSequence) && set8.contains(charSequence)) {
                    stringArray2[i] = string3 + "." + (String)charSequence + "$RDFTERM";
                    stringArray3[i] = "'0'";
                    stringArray4[i] = string4 + "." + (String)charSequence + "$RDFTERM";
                    stringArray5[i] = "'0'";
                    continue;
                }
                if (set7.contains(charSequence)) {
                    stringArray2[i] = QueryUtils.wrapSQLforNumeric(this.buildRes2VidCall(string3 + "." + (String)charSequence + "$RDFTERM", string3 + "." + (String)charSequence + "$RDFLTYP", string3 + "." + (String)charSequence + "$RDFLANG", this.valuesTab));
                    stringArray3[i] = "-1";
                    stringArray4[i] = string4 + "." + (String)charSequence + "$RDFVID";
                    stringArray5[i] = "-1";
                    continue;
                }
                if (set8.contains(charSequence)) {
                    stringArray2[i] = string3 + "." + (String)charSequence + "$RDFVID";
                    stringArray3[i] = "-1";
                    stringArray4[i] = QueryUtils.wrapSQLforNumeric(this.buildRes2VidCall(string4 + "." + (String)charSequence + "$RDFTERM", string4 + "." + (String)charSequence + "$RDFLTYP", string4 + "." + (String)charSequence + "$RDFLANG", this.valuesTab));
                    stringArray5[i] = "-1";
                    continue;
                }
                stringArray2[i] = string3 + "." + (String)charSequence + "$RDFVID";
                stringArray3[i] = "-1";
                stringArray4[i] = string4 + "." + (String)charSequence + "$RDFVID";
                stringArray5[i] = "-1";
            }
            String string8 = "NOT EXISTS";
            if (this.ctx.disableNotExists) {
                string8 = "NOT IN";
            }
            charSequence = new StringBuffer("");
            ((StringBuffer)charSequence).append("WHERE ((");
            ((StringBuffer)charSequence).append(QueryUtils.buildMaskedInListClause(stringArray, set3, set4, stringArray2, stringArray4, stringArray3, stringArray5, string2, string4, string8, "AND", false, string5, this.ctx));
            ((StringBuffer)charSequence).append(")");
            boolean bl = true;
            for (String string9 : set10) {
                if (!set3.contains(string9)) continue;
                bl = false;
                break;
            }
            if (bl) {
                StringBuffer stringBuffer2 = new StringBuffer("");
                if (stringArray2.length > 1) {
                    String string9;
                    string9 = "";
                    stringBuffer2.append("COALESCE(");
                    for (int i = 0; i < stringArray2.length; ++i) {
                        string9 = stringArray3[i].startsWith("'") ? stringArray2[i] : QueryUtils.buildSafeToChar(stringArray2[i]);
                        QueryUtils.appendToList(stringBuffer2, string9, ",", "COALESCE(");
                    }
                    stringBuffer2.append(")");
                } else {
                    stringBuffer2.append(stringArray2[0]);
                }
                ((StringBuffer)charSequence).append(" OR (" + stringBuffer2.toString() + " IS NULL)");
            }
            ((StringBuffer)charSequence).append(")");
            stringBuffer.append(string6).append("\n");
            stringBuffer.append(string7).append("\n");
            stringBuffer.append(((StringBuffer)charSequence).toString());
        }
        return stringBuffer.toString();
    }
}

