/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.PPAltNode;
import oracle.spatial.rdf.server.PPIRINode;
import oracle.spatial.rdf.server.PPModNode;
import oracle.spatial.rdf.server.PPNegatedNode;
import oracle.spatial.rdf.server.PPNode;
import oracle.spatial.rdf.server.PPSQLTransVisitor;
import oracle.spatial.rdf.server.PPSeqNode;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class SimplePPSQLTransVisitor
implements PPSQLTransVisitor {
    private ASTTripleAtom activeGraph = null;
    private SQLGenContext ctx;
    private Map<Hint.QueryOption, String> queryOptions;
    private String linkTab = "";
    private int ppMaxDepth = 10;
    private String joinType = null;
    private boolean disableSJ = false;
    private boolean disableSJdist = false;
    private boolean useRW = false;
    private String searchType = null;
    private boolean distinctRW = false;
    private int wCount = 0;
    private List<String> wList = null;
    private String linkObjCol = "CANON_END_NODE_ID";

    public SimplePPSQLTransVisitor(ASTTripleAtom aSTTripleAtom, SQLGenContext sQLGenContext, Map<Hint.QueryOption, String> map, String string) {
        this.activeGraph = aSTTripleAtom;
        this.ctx = sQLGenContext;
        this.queryOptions = map;
        this.linkTab = string;
        this.ppMaxDepth = QueryUtils.getMaxPPDepth(map);
        if (map.containsKey((Object)Hint.QueryOption.USE_PP_HASH)) {
            this.joinType = "USE_HASH";
        } else if (map.containsKey((Object)Hint.QueryOption.USE_PP_NL)) {
            this.joinType = "USE_NL";
        }
        if (map.containsKey((Object)Hint.QueryOption.DISABLE_PP_SJ)) {
            this.disableSJ = true;
        }
        if (map.containsKey((Object)Hint.QueryOption.DISABLE_PP_SJ_DIST)) {
            this.disableSJdist = true;
        }
        if (map.containsKey((Object)Hint.QueryOption.USE_PP_RW)) {
            this.useRW = true;
        }
        if (map.containsKey((Object)Hint.QueryOption.RW_PP_DISTINCT)) {
            this.distinctRW = true;
        }
        if (map.containsKey((Object)Hint.QueryOption.USE_PP_BFS)) {
            this.searchType = "BREADTH";
        } else if (map.containsKey((Object)Hint.QueryOption.USE_PP_DFS)) {
            this.searchType = "DEPTH";
        }
        this.wCount = 0;
        this.wList = new ArrayList<String>();
        if (sQLGenContext.useExactValue) {
            this.linkObjCol = "END_NODE_ID";
        }
    }

    @Override
    public String visit(PPModNode pPModNode, String[] stringArray) throws RDFException {
        if (pPModNode.getNumChildren() != 1) {
            throw new RDFException("Unexpected number of children under PPModNode");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        Object var4_4 = null;
        Object var5_5 = null;
        switch (pPModNode.getModifier()) {
            case 0: {
                stringBuffer.append(this.buildPPSelect("T0", "T0", pPModNode.getDirection(), true));
                stringBuffer.append("\n");
                stringBuffer.append("FROM (\n");
                stringBuffer.append(this.buildZeroLengthQuery(pPModNode));
                stringBuffer.append("\nUNION ALL\n");
                stringBuffer.append("(");
                stringBuffer.append(this.buildNHopQuery(pPModNode, stringArray[0], 0, 1, true));
                stringBuffer.append(")) T0");
                break;
            }
            case 1: {
                stringBuffer.append(this.buildPPSelect("T0", "T0", pPModNode.getDirection(), true));
                stringBuffer.append("\n");
                stringBuffer.append("FROM (\n");
                stringBuffer.append(this.buildZeroLengthQuery(pPModNode));
                stringBuffer.append("\nUNION ALL\n");
                stringBuffer.append("(SELECT START_NODE_ID, " + this.linkObjCol + ", " + "G_ID" + "\n");
                stringBuffer.append("FROM (");
                stringBuffer.append(this.buildBasicUnbound(pPModNode, stringArray[0], -1, -1));
                stringBuffer.append(")\n");
                stringBuffer.append(")) T0");
                break;
            }
            case 2: {
                stringBuffer.append(this.buildPPSelect("T0", "T0", pPModNode.getDirection(), true));
                stringBuffer.append("\n");
                stringBuffer.append("FROM (\n");
                stringBuffer.append(this.buildBasicUnbound(pPModNode, stringArray[0], -1, -1));
                stringBuffer.append(") T0");
                break;
            }
            case 3: {
                int n = pPModNode.getMaxOcc();
                int n2 = pPModNode.getMinOcc();
                if (pPModNode.isExactRange() || n == n2) {
                    stringBuffer.append(this.buildPPSelect("T0", "T0", 0, true));
                    stringBuffer.append("\n");
                    stringBuffer.append("FROM (\n");
                    stringBuffer.append(this.buildNHopQuery(pPModNode, stringArray[0], pPModNode.getDirection(), n2, true));
                    stringBuffer.append(") T0");
                    break;
                }
                stringBuffer.append(this.buildPPSelect("T0", "T0", pPModNode.getDirection(), true));
                stringBuffer.append("\n");
                stringBuffer.append("FROM (\n");
                if (n2 <= 0) {
                    stringBuffer.append(this.buildZeroLengthQuery(pPModNode));
                    if (n != 0) {
                        stringBuffer.append("\nUNION ALL\n");
                    }
                }
                if (n != 0) {
                    stringBuffer.append("(SELECT START_NODE_ID, " + this.linkObjCol + ", " + "G_ID" + "\n");
                    stringBuffer.append("FROM (");
                    stringBuffer.append(this.buildBasicUnbound(pPModNode, stringArray[0], n2, n));
                    stringBuffer.append(")\n");
                    stringBuffer.append(")");
                }
                stringBuffer.append(") T0");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String visit(PPSeqNode pPSeqNode, String[] stringArray) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "T0";
        String string2 = "T" + (pPSeqNode.getNumChildren() - 1);
        stringBuffer.append(this.buildPPSelect(string, string2, pPSeqNode.getDirection(), false, pPSeqNode.getNumChildren()));
        stringBuffer.append("\n");
        stringBuffer.append(this.buildPPFrom(stringArray));
        stringBuffer.append("\n");
        StringBuffer stringBuffer2 = new StringBuffer("WHERE ");
        this.appendPathJoin(stringBuffer2, pPSeqNode.getNumChildren());
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    @Override
    public String visit(PPAltNode pPAltNode, String[] stringArray) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.buildPPSelect("T0", "T0", pPAltNode.getDirection()));
        stringBuffer.append("\n");
        StringBuffer stringBuffer2 = new StringBuffer("FROM (");
        for (int i = 0; i < pPAltNode.getNumChildren(); ++i) {
            QueryUtils.appendToList(stringBuffer2, "(SELECT START_NODE_ID, " + this.linkObjCol + ", " + "G_ID" + "\nFROM (" + stringArray[i] + "))", "\nUNION ALL\n", "FROM (");
        }
        stringBuffer2.append(") T0\n");
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    @Override
    public String visit(PPNegatedNode pPNegatedNode, String[] stringArray) throws RDFException {
        ArrayList<PPIRINode> arrayList = new ArrayList<PPIRINode>();
        ArrayList<PPIRINode> arrayList2 = new ArrayList<PPIRINode>();
        for (int i = 0; i < pPNegatedNode.getNumChildren(); ++i) {
            PPIRINode pPIRINode = (PPIRINode)pPNegatedNode.getChild(i);
            if (pPIRINode.getDirection() == 0) {
                arrayList.add(pPIRINode);
                continue;
            }
            arrayList2.add(pPIRINode);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        if (arrayList.size() > 0) {
            stringBuffer.append(this.buildBasicIRIQuery(arrayList, 0, false));
            this.appendStartEndConstraint(stringBuffer, "T0", pPNegatedNode);
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (arrayList2.size() > 0) {
            stringBuffer2.append(this.buildBasicIRIQuery(arrayList2, 1, false));
            this.appendStartEndConstraint(stringBuffer2, "T0", pPNegatedNode);
            ++n;
        }
        StringBuffer stringBuffer3 = new StringBuffer("");
        stringBuffer3.append(this.buildPPSelect("T0", "T0", pPNegatedNode.getDirection()));
        stringBuffer3.append("\n");
        stringBuffer3.append("FROM (\n");
        if (stringBuffer.length() > 0) {
            stringBuffer3.append("(").append(stringBuffer).append(")");
        }
        if (n > 1) {
            stringBuffer3.append("\nUNION ALL\n");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer3.append("(").append(stringBuffer2).append(")");
        }
        stringBuffer3.append(") T0");
        return stringBuffer3.toString();
    }

    @Override
    public String visit(PPIRINode pPIRINode, String[] stringArray) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        ArrayList<PPIRINode> arrayList = new ArrayList<PPIRINode>(1);
        arrayList.add(pPIRINode);
        stringBuffer.append(this.buildBasicIRIQuery(arrayList, pPIRINode.getDirection(), true));
        this.appendStartEndConstraint(stringBuffer, "T0", pPIRINode);
        return stringBuffer.toString();
    }

    @Override
    public String getWITHClauses() throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.wList.size() > 0) {
            stringBuffer.append("WITH\n");
            for (String string : this.wList) {
                QueryUtils.appendToList(stringBuffer, string, ",\n", "WITH\n");
            }
        }
        return stringBuffer.toString();
    }

    private boolean isGraphQuery() {
        return this.activeGraph != null;
    }

    private String buildPPSelect(String string, String string2, int n) throws RDFException {
        return this.buildPPSelect(string, string2, n, false);
    }

    private String buildPPSelect(String string, String string2, int n, boolean bl) throws RDFException {
        return this.buildPPSelect(string, string2, n, bl, 0);
    }

    private String buildPPSelect(String string, String string2, int n, boolean bl, int n2) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (n2 > 1 && this.joinType != null) {
            stringBuffer2.append("/*+ " + this.joinType + "(");
            for (int i = 0; i < n2; ++i) {
                stringBuffer2.append(" T" + i);
            }
            stringBuffer2.append(") */ ");
        }
        stringBuffer.append(stringBuffer2.toString());
        if (bl && !this.ctx.allowPPDup) {
            stringBuffer.append("DISTINCT ");
        }
        switch (n) {
            case 0: {
                stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, string + "." + "START_NODE_ID", "START_NODE_ID"));
                stringBuffer.append(",\n");
                stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, string2 + "." + this.linkObjCol, this.linkObjCol));
                break;
            }
            case 1: {
                stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, string2 + "." + this.linkObjCol, "START_NODE_ID"));
                stringBuffer.append(",\n");
                stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, string + "." + "START_NODE_ID", this.linkObjCol));
                break;
            }
            default: {
                throw new RDFException("Unexpected property path direction");
            }
        }
        stringBuffer.append(",\n");
        stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, string + "." + "G_ID", "G_ID"));
        return stringBuffer.toString();
    }

    private String buildPPFrom(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("FROM ");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl) {
                stringBuffer.append(", ");
            }
            bl = true;
            stringBuffer.append("(").append(stringArray[i]).append(") T").append(i);
        }
        return stringBuffer.toString();
    }

    private void appendPathJoin(StringBuffer stringBuffer, int n) {
        for (int i = 1; i < n; ++i) {
            QueryUtils.appendToList(stringBuffer, "T" + (i - 1) + "." + this.linkObjCol + "=T" + i + "." + "START_NODE_ID", " AND ", "WHERE ");
            if (this.activeGraph == null) continue;
            QueryUtils.appendToList(stringBuffer, "T" + (i - 1) + "." + "G_ID" + "=T" + i + "." + "G_ID", " AND ", "WHERE ");
        }
    }

    private String buildBasicIRIQuery(List<PPIRINode> list, int n, boolean bl) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.buildPPSelect("T0", "T0", n));
        stringBuffer.append("\n");
        stringBuffer.append(this.buildPPFrom(new String[]{this.linkTab}));
        stringBuffer.append("\n");
        StringBuffer stringBuffer2 = new StringBuffer("WHERE ");
        if (list.size() == 1) {
            PPIRINode pPIRINode = list.get(0);
            this.applyIDConstraint(stringBuffer2, "T0", "P_VALUE_ID", bl, Collections.singleton(pPIRINode.getPredAtom()));
        } else {
            String string = this.buildVIDinList(list);
            stringBuffer2.append("T0.P_VALUE_ID");
            if (bl) {
                stringBuffer2.append(" IN ");
            } else {
                stringBuffer2.append(" NOT IN ");
            }
            stringBuffer2.append(string);
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    private void appendStartEndConstraint(StringBuffer stringBuffer, String string, PPNode pPNode) throws RDFException {
        String string2 = "";
        if (pPNode.hasConstrainedStart()) {
            string2 = pPNode.getDirection() == 0 ? "START_NODE_ID" : this.linkObjCol;
            this.applyIDConstraint(stringBuffer, string, string2, true, pPNode.getStartNodes());
        }
        if (pPNode.hasConstrainedEnd()) {
            string2 = pPNode.getDirection() == 0 ? this.linkObjCol : "START_NODE_ID";
            this.applyIDConstraint(stringBuffer, string, string2, true, pPNode.getEndNodes());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyIDConstraint(StringBuffer stringBuffer, String string, String string2, boolean bl, Set<ASTTripleAtom> set) throws RDFException {
        if (set.size() == 1) {
            ASTTripleAtom aSTTripleAtom = set.iterator().next();
            if (aSTTripleAtom.type == 7) {
                throw new RDFException("SYS_CONTEXT functions not allowed within property path expressions");
            }
            TriplesBlock.Element element = TriplesBlock.getElementForNode(aSTTripleAtom, this.ctx);
            Long l = element.getCanonicalID();
            String string3 = "=";
            if (!bl) {
                string3 = "<>";
            }
            if (l != null) {
                QueryUtils.appendToList(stringBuffer, string + "." + string2 + string3 + l.toString(), " AND ", "WHERE ");
            } else if (!element.exists()) {
                QueryUtils.appendToList(stringBuffer, "(1" + string3 + "0)", " AND ", "WHERE ");
            }
        } else {
            HashSet<Long> hashSet = new HashSet<Long>();
            for (ASTTripleAtom object : set) {
                if (object.type == 7) {
                    throw new RDFException("SYS_CONTEXT functions not allowed within property path expressions");
                }
                TriplesBlock.Element element = TriplesBlock.getElementForNode(object, this.ctx);
                Long l = element.getCanonicalID();
                if (l == null) continue;
                hashSet.add(l);
            }
            if (hashSet.size() == set.size()) {
                void var8_14;
                String string4 = this.buildIDInList(hashSet);
                String string5 = " IN ";
                if (!bl) {
                    String string6 = " NOT IN ";
                }
                QueryUtils.appendToList(stringBuffer, string + "." + string2 + (String)var8_14 + (String)string4, " AND ", "WHERE ");
            }
        }
    }

    private String buildVIDinList(List<PPIRINode> list) throws RDFException {
        ASTTripleAtom aSTTripleAtom = null;
        TriplesBlock.Element element = null;
        Long l = null;
        StringBuffer stringBuffer = new StringBuffer("(");
        for (PPIRINode pPIRINode : list) {
            aSTTripleAtom = pPIRINode.getPredAtom();
            if (aSTTripleAtom.type == 7) {
                throw new RDFException("SYS_CONTEXT functions not allowed within property path expressions");
            }
            element = TriplesBlock.getElementForNode(aSTTripleAtom, this.ctx);
            l = element.getCanonicalID() != null ? element.getCanonicalID() : new Long(0L);
            QueryUtils.appendToList(stringBuffer, l.toString(), ", ", "(");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String buildNHopQuery(PPNode pPNode, String string, int n, int n2, boolean bl) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        if (n2 == 0) {
            stringBuffer.append(this.buildZeroLengthQuery(pPNode));
        } else {
            stringBuffer.append(this.buildPPSelect("T0", "T" + (n2 - 1), n, false, n2));
            stringBuffer.append("\n");
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = string;
            }
            stringBuffer.append(this.buildPPFrom(stringArray));
            StringBuffer stringBuffer2 = new StringBuffer("WHERE ");
            if (n2 > 1) {
                this.appendPathJoin(stringBuffer2, n2);
            }
            String string2 = "";
            String string3 = "";
            if (bl && pPNode.hasConstrainedStart()) {
                string2 = "START_NODE_ID";
                string3 = "T0";
                if (pPNode.getDirection() == 1) {
                    string2 = this.linkObjCol;
                    string3 = "T" + (n2 - 1);
                }
                this.applyIDConstraint(stringBuffer2, string3, string2, true, pPNode.getStartNodes());
            }
            if (bl && pPNode.hasConstrainedEnd()) {
                string2 = this.linkObjCol;
                string3 = "T" + (n2 - 1);
                if (pPNode.getDirection() == 1) {
                    string2 = "START_NODE_ID";
                    string3 = "T0";
                }
                this.applyIDConstraint(stringBuffer2, string3, string2, true, pPNode.getEndNodes());
            }
            if (stringBuffer2.length() > 6) {
                stringBuffer.append("\n");
                stringBuffer.append(stringBuffer2);
            }
        }
        return stringBuffer.toString();
    }

    private String buildZeroLengthQuery(PPNode pPNode) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        Set<Long> set = this.getStartNodeIDs(pPNode);
        Set<Long> set2 = this.getEndNodeIDs(pPNode);
        if (this.activeGraph == null) {
            if (set != null && set2 != null) {
                String string = this.buildIDInList(set2);
                int n = 0;
                for (Long l : set) {
                    if (n > 0) {
                        stringBuffer.append("\nUNION ALL\n");
                    }
                    this.addZeroLengthSubQuery(stringBuffer, l, string);
                    ++n;
                }
            } else if (set != null) {
                int n = 0;
                for (Long l : set) {
                    if (n > 0) {
                        stringBuffer.append("\nUNION ALL\n");
                    }
                    this.addZeroLengthSubQuery(stringBuffer, l, null);
                    ++n;
                }
            } else if (set2 != null) {
                int n = 0;
                for (Long l : set2) {
                    if (n > 0) {
                        stringBuffer.append("\nUNION ALL\n");
                    }
                    this.addZeroLengthSubQuery(stringBuffer, l, null);
                    ++n;
                }
            } else {
                stringBuffer.append("(SELECT VID AS START_NODE_ID, VID AS " + this.linkObjCol + ", NULL AS " + "G_ID" + "\nFROM (SELECT VID\nFROM ((SELECT " + "START_NODE_ID" + " AS VID FROM (" + this.linkTab + ")) UNION ALL (SELECT " + this.linkObjCol + " AS VID FROM (" + this.linkTab + ")))))");
            }
        } else {
            String string;
            String string2 = "";
            if (this.activeGraph.type == 1) {
                string = this.ctx.URImap.get(this.activeGraph.name);
                string2 = " AND G_ID=" + string;
            }
            if (set != null || set2 != null) {
                if (set != null && set2 != null) {
                    string = this.buildIDInList(set2);
                    int n = 0;
                    for (Long l : set) {
                        if (n > 0) {
                            stringBuffer.append("\nUNION ALL\n");
                        }
                        this.addZeroLengthSubQueryForNG(stringBuffer, l, string);
                        ++n;
                    }
                } else if (set != null) {
                    int n = 0;
                    for (Long l : set) {
                        if (n > 0) {
                            stringBuffer.append("\nUNION ALL\n");
                        }
                        this.addZeroLengthSubQueryForNG(stringBuffer, l, null);
                        ++n;
                    }
                } else if (set2 != null) {
                    int n = 0;
                    for (Long l : set2) {
                        if (n > 0) {
                            stringBuffer.append("\nUNION ALL\n");
                        }
                        this.addZeroLengthSubQueryForNG(stringBuffer, l, null);
                        ++n;
                    }
                }
                stringBuffer.insert(0, "(SELECT " + QueryUtils.buildAliasExpr(this.ctx, "T0.START_NODE_ID", "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, "T0." + this.linkObjCol, this.linkObjCol) + ", " + QueryUtils.buildAliasExpr(this.ctx, "G.G_ID", "G_ID") + "\nFROM (");
                stringBuffer.append(") T0,\n");
                stringBuffer.append(this.linkTab).append(" G\n");
                stringBuffer.append("WHERE (G.START_NODE_ID = T0.START_NODE_ID OR G." + this.linkObjCol + " = T0." + "START_NODE_ID" + ")" + string2 + ")");
            } else {
                stringBuffer.append("(SELECT VID AS START_NODE_ID, VID AS " + this.linkObjCol + ", " + QueryUtils.buildAliasExpr(this.ctx, "G_ID", "G_ID") + "\nFROM (SELECT VID, " + "G_ID" + "\nFROM ((SELECT " + "START_NODE_ID" + " AS VID, " + QueryUtils.buildAliasExpr(this.ctx, "G_ID", "G_ID") + " FROM (" + this.linkTab + ") WHERE 1=1" + string2 + ") UNION ALL (SELECT " + this.linkObjCol + " AS VID , " + QueryUtils.buildAliasExpr(this.ctx, "G_ID", "G_ID") + " FROM (" + this.linkTab + ") WHERE 1=1" + string2 + ") )))");
            }
        }
        return stringBuffer.toString();
    }

    private void addZeroLengthSubQuery(StringBuffer stringBuffer, Long l, String string) {
        stringBuffer.append("(SELECT " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), this.linkObjCol) + ", NULL AS " + "G_ID" + "\nFROM sys.dual");
        if (string != null && string.length() > 0) {
            stringBuffer.append("\nWHERE " + l.toString() + " IN " + string);
        }
        if (this.ctx.strictPPNodeSet) {
            String string2 = "\nWHERE\n";
            if (string != null && string.length() > 0) {
                string2 = "\nAND\n";
            }
            stringBuffer.append(string2);
            stringBuffer.append("((").append("EXISTS (SELECT ").append("START_NODE_ID").append(" FROM ").append(this.linkTab).append(" WHERE ").append("START_NODE_ID").append("=").append(l.toString()).append(")) OR\n(EXISTS (SELECT ").append(this.linkObjCol).append(" FROM ").append(this.linkTab).append(" WHERE ").append(this.linkObjCol).append("=").append(l.toString()).append(")))");
        }
        stringBuffer.append(")");
    }

    private void addZeroLengthSubQueryForNG(StringBuffer stringBuffer, Long l, String string) {
        stringBuffer.append("(SELECT " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), "START_NODE_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, l.toString(), this.linkObjCol) + "\nFROM sys.dual\n");
        if (string != null && string.length() > 0) {
            stringBuffer.append("WHERE " + l.toString() + " IN " + string);
        }
        stringBuffer.append(")");
    }

    private String buildIDInList(Set<Long> set) {
        StringBuffer stringBuffer = new StringBuffer("(");
        boolean bl = false;
        for (Long l : set) {
            if (bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append(l.toString());
            bl = true;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private Set<Long> getStartNodeIDs(PPNode pPNode) {
        Set<Long> set = null;
        if (pPNode.hasConstrainedStart()) {
            Set<ASTTripleAtom> set2 = pPNode.getStartNodes();
            set = this.getIDsForNodeSet(set2);
        }
        return set;
    }

    private Set<Long> getEndNodeIDs(PPNode pPNode) {
        Set<Long> set = null;
        if (pPNode.hasConstrainedEnd()) {
            Set<ASTTripleAtom> set2 = pPNode.getEndNodes();
            set = this.getIDsForNodeSet(set2);
        }
        return set;
    }

    private Set<Long> getIDsForNodeSet(Set<ASTTripleAtom> set) {
        HashSet<Long> hashSet = null;
        TriplesBlock.Element element = null;
        for (ASTTripleAtom aSTTripleAtom : set) {
            element = TriplesBlock.getElementForNode(aSTTripleAtom, this.ctx);
            Long l = element.getCanonicalID();
            if (l != null) {
                if (hashSet == null) {
                    hashSet = new HashSet<Long>();
                }
                hashSet.add(l);
                continue;
            }
            return null;
        }
        return hashSet;
    }

    private String buildBasicUnbound(PPModNode pPModNode, String string, int n, int n2) {
        String string2 = "";
        boolean bl = !this.ctx.disableSPPOpt && this.isSchemaPropertyPath(pPModNode) && n2 < 0 && n < 0;
        int n3 = n2 > 0 ? n2 : this.ppMaxDepth;
        Set<Long> set = null;
        Set<Long> set2 = null;
        if (pPModNode.getDirection() == 0) {
            set = this.getStartNodeIDs(pPModNode);
            set2 = this.getEndNodeIDs(pPModNode);
        } else {
            set = this.getEndNodeIDs(pPModNode);
            set2 = this.getStartNodeIDs(pPModNode);
        }
        if (!this.disableSJ && n3 > 0 && !bl) {
            string2 = this.buildPlainJoinUnbound(pPModNode, string, set, set2, n, n3);
        } else {
            String string3 = ", G_ID";
            if (this.activeGraph == null) {
                string3 = ", NULL AS G_ID";
            }
            StringBuffer stringBuffer = new StringBuffer("");
            if (!this.useRW) {
                stringBuffer.append(this.buildConnectBy(pPModNode, string, string3, set, set2, bl, n, n3));
            } else {
                stringBuffer.append(this.buildRecursiveWith(pPModNode, string, string3, set, set2, bl, n, n3));
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private StringBuffer buildConnectBy(PPModNode pPModNode, String string, String string2, Set<Long> set, Set<Long> set2, boolean bl, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("");
        PPEvalInfo pPEvalInfo = this.getPPEvalInfo(set, set2);
        String string3 = pPEvalInfo.startCol;
        String string4 = pPEvalInfo.endCol;
        Set<Long> set3 = pPEvalInfo.optStartIDs;
        if (n >= 0) {
            stringBuffer.append("SELECT * FROM (\n");
        }
        stringBuffer.append("SELECT " + QueryUtils.buildAliasExpr(this.ctx, "CONNECT_BY_ROOT T0." + string3, string3) + ", " + QueryUtils.buildAliasExpr(this.ctx, "T0." + string4, string4) + ", " + QueryUtils.buildAliasExpr(this.ctx, "T0.G_ID", "G_ID") + ", " + QueryUtils.buildAliasExpr(this.ctx, "LEVEL", "LVL") + "\n");
        stringBuffer.append("FROM (SELECT " + string3 + ", " + string4 + string2 + "\n");
        stringBuffer.append("FROM (" + string + ")\n) T0\n");
        if (set3 != null) {
            if (set3.size() == 1) {
                stringBuffer.append("START WITH (" + string3 + "=" + set3.iterator().next().toString() + ")\n");
            } else {
                String string5 = this.buildIDInList(set3);
                stringBuffer.append("START WITH (" + string3 + " IN " + string5 + ")\n");
            }
        }
        stringBuffer.append("CONNECT BY NOCYCLE PRIOR " + string4 + "=" + string3);
        if (this.activeGraph != null) {
            stringBuffer.append(" AND PRIOR G_ID=G_ID");
        }
        if (n2 > 0 && !bl) {
            stringBuffer.append(" AND LEVEL <= " + n2);
        }
        if (n >= 0) {
            stringBuffer.append("\n) WHERE LVL >= " + n);
        }
        return stringBuffer;
    }

    private StringBuffer buildRecursiveWith(PPModNode pPModNode, String string, String string2, Set<Long> set, Set<Long> set2, boolean bl, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("");
        PPEvalInfo pPEvalInfo = this.getPPEvalInfo(set, set2);
        String string3 = pPEvalInfo.startCol;
        String string4 = pPEvalInfo.endCol;
        Set<Long> set3 = pPEvalInfo.optStartIDs;
        String string5 = "R.G_ID";
        String string6 = "";
        if (this.activeGraph == null) {
            string5 = "NULL AS G_ID";
        } else {
            string6 = "\nAND RW.G_ID =  R.G_ID";
        }
        stringBuffer.append("WITH RW (ROOT_ID, ").append(string4).append(", ").append("G_ID");
        if (!(n2 <= 0 && n < 0 || bl)) {
            stringBuffer.append(", LVL");
        }
        stringBuffer.append(") AS\n");
        stringBuffer.append("(SELECT ROOT_ID, ").append(string4).append(string2);
        if (!(n2 <= 0 && n < 0 || bl)) {
            stringBuffer.append(", LVL ");
        }
        stringBuffer.append(" FROM\n");
        stringBuffer.append("(SELECT ").append(string3).append(" ROOT_ID, ").append(string4).append(", ").append("G_ID");
        if (!(n2 <= 0 && n < 0 || bl)) {
            stringBuffer.append(", 1 LVL");
        }
        stringBuffer.append("\nFROM(").append(string).append(")\n");
        if (set3 != null) {
            if (set3.size() == 1) {
                stringBuffer.append("WHERE ").append(string3).append("=").append(set3.iterator().next().toString());
            } else {
                String string7 = this.buildIDInList(set3);
                stringBuffer.append("WHERE ").append(string3).append(" IN ").append(string7);
            }
        }
        stringBuffer.append(")\n");
        stringBuffer.append("UNION ALL\n");
        stringBuffer.append("SELECT ");
        if (this.distinctRW) {
            stringBuffer.append("DISTINCT ");
        }
        stringBuffer.append("RW.ROOT_ID, ").append("R.").append(string4).append(", ").append(string5);
        if (!(n2 <= 0 && n < 0 || bl)) {
            stringBuffer.append(", RW.LVL+1");
        }
        stringBuffer.append("\n");
        stringBuffer.append("FROM (").append(string).append(") R, RW\n");
        stringBuffer.append("WHERE RW.").append(string4).append(" = R.").append(string3);
        stringBuffer.append(string6);
        if (n2 > 0 && !bl) {
            stringBuffer.append(" AND RW.LVL <= ").append(n2);
        }
        stringBuffer.append(")\n");
        if (this.searchType != null) {
            stringBuffer.append("SEARCH ").append(this.searchType).append(" FIRST BY ").append(string4).append(" SET SEM$ROWNUM\n");
        }
        stringBuffer.append("CYCLE ").append(string4).append(" set y_cycle to 1 default 0\n");
        stringBuffer.append("SELECT ROOT_ID ").append(string3).append(", ").append(string4).append(", ").append("G_ID").append(" FROM RW\n");
        if (n2 > 0 && n >= 0 && !bl) {
            stringBuffer.append(" WHERE LVL <= ").append(n2).append(" AND LVL >= ").append(n);
        } else if (n >= 0 && !bl) {
            stringBuffer.append(" WHERE LVL >= ").append(n);
        } else if (n2 > 0 && !bl) {
            stringBuffer.append(" WHERE LVL <= ").append(n2);
        }
        return stringBuffer;
    }

    private boolean isSchemaPropertyPath(PPModNode pPModNode) {
        boolean bl = false;
        if (pPModNode.getNumChildren() == 1 && pPModNode.getChild(0) instanceof PPIRINode) {
            ASTTripleAtom aSTTripleAtom = ((PPIRINode)pPModNode.getChild(0)).getPredAtom();
            if (QueryUtils.isSchemaProperty(aSTTripleAtom.name)) {
                bl = true;
            }
        }
        return bl;
    }

    private String buildPlainJoinUnbound(PPModNode pPModNode, String string, Set<Long> set, Set<Long> set2, int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "";
        if (this.joinType != null) {
            string2 = "/*+ " + this.joinType + "(T0 T1) */ ";
        }
        String string3 = "";
        if (!this.disableSJdist) {
            string3 = "DISTINCT ";
        }
        String string4 = ",T0.G_ID";
        if (this.activeGraph == null) {
            string4 = ",NULL AS G_ID";
        }
        PPEvalInfo pPEvalInfo = this.getPPEvalInfo(set, set2);
        String string5 = pPEvalInfo.startCol;
        String string6 = pPEvalInfo.endCol;
        Set<Long> set3 = pPEvalInfo.optStartIDs;
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer2.append("HOP" + this.wCount + "_1(" + string5 + "," + string6 + "," + "G_ID" + ") AS\n(\nSELECT " + string3 + "T0." + string5 + ",T0." + string6 + string4 + "\nFROM (" + string + ") T0\n");
        if (set3 != null) {
            if (set3.size() == 1) {
                stringBuffer2.append("WHERE (T0." + string5 + "=" + set3.iterator().next().toString() + ")\n");
            } else {
                String string7 = this.buildIDInList(set3);
                stringBuffer2.append("WHERE (T0." + string5 + " IN " + string7 + ")\n");
            }
        }
        stringBuffer2.append(")");
        this.wList.add(stringBuffer2.toString());
        for (n3 = 2; n3 <= n2; ++n3) {
            stringBuffer2 = new StringBuffer("");
            stringBuffer2.append("HOP" + this.wCount + "_" + n3 + "(" + string5 + "," + string6 + "," + "G_ID" + ") AS\n(\nSELECT " + string2 + string3 + "T0." + string5 + ",T1." + string6 + string4 + "\nFROM HOP" + this.wCount + "_" + (n3 - 1) + " T0,(" + string + ") T1\nWHERE T0." + string6 + "=T1." + string5);
            if (this.activeGraph != null) {
                stringBuffer2.append("\nAND T0.G_ID=T1.G_ID");
            }
            stringBuffer2.append(")");
            this.wList.add(stringBuffer2.toString());
        }
        n3 = n > 0 ? n : 1;
        stringBuffer.append("SELECT * FROM(\n");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (int i = n3; i <= n2; ++i) {
            QueryUtils.appendToList(stringBuffer3, "(SELECT * FROM HOP" + this.wCount + "_" + i + ")", "\nUNION ALL\n", "");
        }
        stringBuffer.append(stringBuffer3.toString());
        stringBuffer.append(")");
        ++this.wCount;
        return stringBuffer.toString();
    }

    private PPEvalInfo getPPEvalInfo(Set<Long> set, Set<Long> set2) {
        String string = "START_NODE_ID";
        String string2 = this.linkObjCol;
        Set<Long> set3 = set;
        int n = this.getOptimalEvalDirection(set, set2);
        if (n == 1) {
            string = this.linkObjCol;
            string2 = "START_NODE_ID";
            set3 = set2;
        }
        return new PPEvalInfo(string, string2, set3);
    }

    private int getOptimalEvalDirection(Set<Long> set, Set<Long> set2) {
        if (set != null) {
            return 0;
        }
        if (set2 != null) {
            return 1;
        }
        return 0;
    }

    private static class PPEvalInfo {
        String startCol;
        String endCol;
        Set<Long> optStartIDs;

        public PPEvalInfo(String string, String string2, Set<Long> set) {
            this.startCol = string;
            this.endCol = string2;
            this.optStartIDs = set;
        }
    }
}

