/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.TriplesBlock;

public interface SelectivityEstimator {
    public Set<Stats> getTripleStats(Connection var1, Set<Model> var2, SPARQLBGP var3, Set<TriplesBlock> var4) throws SQLException;

    public long getTotalNumTuples(Connection var1, Set<Model> var2) throws SQLException;

    public static class Stats {
        private final long numMatching;
        private final BigDecimal selectivity;
        private final Set<String> vars;
        private final TriplesBlock triple;

        public Stats(long l, BigDecimal bigDecimal, TriplesBlock triplesBlock) {
            this.numMatching = l;
            this.selectivity = bigDecimal;
            this.vars = Stats.extractVariables(triplesBlock);
            this.triple = triplesBlock;
        }

        private static Set<String> extractVariables(TriplesBlock triplesBlock) {
            HashSet<String> hashSet = new HashSet<String>();
            if (triplesBlock.getSubject().isVariable()) {
                hashSet.add(triplesBlock.getSubject().getName());
            }
            if (triplesBlock.getPredicate().isVariable()) {
                hashSet.add(triplesBlock.getPredicate().getName());
            }
            if (triplesBlock.getObject().isVariable()) {
                hashSet.add(triplesBlock.getObject().getName());
            }
            return hashSet;
        }

        public Set<String> getVars() {
            return this.vars;
        }

        public int getNumVars() {
            return this.vars.size();
        }

        public long getNumMatching() {
            return this.numMatching;
        }

        public BigDecimal getSelectivity() {
            return this.selectivity;
        }

        public TriplesBlock getTriple() {
            return this.triple;
        }

        public int numVarsInCommon(Collection<? extends String> collection) {
            int n = 0;
            for (String string : this.vars) {
                if (!collection.contains(string)) continue;
                ++n;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Stats) {
                Stats stats = (Stats)object;
                return this.getTriple().equals(stats.getTriple());
            }
            return false;
        }

        public int hashCode() {
            return this.getTriple().hashCode();
        }

        public String toString() {
            return String.format("[%4.2f | % 12d] %s", this.selectivity.doubleValue(), this.numMatching, this.triple.toString());
        }
    }

    public static class Model {
        private final String name;
        private final boolean virtual;

        public Model(String string, boolean bl) {
            this.name = string;
            this.virtual = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean isVirtual() {
            return this.virtual;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Model) {
                Model model = (Model)object;
                if (this.getName().equalsIgnoreCase(model.getName()) && this.isVirtual() == model.isVirtual()) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 17;
            n2 = n2 * n + this.getName().toUpperCase().hashCode();
            n2 = n2 * n + Boolean.valueOf(this.isVirtual()).hashCode();
            return n2;
        }

        public String toString() {
            return this.name;
        }
    }
}

