/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Vector;
import oracle.spatial.rdf.server.GenerateQuery;
import oracle.spatial.rdf.server.IDTriple;
import oracle.spatial.rdf.server.InferenceEngine;
import oracle.spatial.rdf.server.LiteralSet;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.URIset;
import oracle.spatial.rdf.server.VariableSet;
import oracle.spatial.rdf.server.parser.sparql.ASTInput;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.sparqlParse;

public class Rule {
    public static final String BASIC_TRIPLES = "BASIC_TRIPLES";
    int type = 0;
    static final int TYPE_GENERAL = 0;
    static final int TYPE_AXIOM = 1;
    static final int TYPE_ONESHOT = 2;
    static final int NTYPES = 3;
    boolean ignore;
    boolean m_bSkipSyntaxCheck;
    boolean m_bUseWithClause;
    String m_szOptions;
    String name;
    String antecedents;
    String filter;
    String consequents;
    ASTInput antecedentsTree;
    ASTInput consequentsTree;
    VariableSet variables;
    boolean has_liN;
    Vector liN_refs;
    PreparedStatement stmt;

    Rule(ResultSet resultSet, String string) throws SQLException {
        this.name = resultSet.getString("NAME");
        this.antecedents = resultSet.getString("ANTECEDENTS");
        this.filter = resultSet.getString("FILTER");
        this.consequents = resultSet.getString("CONSEQUENTS");
        this.antecedentsTree = null;
        this.consequentsTree = null;
        this.variables = null;
        this.has_liN = false;
        this.liN_refs = new Vector();
        this.ignore = false;
        this.m_szOptions = string;
        this.m_bSkipSyntaxCheck = true;
        this.m_bUseWithClause = false;
        if (InferenceEngine.hasOption(this.m_szOptions, "LEGACY_MODE")) {
            System.out.println("Rule: user-defined rulebase codepath using LEGACY mode (syntax checks will be performed)");
            this.m_bSkipSyntaxCheck = false;
            this.m_bUseWithClause = true;
        } else {
            this.parseRuleOptions();
            if (this.filter != null) {
                throw new SQLException("Error: SQL filter is not allowed in user-defined rules");
            }
        }
    }

    void parse(sparqlParse sparqlParse2, Connection connection, String string, String string2) throws ParseException, SQLException {
        String string3;
        String string4 = QueryUtils.getNetworkStorageForm(connection, QueryUtils.getPfxForRdfObjName(QueryUtils.getNetworkOwnerOrMdsys(string), QueryUtils.getNetworkNameOrEmptyString(string2)));
        String string5 = string3 = string4.equals("UNESC") ? " STORAGE_FORM=UNESC " : "";
        if (this.antecedents == null) {
            this.type = 1;
        } else {
            this.antecedentsTree = sparqlParse2.parse(this.antecedents, string3);
            this.variables = sparqlParse2.variables;
        }
        this.consequentsTree = sparqlParse2.parse(this.consequents, string3);
        if (this.type != 1 && this.consequentsTree.getNVars() == 0) {
            this.type = 2;
        }
    }

    private void parseRuleOptions() {
        if (this.filter == null) {
            return;
        }
        this.filter = this.filter.trim();
        String string = this.filter.toUpperCase();
        int n = string.indexOf("/*+");
        int n2 = string.indexOf("*/");
        if (n != 0 || n2 < 0) {
            return;
        }
        String[] stringArray = string.substring(n + 3, n2).split("\\s+");
        this.filter = this.filter.substring(n2 + 2).trim();
        if (this.filter.length() == 0) {
            this.filter = null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3;
            if (stringArray[i].trim().length() == 0) continue;
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2.length == 2) {
                string3 = stringArray2[0];
                string2 = stringArray2[1];
            } else {
                if (stringArray2.length != 1) continue;
                string3 = stringArray2[0];
                string2 = null;
            }
            this.parseRuleOption(string3, string2);
        }
    }

    private void parseRuleOption(String string, String string2) {
        if (string.equals("ENABLE_SYNTAX_CHECKING")) {
            this.m_bSkipSyntaxCheck = false;
        } else if (string.equals("ENABLE_WITH_CLAUSE")) {
            this.m_bUseWithClause = true;
        }
    }

    IDTriple[] getAxiomTriples(URIset uRIset, LiteralSet literalSet) {
        int n = this.consequentsTree.getNTriples();
        Vector vector = this.consequentsTree.getTriples();
        IDTriple[] iDTripleArray = new IDTriple[n];
        for (int i = 0; i < n; ++i) {
            iDTripleArray[i] = new IDTriple();
            block5: for (int j = 0; j < 3; ++j) {
                ASTTripleAtom aSTTripleAtom = ((ASTTripleAtom[])vector.elementAt(i))[j];
                switch (aSTTripleAtom.type) {
                    case 1: {
                        iDTripleArray[i].set(j, uRIset.get(aSTTripleAtom.name));
                        if (j != 2) continue block5;
                        iDTripleArray[i].set(3, uRIset.get(aSTTripleAtom.name));
                        continue block5;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        iDTripleArray[i].set(j, literalSet.get(aSTTripleAtom));
                        if (j != 2) continue block5;
                        iDTripleArray[i].set(3, literalSet.getExact(aSTTripleAtom));
                        continue block5;
                    }
                }
            }
        }
        return iDTripleArray;
    }

    void generateSQL(SQLGenContext sQLGenContext, Connection connection, String string, String string2) throws SQLException, RDFException {
        StringBuilder stringBuilder;
        int n;
        String[] stringArray = new String[]{"START_NODE_ID", "P_VALUE_ID", "CANON_END_NODE_ID"};
        GenerateQuery generateQuery = new GenerateQuery();
        GenerateQuery generateQuery2 = null;
        boolean bl = false;
        sQLGenContext.varMap = this.variables;
        sQLGenContext.srcTabName = this.m_bUseWithClause ? BASIC_TRIPLES : "(" + string + ")";
        sQLGenContext.nTriples = 0;
        String string3 = QueryUtils.enquoteNameSQLName(this.name);
        if (this.m_bUseWithClause) {
            generateQuery.addWithMap(BASIC_TRIPLES, string);
        }
        if (this.filter == null) {
            generateQuery.buildJoin_LINK(sQLGenContext, this.antecedentsTree);
        } else {
            generateQuery2 = new GenerateQuery();
            generateQuery2.buildJoin_LINK(sQLGenContext, this.antecedentsTree);
            generateQuery2.buildJoin_VALUE(sQLGenContext, null);
        }
        generateQuery.distinct = true;
        if (this.name.equals("RDFS-RDFS3") || this.name.equals("RDFS-RDFS4B")) {
            if (this.filter == null) {
                generateQuery.addFrom("MDSYS.RDF_VALUE$ v");
                generateQuery.addWhere("v.value_id = " + this.variables.getMappingByName("O"));
                generateQuery.addWhere("v.value_type = 'UR'");
            } else {
                generateQuery2.addFrom("MDSYS.RDF_VALUE$ v");
                generateQuery2.addWhere("v.value_id = " + this.variables.getMappingByName("O"));
                generateQuery2.addWhere("v.value_type = 'UR'");
            }
            bl = true;
        }
        Vector vector = this.consequentsTree.getTriples();
        GenerateQuery[] generateQueryArray = new GenerateQuery[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            ASTTripleAtom[] aSTTripleAtomArray = (ASTTripleAtom[])vector.elementAt(n);
            generateQueryArray[n] = new GenerateQuery();
            generateQueryArray[n].addSelect("*");
            generateQueryArray[n].addFrom("(" + string + ") x");
            for (int i = 0; i < 3; ++i) {
                String string4;
                String string5 = "T" + n + "_" + i;
                ASTTripleAtom aSTTripleAtom = aSTTripleAtomArray[i];
                String string6 = null;
                switch (aSTTripleAtom.type) {
                    case 0: {
                        string4 = this.variables.getMappingByName(aSTTripleAtom.name);
                        String string7 = this.variables.getExactMappingByName(aSTTripleAtom.name);
                        if (i >= 2 || bl || this.m_bSkipSyntaxCheck || !this.variables.getMaybeLiteralByName(aSTTripleAtom.name)) break;
                        String string8 = "V" + n + "_" + i;
                        if (this.filter == null) {
                            generateQuery.addFrom("MDSYS.RDF_VALUE$ " + string8);
                            generateQuery.addWhere(string4 + " = " + string8 + ".value_id");
                        } else {
                            generateQuery2.addFrom("MDSYS.RDF_VALUE$ " + string8);
                            generateQuery2.addWhere(string4 + " = " + string8 + ".value_id");
                        }
                        string6 = string4;
                        string4 = "DECODE(" + string8 + ".value_type, 'UR', " + string4 + ", DECODE(" + string8 + ".value_type, 'BN', " + string4 + ", MDSYS.RDF_APIS.raiseURIError('" + string3 + "', " + i + ")))";
                        break;
                    }
                    case 1: {
                        String string7 = string4 = sQLGenContext.URImap.get(aSTTripleAtom.name);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string4 = sQLGenContext.litMap.get(aSTTripleAtom);
                        String string7 = sQLGenContext.litMap.getExact(aSTTripleAtom);
                        break;
                    }
                    default: {
                        throw new RDFException("Internal Error: Rule.generateSQL() invalid atom type " + aSTTripleAtom.type);
                    }
                }
                if (vector.size() > 1 || this.filter != null) {
                    generateQueryArray[n].addWhere("x." + stringArray[i] + " = " + string5);
                } else if (string4 != null && string4.startsWith("DECODE(")) {
                    generateQueryArray[n].addWhere("x." + stringArray[i] + " = " + string6);
                } else {
                    generateQueryArray[n].addWhere("x." + stringArray[i] + " = " + string4);
                }
                if (this.filter == null) {
                    generateQuery.addSelect(string4 + " " + string5);
                    continue;
                }
                generateQuery.addSelect(string5);
                generateQuery2.addSelect(string4 + " " + string5);
            }
        }
        if (this.filter != null) {
            throw new SQLException("Error: SQL filter is not allowed in rule " + string3);
        }
        if (vector.size() == 1) {
            generateQuery.addWhere("\nNOT EXISTS ( " + generateQueryArray[0].buildSQLQuery() + ")");
            stringBuilder = new StringBuilder().append("INSERT /*+ ").append(InferenceEngine.buildParallelHint(this.m_szOptions)).append(" append */ INTO ").append(string2).append(" (START_NODE_ID,P_VALUE_ID,CANON_END_NODE_ID) /* rule: ").append(string3).append(" */\n").append(generateQuery.buildSQLQuery());
        } else {
            stringBuilder = new StringBuilder().append("INSERT /*+ ").append(InferenceEngine.buildParallelHint(this.m_szOptions)).append(" */ ALL /* rule: ").append(string3).append(" */\n");
            for (n = 0; n < vector.size(); ++n) {
                stringBuilder.append("WHEN NOT EXISTS (").append(generateQueryArray[n].buildSQLQuery()).append(")\n").append("THEN INTO ").append(string2).append(" (START_NODE_ID,P_VALUE_ID,CANON_END_NODE_ID) VALUES(");
                for (int i = 0; i < 3; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("T").append(n).append("_").append(i);
                }
                stringBuilder.append(")\n");
            }
            stringBuilder.append(generateQuery.buildSQLQuery());
        }
        this.stmt = connection.prepareStatement(stringBuilder.toString());
    }

    int run() throws SQLException {
        long l = System.currentTimeMillis();
        int n = this.stmt.executeUpdate();
        long l2 = System.currentTimeMillis();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nrule ").append(this.name).append(" rowcnt = ").append(n).append(" (").append(l2 - l).append(" ms)");
        if (this.debugLoggingEnabled()) {
            System.out.println(stringBuilder.toString());
            System.out.println("rule " + this.name + " plan = ");
            Rule.dumpPlan(this.stmt.getConnection());
        }
        return n;
    }

    private boolean debugLoggingEnabled() {
        int n = InferenceEngine.extractOption(this.m_szOptions, "LOG", 0);
        return n >= 5;
    }

    void close() throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    public String toString() {
        String string = "A: " + this.antecedents + "\n";
        string = string + "F: " + this.filter + "\n";
        string = string + "C: " + this.consequents + "\n";
        return string;
    }

    public void resolve(Connection connection, URIset uRIset, LiteralSet literalSet) throws SQLException {
        int n = this.consequentsTree.getNTriples();
        Vector vector = this.consequentsTree.getTriples();
        for (int i = 0; i < n; ++i) {
            block5: for (int j = 0; j < 3; ++j) {
                ASTTripleAtom aSTTripleAtom = ((ASTTripleAtom[])vector.elementAt(i))[j];
                switch (aSTTripleAtom.type) {
                    case 1: {
                        if (uRIset.get(aSTTripleAtom.name) == null) {
                            uRIset.create(connection, aSTTripleAtom.name);
                        }
                        if (!aSTTripleAtom.name.matches("http://www.w3.org/1999/02/22-rdf-syntax-ns#_[0-9]*")) continue block5;
                        this.has_liN = true;
                        this.liN_refs.add(uRIset.get(aSTTripleAtom.name));
                        continue block5;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (literalSet.getExact(aSTTripleAtom) != null) continue block5;
                        literalSet.create(connection, aSTTripleAtom);
                    }
                }
            }
        }
    }

    protected HashSet getAntecedentPropIDs(URIset uRIset) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ASTTripleAtom[] aSTTripleAtomArray : this.antecedentsTree.tripleVec) {
            if (aSTTripleAtomArray[1].type != 1) continue;
            String string = uRIset.get(aSTTripleAtomArray[1].name);
            if (string == null) {
                hashSet.clear();
                this.ignore = true;
                return hashSet;
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    protected HashSet getConsequentPropIDs(URIset uRIset) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ASTTripleAtom[] aSTTripleAtomArray : this.consequentsTree.tripleVec) {
            if (aSTTripleAtomArray[1].type != 1) continue;
            String string = uRIset.get(aSTTripleAtomArray[1].name);
            hashSet.add(string);
        }
        return hashSet;
    }

    private static void dumpPlan(Connection connection) {
        CharSequence charSequence = null;
        try {
            charSequence = Rule.getPlan(connection);
        }
        catch (Exception exception) {
            System.out.println("error occured getting query plan: " + exception.getMessage());
            charSequence = null;
        }
        if (charSequence == null) {
            System.out.println("error: unable to dump query plan");
        } else {
            System.out.println("------------------------- PLAN -------------------------");
            System.out.println(charSequence);
            System.out.println("------------------------- END  -------------------------");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharSequence getPlan(Connection connection) throws SQLException {
        String string = "select SQL_ID from SYS.V_$SQL where SQL_TEXT like 'INSERT%' order by LAST_ACTIVE_TIME DESC";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        if (string2 == null) {
            throw new SQLException("unable to find SQL ID for last query");
        }
        preparedStatement = null;
        try {
            string = "select plan_table_output from table(dbms_xplan.display_cursor(?, format=>'TYPICAL IOSTATS -BYTES -COST LAST'))";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            StringBuilder stringBuilder = new StringBuilder();
            while (resultSet.next()) {
                stringBuilder.append(resultSet.getString(1));
                stringBuilder.append("\n");
            }
            if (stringBuilder.length() > 0) {
                StringBuilder stringBuilder2 = stringBuilder;
                return stringBuilder2;
            }
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }
}

