/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTPathSequence;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class PropertyPathSequenceRewriteOptimizer
implements SparqlQueryOptimizer {
    private int varCntr = 0;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        boolean bl = true;
        while (bl) {
            bl = this.transformOneSequence(node);
        }
        return node;
    }

    private boolean transformOneSequence(Node node) {
        LinkedList<SimpleNode> linkedList = new LinkedList<SimpleNode>();
        boolean bl = false;
        linkedList.add((SimpleNode)node);
        while (!linkedList.isEmpty() && !bl) {
            SimpleNode simpleNode = (SimpleNode)linkedList.remove();
            if (this.isTbWithRewritableSeqPropPath(simpleNode)) {
                bl = true;
                this.transformSequence(simpleNode);
            }
            if (bl) continue;
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                linkedList.add((SimpleNode)simpleNode.jjtGetChild(i));
            }
        }
        return bl;
    }

    private boolean isTbWithRewritableSeqPropPath(SimpleNode simpleNode) {
        if (simpleNode.id == 47 && simpleNode.jjtGetNumChildren() >= 2 && ((SimpleNode)simpleNode.jjtGetChild((int)1)).id == 66) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(1);
            if (OptimizerUtils.containsNodeType((Node)simpleNode2, 57)) {
                return false;
            }
            for (int i = 0; i < simpleNode2.jjtGetNumChildren(); ++i) {
                if (((SimpleNode)simpleNode2.jjtGetChild((int)i)).id != 73 && ((SimpleNode)simpleNode2.jjtGetChild((int)i)).id != 65 && ((SimpleNode)simpleNode2.jjtGetChild((int)i)).id != 67 && ((SimpleNode)simpleNode2.jjtGetChild((int)i)).id != 68 && ((SimpleNode)simpleNode2.jjtGetChild((int)i)).id != 66) continue;
                return true;
            }
        }
        return false;
    }

    private void transformSequence(SimpleNode simpleNode) {
        ASTTriplesBlock aSTTriplesBlock = (ASTTriplesBlock)simpleNode;
        ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)aSTTriplesBlock.jjtGetChild(0);
        ASTPathSequence aSTPathSequence = (ASTPathSequence)aSTTriplesBlock.jjtGetChild(1);
        ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)aSTTriplesBlock.jjtGetChild(2);
        boolean bl = false;
        ASTTriplesBlock aSTTriplesBlock2 = null;
        if (aSTTriplesBlock.jjtGetNumChildren() > 3) {
            bl = true;
            aSTTriplesBlock2 = (ASTTriplesBlock)aSTTriplesBlock.jjtGetChild(3);
            aSTTriplesBlock.jjtRemoveChild(3);
        }
        List<SimpleNode> list = this.extractSeqElements(aSTPathSequence);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SimpleNode simpleNode2 = list.get(i);
            aSTTriplesBlock.jjtAddChild(aSTTripleAtom, 0);
            aSTTripleAtom.jjtSetParent(aSTTriplesBlock);
            aSTTriplesBlock.jjtAddChild(simpleNode2, 1);
            simpleNode2.jjtSetParent(aSTTriplesBlock);
            ASTTripleAtom aSTTripleAtom3 = new ASTTripleAtom(73);
            aSTTripleAtom3.type = 0;
            aSTTripleAtom3.name = "PP$S$" + Integer.toString(this.varCntr);
            ++this.varCntr;
            aSTTriplesBlock.jjtAddChild(aSTTripleAtom3, 2);
            aSTTripleAtom3.jjtSetParent(aSTTriplesBlock);
            aSTTripleAtom = (ASTTripleAtom)aSTTripleAtom3.cloneNode();
            if (i >= n - 1) continue;
            ASTTriplesBlock aSTTriplesBlock3 = new ASTTriplesBlock(47);
            aSTTriplesBlock.jjtAddChild(aSTTriplesBlock3, 3);
            aSTTriplesBlock3.jjtSetParent(aSTTriplesBlock);
            aSTTriplesBlock = aSTTriplesBlock3;
        }
        aSTTriplesBlock.jjtAddChild(aSTTripleAtom2, 2);
        aSTTripleAtom2.jjtSetParent(aSTTriplesBlock);
        if (bl) {
            aSTTriplesBlock.jjtAddChild(aSTTriplesBlock2, 3);
            aSTTriplesBlock2.jjtSetParent(aSTTriplesBlock);
        }
    }

    private List<SimpleNode> extractSeqElements(ASTPathSequence aSTPathSequence) {
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
        SimpleNode simpleNode = null;
        for (int i = 0; i < aSTPathSequence.jjtGetNumChildren(); ++i) {
            simpleNode = (SimpleNode)aSTPathSequence.jjtGetChild(i);
            arrayList.add(simpleNode);
        }
        return arrayList;
    }
}

