/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.LinkedList;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class PropertyPathInverseRewriteOptimizer
implements SparqlQueryOptimizer {
    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        boolean bl = true;
        while (bl) {
            bl = this.transformInverse(node);
        }
        return node;
    }

    private boolean transformInverse(Node node) {
        LinkedList<SimpleNode> linkedList = new LinkedList<SimpleNode>();
        boolean bl = false;
        linkedList.add((SimpleNode)node);
        do {
            SimpleNode simpleNode;
            if (this.isTbWithRewritableInvPropPath(simpleNode = (SimpleNode)linkedList.remove())) {
                bl = true;
                this.transformInverse(simpleNode);
            }
            if (bl) continue;
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                linkedList.add((SimpleNode)simpleNode.jjtGetChild(i));
            }
        } while (!linkedList.isEmpty() && !bl);
        return bl;
    }

    private boolean isTbWithRewritableInvPropPath(SimpleNode simpleNode) {
        SimpleNode simpleNode2;
        return simpleNode.id == 47 && simpleNode.jjtGetNumChildren() >= 3 && (simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(1)).jjtGetNumChildren() > 0 && simpleNode2.id == 68 && ((SimpleNode)simpleNode2.jjtGetChild((int)0)).id == 73;
    }

    private void transformInverse(SimpleNode simpleNode) {
        ASTTriplesBlock aSTTriplesBlock = (ASTTriplesBlock)simpleNode;
        Node node = aSTTriplesBlock.jjtGetChild(0);
        Node node2 = aSTTriplesBlock.jjtGetChild(1);
        Node node3 = aSTTriplesBlock.jjtGetChild(2);
        Node node4 = node2.jjtGetChild(0);
        aSTTriplesBlock.replaceChild(node4, 1);
        aSTTriplesBlock.replaceChild(node3, 0);
        aSTTriplesBlock.replaceChild(node, 2);
    }
}

