/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import oracle.spatial.rdf.server.GenerateQuery;
import oracle.spatial.rdf.server.IDTriple;
import oracle.spatial.rdf.server.LiteralSet;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.Rule;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.URIset;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.sparqlParse;

public class InferenceEngine {
    String[] models;
    String[] rulebases;
    String dest;
    String options;
    Connection conn;
    String m_sourceTab;
    String m_network_owner;
    String m_network_name;
    LinkedList axioms;
    LinkedList rules;
    URIset URIs;
    LiteralSet literals;
    String srcQuery;
    boolean rdfsCMPAxioms;

    InferenceEngine(String[] stringArray, String[] stringArray2, String string, String string2, Connection connection, String string3, String string4) throws SQLException {
        this.models = stringArray;
        this.rulebases = stringArray2;
        this.dest = string;
        this.options = string2;
        this.conn = connection;
        this.rules = new LinkedList();
        this.axioms = new LinkedList();
        this.rdfsCMPAxioms = false;
        this.m_network_owner = string3;
        this.m_network_name = string4;
    }

    InferenceEngine(String string, String[] stringArray, String string2, String string3, Connection connection, String string4, String string5) throws SQLException {
        this.m_sourceTab = string;
        this.rulebases = stringArray;
        this.dest = string2;
        this.options = string3;
        this.conn = connection;
        this.rules = new LinkedList();
        this.axioms = new LinkedList();
        this.rdfsCMPAxioms = false;
        this.m_network_owner = string4;
        this.m_network_name = string5;
    }

    protected static void log(String string) {
        System.out.print("\n");
        System.out.print(string);
    }

    public void run() throws SQLException, RDFException, ParseException {
        try {
            this.loadRules();
            this.resolveNames();
            this.srcQuery = this.generateSource(null);
            this.runRules();
        }
        finally {
            this.closeRules();
        }
    }

    public void update(String string) throws SQLException, RDFException, ParseException {
        try {
            this.loadRules();
            this.resolveNames();
            this.srcQuery = this.generateSource(string);
            this.runRules();
        }
        finally {
            this.closeRules();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRules() throws SQLException, RDFException, ParseException {
        Statement statement = null;
        ResultSet resultSet = null;
        sparqlParse sparqlParse2 = new sparqlParse((Reader)null);
        try {
            String string = QueryUtils.getPfxForRdfObjName(QueryUtils.getNetworkOwnerOrMdsys(this.m_network_owner), QueryUtils.getNetworkNameOrEmptyString(this.m_network_name));
            String string2 = "";
            for (int i = 0; i < this.rulebases.length; ++i) {
                if (i > 0) {
                    string2 = string2 + "\nUNION ALL\n";
                }
                string2 = string2 + "SELECT '" + this.rulebases[i] + "-' || rule_name name, consequents, antecedents, filter\nFROM " + string + "RDFR_" + this.rulebases[i];
            }
            string2 = "SELECT MIN(NAME) NAME, consequents, antecedents, filter\nFROM (" + string2 + ")\nGROUP BY consequents, antecedents, filter";
            statement = this.conn.prepareStatement(string2);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Rule rule = new Rule(resultSet, this.options);
                rule.parse(sparqlParse2, this.conn, this.m_network_owner, this.m_network_name);
                if (rule.type == 1) {
                    this.axioms.add(rule);
                } else {
                    this.rules.add(rule);
                }
                if (!rule.name.equals("RDFS12")) continue;
                this.rdfsCMPAxioms = true;
            }
            this.URIs = sparqlParse2.URIs;
            this.literals = sparqlParse2.literals;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public void resolveNames() throws SQLException {
        Rule rule;
        if (this.rdfsCMPAxioms) {
            this.URIs.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
            this.URIs.put("http://www.w3.org/2000/01/rdf-schema#domain");
            this.URIs.put("http://www.w3.org/2000/01/rdf-schema#range");
            this.URIs.put("http://www.w3.org/2000/01/rdf-schema#Resource");
            this.URIs.put("http://www.w3.org/2000/01/rdf-schema#ContainerMembershipProperty");
        }
        String string = QueryUtils.getPfxForRdfObjName(QueryUtils.getNetworkOwnerOrMdsys(this.m_network_owner), QueryUtils.getNetworkNameOrEmptyString(this.m_network_name));
        String string2 = QueryUtils.getLocalValueDollarName(string);
        int n = QueryUtils.getNetworkMaxStringSize(this.conn, string);
        this.URIs.resolve(this.conn, string2);
        this.literals.resolve(this.conn, string2, n);
        ListIterator listIterator = this.rules.listIterator();
        while (listIterator.hasNext()) {
            rule = (Rule)listIterator.next();
            rule.resolve(this.conn, this.URIs, this.literals);
        }
        listIterator = this.axioms.listIterator();
        while (listIterator.hasNext()) {
            rule = (Rule)listIterator.next();
            rule.resolve(this.conn, this.URIs, this.literals);
        }
    }

    private void collectStats() throws SQLException {
        Statement statement = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(" { call mdsys.rdf_apis.analyze_intermediate(?,?) } ");
            statement = this.conn.prepareCall(stringBuffer.toString());
            statement.setString(1, this.m_network_owner);
            statement.setString(2, this.m_network_name);
            statement.execute();
            statement.close();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    private int getRowCount() throws SQLException {
        Statement statement = null;
        int n = 0;
        try {
            statement = this.conn.prepareStatement("select count(1) from " + this.dest);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
                resultSet.close();
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        return n;
    }

    public void runRules() throws SQLException, RDFException {
        int n;
        Rule rule;
        SQLGenContext sQLGenContext = new SQLGenContext();
        this.runAxioms();
        sQLGenContext.srcTabName = "BASIC_TRIPLES";
        sQLGenContext.URImap = this.URIs;
        sQLGenContext.litMap = this.literals;
        ListIterator listIterator = this.rules.listIterator();
        while (listIterator.hasNext()) {
            rule = (Rule)listIterator.next();
            if (rule.ignore) {
                listIterator.remove();
            }
            rule.generateSQL(sQLGenContext, this.conn, this.srcQuery, this.dest);
        }
        int n2 = n = this.getRowCount();
        int n3 = 0;
        for (int i = 0; i == 0 || n3 > 0; ++i) {
            n3 = 0;
            listIterator = this.rules.listIterator();
            while (listIterator.hasNext()) {
                int n4;
                int n5;
                rule = (Rule)listIterator.next();
                int n6 = rule.run();
                this.conn.commit();
                n3 += n6;
                n2 += n6;
                if (n6 > 0 && this.rdfsCMPAxioms && rule.has_liN) {
                    HashSet hashSet = new HashSet();
                    this.addCMPAxioms(hashSet, rule.liN_refs);
                    this.filterAxioms(hashSet);
                    this.insertAxioms(hashSet);
                    rule.has_liN = false;
                }
                if (n6 > 0 && rule.type == 2) {
                    rule.close();
                    listIterator.remove();
                }
                if ((n5 = n2 - n) < (n4 = n / 10 * 3) || n5 < 200) continue;
                this.collectStats();
                n = n2;
            }
        }
    }

    void closeRules() throws SQLException {
        if (this.rules == null) {
            return;
        }
        ListIterator listIterator = this.rules.listIterator();
        while (listIterator.hasNext()) {
            Rule rule = (Rule)listIterator.next();
            rule.close();
        }
    }

    String generateSource(String string) throws SQLException, RDFException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        boolean bl = false;
        if (this.m_sourceTab != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("SELECT start_node_id, p_value_id, canon_end_node_id, ").append("canon_end_node_id end_node_id\n").append("FROM ").append(this.m_sourceTab);
            string2 = stringBuffer2.toString();
        } else {
            if (bl) {
                stringBuffer.append("SELECT /*+ INLINE */ start_node_id, p_value_id, ").append("canon_end_node_id, canon_end_node_id end_node_id\n from (");
            }
            GenerateQuery generateQuery = new GenerateQuery();
            string2 = generateQuery.resolveModels(this.conn, this.models, string, "VALID", this.m_network_owner, this.m_network_name);
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(string2);
            stringBuffer.append("\nUNION ALL\n");
        }
        stringBuffer.append("SELECT start_node_id, p_value_id, canon_end_node_id, ").append("canon_end_node_id end_node_id\n").append("FROM ").append(this.dest);
        if (bl) {
            stringBuffer.append("\n)");
        }
        return stringBuffer.toString();
    }

    String makeInList(int n) {
        String string = "?";
        for (int i = 1; i < n; ++i) {
            string = string + ", ?";
        }
        return string;
    }

    String makeInList(int n, int n2) {
        String string = "(?";
        for (int i = 1; i < n2; ++i) {
            string = string + ", ?";
        }
        String string2 = string = string + ")";
        for (int i = 1; i < n; ++i) {
            string2 = string2 + ", " + string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAxioms() throws SQLException {
        HashSet<IDTriple> hashSet = new HashSet<IDTriple>();
        ListIterator listIterator = this.axioms.listIterator();
        while (listIterator.hasNext()) {
            Rule rule = (Rule)listIterator.next();
            IDTriple[] iDTripleArray = rule.getAxiomTriples(this.URIs, this.literals);
            for (int i = 0; i < iDTripleArray.length; ++i) {
                hashSet.add(iDTripleArray[i]);
            }
            if (!this.rdfsCMPAxioms || !rule.has_liN) continue;
            this.addCMPAxioms(hashSet, rule.liN_refs);
            rule.has_liN = false;
        }
        if (this.rdfsCMPAxioms) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = this.conn.createStatement();
                resultSet = statement.executeQuery(GenerateQuery.selectCMP(this.models));
                while (resultSet.next()) {
                    String string = resultSet.getString("VALUE_ID");
                    this.addCMPAxioms(hashSet, string);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        this.filterAxioms(hashSet);
        this.insertAxioms(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void filterAxioms(HashSet hashSet) throws SQLException {
        String string = "SELECT start_node_id s, p_value_id p, canon_end_node_id co\nFROM (" + this.srcQuery + ")\nWHERE (start_node_id, p_value_id, canon_end_node_id) IN\n(" + this.makeInList(hashSet.size(), 3) + ")";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (hashSet.isEmpty()) {
            return;
        }
        try {
            IDTriple iDTriple;
            preparedStatement = this.conn.prepareStatement(string);
            Iterator iterator = hashSet.iterator();
            int n = 1;
            while (iterator.hasNext()) {
                iDTriple = (IDTriple)iterator.next();
                preparedStatement.setLong(n++, iDTriple.s);
                preparedStatement.setLong(n++, iDTriple.p);
                preparedStatement.setLong(n++, iDTriple.co);
            }
            iDTriple = new IDTriple();
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                iDTriple.s = resultSet.getLong("S");
                iDTriple.p = resultSet.getLong("P");
                iDTriple.co = resultSet.getLong("CO");
                if (hashSet.remove(iDTriple)) continue;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertAxioms(HashSet hashSet) throws SQLException {
        Statement statement = null;
        if (hashSet.isEmpty()) {
            return;
        }
        try {
            statement = this.conn.prepareStatement("INSERT INTO " + this.dest + "(start_node_id, p_value_id, canon_end_node_id) VALUES(?, ?, ?)");
            for (IDTriple iDTriple : hashSet) {
                statement.setLong(1, iDTriple.s);
                statement.setLong(2, iDTriple.p);
                statement.setLong(3, iDTriple.co);
                statement.executeUpdate();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    void createTransientTable() throws SQLException {
    }

    public void addCMPAxioms(HashSet hashSet, String string) throws SQLException {
        IDTriple iDTriple = null;
        IDTriple iDTriple2 = null;
        IDTriple iDTriple3 = null;
        iDTriple = new IDTriple();
        iDTriple2 = new IDTriple();
        iDTriple3 = new IDTriple();
        iDTriple.set(0, string);
        iDTriple2.set(0, string);
        iDTriple3.set(0, string);
        String string2 = this.URIs.getOrCreate(this.conn, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        iDTriple.set(1, string2);
        string2 = this.URIs.getOrCreate(this.conn, "http://www.w3.org/2000/01/rdf-schema#ContainerMembershipProperty");
        iDTriple.set(2, string2);
        iDTriple.set(3, string2);
        string2 = this.URIs.getOrCreate(this.conn, "http://www.w3.org/2000/01/rdf-schema#domain");
        iDTriple2.set(1, string2);
        string2 = this.URIs.getOrCreate(this.conn, "http://www.w3.org/2000/01/rdf-schema#range");
        iDTriple3.set(1, string2);
        string2 = this.URIs.getOrCreate(this.conn, "http://www.w3.org/2000/01/rdf-schema#Resource");
        iDTriple2.set(2, string2);
        iDTriple2.set(3, string2);
        iDTriple3.set(2, string2);
        iDTriple3.set(3, string2);
        hashSet.add(iDTriple);
        hashSet.add(iDTriple2);
        hashSet.add(iDTriple3);
    }

    public void addCMPAxioms(HashSet hashSet, Vector vector) throws SQLException {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.addCMPAxioms(hashSet, (String)iterator.next());
        }
    }

    static int extractOption(String string, String string2, int n) {
        int n2;
        String string3 = InferenceEngine.extractOption(string, string2, Integer.toString(n));
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    static String extractOption(String string, String string2, String string3) {
        if (string == null) {
            return string3;
        }
        if (string.charAt(0) != ',') {
            string = "," + string;
        }
        if (string.charAt(string.length() - 1) != ',') {
            string = string + ",";
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        string2 = "," + string2 + "=";
        int n = string.indexOf(string2);
        if (n < 0) {
            return string3;
        }
        int n2 = string.indexOf(44, n += string2.length());
        if (n2 < 0) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }

    static boolean hasOption(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string.charAt(0) != ',') {
            string = "," + string;
        }
        if (string.charAt(string.length() - 1) != ',') {
            string = string + ",";
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        String string3 = "," + string2 + ",";
        if (string.indexOf(string3) != -1) {
            return true;
        }
        String string4 = "," + string2 + "=";
        return string.indexOf(string4) != -1;
    }

    static CharSequence buildParallelHint(String string) {
        int n = InferenceEngine.extractOption(string, "DOP", 1);
        if (n < 2) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" parallel(").append(n).append(") ");
        return stringBuilder;
    }

    public String toString() {
        String string = this.URIs.toString();
        for (int i = 0; i < 3; ++i) {
            Rule rule;
            string = string + "Axioms:\n";
            ListIterator listIterator = this.axioms.listIterator();
            while (listIterator.hasNext()) {
                rule = (Rule)listIterator.next();
                string = string + rule.toString() + "\n";
            }
            string = string + "Rules:\n";
            listIterator = this.rules.listIterator();
            while (listIterator.hasNext()) {
                rule = (Rule)listIterator.next();
                string = string + rule.toString() + "\n";
            }
        }
        return string;
    }
}

