/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.SPARQLBGP;

public interface HintGenerator {
    public static final String BGP_JOIN_KEYWORD = "BGP_JOIN";
    public static final String AJ_KEYWORD = "ANTI_JOIN";
    public static final String HASH_KEYWORD = "USE_HASH";
    public static final String NL_KEYWORD = "USE_NL";
    public static final int UNSELECTIVE = 0;
    public static final int SELECTIVE = 1;
    public static final String VAR_REGEX = "\\?([A-Z]|[0-9]|_)+";
    public static final Pattern VAR_REGEX_PATTERN = Pattern.compile("\\?([A-Z]|[0-9]|_)+", 2);
    public static final String JOIN_HINT_REGEX = " BGP_JOIN *\\([^\\)]*\\)";
    public static final Pattern JOIN_HINT_REGEX_PATTERN = Pattern.compile(" BGP_JOIN *\\([^\\)]*\\)", 2);
    public static final String AJ_HINT_REGEX = " ANTI_JOIN *\\([^\\)]*\\)";
    public static final Pattern AJ_HINT_REGEX_PATTERN = Pattern.compile(" ANTI_JOIN *\\([^\\)]*\\)", 2);
    public static final String LINK_JOIN_REGEX = "([^\\s]*\\s)*(USE_HASH|USE_NL)\\s*\\([^\\)]*T[0-9]+.*";
    public static final Pattern LINK_JOIN_REGEX_PATTERN = Pattern.compile("([^\\s]*\\s)*(USE_HASH|USE_NL)\\s*\\([^\\)]*T[0-9]+.*", 2);
    public static final String VALUE_JOIN_REGEX = "([^\\s]*\\s)*(USE_HASH|USE_NL)\\s*\\([^\\)]*V[0-9]+.*";
    public static final Pattern VALUE_JOIN_REGEX_PATTERN = Pattern.compile("([^\\s]*\\s)*(USE_HASH|USE_NL)\\s*\\([^\\)]*V[0-9]+.*", 2);
    public static final String[] LINK_JOIN_HINTS = new String[]{Hint.QueryOption.ALL_LINK_NL.getName(), Hint.QueryOption.ALL_LINK_HASH.getName()};
    public static final String[] SPM_JOIN_HINTS = new String[]{Hint.QueryOption.ALL_MVP_HASH.getName(), Hint.QueryOption.ALL_MVP_NL.getName(), Hint.QueryOption.ALL_SVP_HASH.getName(), Hint.QueryOption.ALL_SVP_NL.getName(), Hint.QueryOption.ALL_SPM_HASH.getName(), Hint.QueryOption.ALL_SPM_NL.getName(), Hint.QueryOption.NO_MVP_INDEX.getName(), Hint.QueryOption.NO_SVP_INDEX.getName(), Hint.QueryOption.NO_SPM_INDEX.getName()};
    public static final String[] VALUE_JOIN_HINTS = new String[]{Hint.QueryOption.ALL_LOCAL_VALUE_HASH.getName(), Hint.QueryOption.ALL_LOCAL_VALUE_NL.getName(), Hint.QueryOption.ALL_NONLOCAL_VALUE_HASH.getName(), Hint.QueryOption.ALL_NONLOCAL_VALUE_NL.getName()};

    public void setUserHint(String var1);

    public void addVarAlias(String var1, String var2);

    public void setSPARQLBGP(SPARQLBGP var1);

    public void setSPMInfo(Set<String> var1, Set<String> var2, Set<String> var3, Set<String> var4, Set<String> var5);

    public String generateHint();

    public String generateJoinHint(String var1, String var2);

    public String generateAntiJoinHint();

    public String generateValueJoinHint(Collection<String> var1, String var2);

    public boolean specifiesBGPPushDown();

    public Set<String> getHintVars();

    public Map<Hint.QueryOption, String> getQueryOptions();

    public Map<String, Integer> getTransOrderMap();
}

