/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.spatial.rdf.server.AntiJoinHintProvider;
import oracle.spatial.rdf.server.BGPJoinHintProvider;
import oracle.spatial.rdf.server.BasicGraphPattern;
import oracle.spatial.rdf.server.GeneralSQLHintProvider;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintProvider;
import oracle.spatial.rdf.server.QueryOptionHintProvider;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SimpleStatsHintProvider;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public class HintEngine {
    private static final String PARSE_ERR_FORMAT = "Illegal character '%1$c' found in column %2$d, %3$s";
    private static final String LEADING_HINT = "LEADING";
    private static final String ORDERED_HINT = "ORDERED";
    private static final HintEngine DEFAULT_INSTANCE = new HintEngine(SimpleStatsHintProvider.getInstance(), BGPJoinHintProvider.getInstance(), QueryOptionHintProvider.getInstance(), GeneralSQLHintProvider.getInstance(), AntiJoinHintProvider.getInstance());
    private static SessionContext sessionContext = new SessionContext();
    private HintProvider[] providers;

    public HintEngine(HintProvider ... hintProviderArray) {
        this.providers = hintProviderArray;
    }

    public static HintEngine getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static SessionContext getSessionContext() {
        return sessionContext;
    }

    static void setSessionContext(SessionContext sessionContext) {
        if (sessionContext == null) {
            throw new IllegalArgumentException("Session context can not be null");
        }
        HintEngine.sessionContext = sessionContext;
    }

    public Hint generateHint(SPARQLBGP sPARQLBGP, SQLGenContext sQLGenContext, String string, boolean bl) throws ParseException {
        Hint hint = Hint.EMPTY_HINT;
        if (string == null) {
            return hint;
        }
        List<HintProvider.HintToken> list = HintEngine.parseText(string);
        for (HintProvider hintProvider : this.providers) {
            Hint hint2 = hintProvider.generateHint(sPARQLBGP, sQLGenContext, list);
            hint = hint.merge(hint2);
        }
        hint = HintEngine.optimizeNoResults(hint, sPARQLBGP, sQLGenContext);
        List<HintProvider.HintToken> list2 = HintEngine.checkForMultipleProcessing(this.providers, list);
        for (HintProvider.HintToken hintToken : list2) {
            System.err.printf("[%5s] %7s: %s\n", "stats", "warning", String.format("user hint '%s' parsed more than once", hintToken));
        }
        if (!bl && !(list2 = HintEngine.checkForIgnoredTokens(this.providers, list)).isEmpty()) {
            throw new ParseException(String.format("unrecognized user hint, '%s'", list2.get(0)));
        }
        HintEngine.checkForConflicts(hint);
        return hint;
    }

    private static Hint optimizeNoResults(Hint hint, SPARQLBGP sPARQLBGP, SQLGenContext sQLGenContext) {
        BasicGraphPattern basicGraphPattern = new BasicGraphPattern();
        basicGraphPattern.addAll(sPARQLBGP.getTriplesBlocks(), sQLGenContext);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n = 0;
        for (TriplesBlock triplesBlock : basicGraphPattern.getTriplesList()) {
            if (!(triplesBlock.getSubject().exists() && triplesBlock.getPredicate().exists() && triplesBlock.getObject().exists())) {
                treeSet.add(n);
            }
            ++n;
        }
        if (treeSet.isEmpty()) {
            return hint;
        }
        Set<Hint.SQLHint> set = HintEngine.removeAllJoinOrderHints(hint.getSQLHints());
        Hint.SQLHint sQLHint = HintEngine.getJoinOrderHint(hint.getSQLHints());
        n = sQLHint != null ? HintEngine.getFirstJoinTripleIndex(sQLHint, basicGraphPattern) : (Integer)treeSet.iterator().next();
        if (!treeSet.contains(n)) {
            return hint;
        }
        Hint.SQLHint.Arg arg = Hint.SQLHint.Arg.createStaticArgument(String.format("t%d", n));
        set.add(Hint.SQLHint.createNoArgHint("NO_USE_HASH"));
        set.add(Hint.SQLHint.createNoArgHint("NO_USE_MERGE"));
        return new Hint(set, hint.getBGPJoinHints(), hint.getAntiJoinHints(), hint.getQueryOptionsMap());
    }

    private static Hint.SQLHint getJoinOrderHint(Set<Hint.SQLHint> set) {
        HashSet<Hint.SQLHint> hashSet = new HashSet<Hint.SQLHint>();
        boolean bl = false;
        for (Hint.SQLHint sQLHint : set) {
            String string = sQLHint.getName();
            if (string.equalsIgnoreCase(ORDERED_HINT)) {
                return sQLHint;
            }
            if (!string.equalsIgnoreCase(LEADING_HINT)) continue;
            hashSet.add(sQLHint);
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        Iterator iterator = hashSet.iterator();
        List<Hint.SQLHint.Arg> list = ((Hint.SQLHint)iterator.next()).getArguments();
        while (iterator.hasNext()) {
            if (list.equals(((Hint.SQLHint)iterator.next()).getArguments())) continue;
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        return (Hint.SQLHint)hashSet.iterator().next();
    }

    private static Set<Hint.SQLHint> removeAllJoinOrderHints(Set<Hint.SQLHint> set) {
        HashSet<Hint.SQLHint> hashSet = new HashSet<Hint.SQLHint>();
        for (Hint.SQLHint sQLHint : set) {
            String string = sQLHint.getName();
            if (string.equalsIgnoreCase(LEADING_HINT) || string.equalsIgnoreCase(ORDERED_HINT)) continue;
            hashSet.add(sQLHint);
        }
        return hashSet;
    }

    private static int getFirstJoinTripleIndex(Hint.SQLHint sQLHint, BasicGraphPattern basicGraphPattern) {
        int n;
        if (sQLHint.getName().equals(ORDERED_HINT)) {
            return 0;
        }
        List<Hint.SQLHint.Arg> list = sQLHint.getArguments();
        Hint.SQLHint.Arg arg = list.iterator().next();
        if (arg.isVariable()) {
            return -1;
        }
        if (!arg.getValue().matches("[tT]\\d+")) {
            System.err.printf("[%5s] %7s: %s\n", "hint", "info", "Unable to understand leading hint argument: " + arg.getValue() + ". Only an issue if trying to control join order of SPARQL triples");
            return -1;
        }
        try {
            n = Integer.parseInt(arg.getValue().substring(1));
        }
        catch (Exception exception) {
            return -1;
        }
        return n;
    }

    private static List<HintProvider.HintToken> checkForMultipleProcessing(HintProvider[] hintProviderArray, List<HintProvider.HintToken> list) {
        HashSet<HintProvider.HintToken> hashSet = new HashSet<HintProvider.HintToken>();
        HashSet<HintProvider.HintToken> hashSet2 = new HashSet<HintProvider.HintToken>();
        if (hintProviderArray.length < 2) {
            new LinkedList();
        }
        for (HintProvider hintProvider : hintProviderArray) {
            List<HintProvider.HintToken> list2 = hintProvider.getParsableTokens(list);
            for (HintProvider.HintToken hintToken : list2) {
                if (hashSet2.contains(hintToken)) {
                    hashSet.add(hintToken);
                }
                hashSet2.add(hintToken);
            }
        }
        boolean bl = false;
        return HintProvider.setToOrderedList(hashSet, list, bl);
    }

    private static List<HintProvider.HintToken> checkForIgnoredTokens(HintProvider[] hintProviderArray, List<HintProvider.HintToken> list) {
        HashSet<HintProvider.HintToken> hashSet = new HashSet<HintProvider.HintToken>();
        for (int i = 0; i < hintProviderArray.length; ++i) {
            List<HintProvider.HintToken> list2 = hintProviderArray[i].getIgnoredTokens(list);
            if (i == 0) {
                hashSet.addAll(list2);
                continue;
            }
            hashSet.retainAll(list2);
        }
        boolean bl = false;
        return HintProvider.setToOrderedList(hashSet, list, bl);
    }

    private static void checkForConflicts(Hint hint) throws ParseException {
    }

    private static String getParsingErrorMsg(char c, int n, String string) {
        return String.format(PARSE_ERR_FORMAT, Character.valueOf(c), n, string);
    }

    public static List<HintProvider.HintToken> parseText(String string) throws ParseException {
        return HintEngine.parseText(null, string);
    }

    private static boolean isNameChar(char c) {
        if (Character.isLetterOrDigit(c) || c == '_') {
            return true;
        }
        return !Character.isWhitespace(c) && c != '(' && c != ')' && c != '=' && c != '{' && c != '}' && c != ',';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<HintProvider.HintToken> parseText(HintProvider.HintToken hintToken, String string) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("'text' must be non-null");
        }
        LinkedList<HintProvider.HintToken> linkedList = new LinkedList<HintProvider.HintToken>();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        block6: while (c != '\uffff') {
            HintProvider.HintToken hintToken2;
            while (Character.isWhitespace(c) && c != '\uffff') {
                c = stringCharacterIterator.next();
            }
            if (c == '\uffff') return linkedList;
            if (!HintEngine.isNameChar(c)) {
                throw new ParseException(HintEngine.getParsingErrorMsg(c, stringCharacterIterator.getIndex(), "expected a space or valid hint name/argument character"));
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (HintEngine.isNameChar(c) && c != '\uffff') {
                stringBuilder.append(c);
                c = stringCharacterIterator.next();
            }
            char c2 = c;
            while (Character.isWhitespace(c) && c != '\uffff') {
                c2 = c;
                c = stringCharacterIterator.next();
            }
            if (Character.isWhitespace(c2) && c != '(' && c != '=') {
                c = stringCharacterIterator.previous();
            }
            if (Character.isWhitespace(c) || c == ',' || c == '\uffff') {
                hintToken2 = HintProvider.HintToken.createNoArgToken(hintToken, stringBuilder.toString());
                while (Character.isWhitespace(c) && c != '\uffff') {
                    c = stringCharacterIterator.next();
                }
                if (c == ',') {
                    c = stringCharacterIterator.next();
                }
            } else if (c == '(') {
                hintToken2 = HintProvider.HintToken.createToken(hintToken, stringBuilder.toString());
            } else {
                if (c != '=') throw new ParseException(HintEngine.getParsingErrorMsg(c, stringCharacterIterator.getIndex(), "expected a space, '(', or '='"));
                c = stringCharacterIterator.next();
                while (Character.isWhitespace(c) && c != '\uffff') {
                    c = stringCharacterIterator.next();
                }
                if (Character.isLetterOrDigit(c)) {
                    hintToken2 = HintProvider.HintToken.createEqualsToken(hintToken, stringBuilder.toString());
                    stringCharacterIterator.previous();
                } else {
                    if (c != '{') throw new ParseException(HintEngine.getParsingErrorMsg(c, stringCharacterIterator.getIndex(), "expected a letter or '{'"));
                    hintToken2 = HintProvider.HintToken.createBracketsToken(hintToken, stringBuilder.toString());
                }
            }
            linkedList.add(hintToken2);
            switch (hintToken2.getType()) {
                case NO_ARG: {
                    continue block6;
                }
                case PARENS: {
                    c = HintEngine.parseDelimiterArg(stringCharacterIterator, hintToken2, '(', ')');
                    continue block6;
                }
                case EQUALS: {
                    c = HintEngine.parseSingleArg(stringCharacterIterator, hintToken2);
                    continue block6;
                }
                case EQUALS_BRACKETS: {
                    c = HintEngine.parseDelimiterArg(stringCharacterIterator, hintToken2, '{', '}');
                    continue block6;
                }
            }
            throw new ParseException(HintEngine.getParsingErrorMsg(c, stringCharacterIterator.getIndex(), "expected a space, '(', or '='"));
        }
        return linkedList;
    }

    private static char parseSingleArg(CharacterIterator characterIterator, HintProvider.HintToken hintToken) throws ParseException {
        char c = characterIterator.next();
        if (!Character.isLetterOrDigit(c)) {
            throw new ParseException(HintEngine.getParsingErrorMsg(c, characterIterator.getIndex(), "expected a letter"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (HintEngine.isNameChar(c) && c != '\uffff') {
            stringBuilder.append(c);
            c = characterIterator.next();
        }
        HintProvider.HintToken.createNoArgToken(hintToken, stringBuilder.toString());
        return c;
    }

    private static char parseDelimiterArg(CharacterIterator characterIterator, HintProvider.HintToken hintToken, char c, char c2) throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        char c3 = characterIterator.next();
        while (c3 != '\uffff') {
            if (c3 == c2) {
                --n;
            }
            if (c3 == c) {
                ++n;
            }
            if (n < 0) {
                throw new ParseException(HintEngine.getParsingErrorMsg(c3, characterIterator.getIndex(), "unmatched '" + c2 + "'"));
            }
            if (n == 0) {
                c3 = characterIterator.next();
                break;
            }
            stringBuilder.append(c3);
            c3 = characterIterator.next();
        }
        if (n != 0) {
            throw new ParseException("Unmatched '" + c + "' for hint '" + hintToken.getValue() + "'. Found: '" + stringBuilder.toString() + "'");
        }
        HintEngine.parseText(hintToken, stringBuilder.toString());
        return c3;
    }

    public static final class SessionContext {
        private boolean logStats = false;

        public boolean isLogStats() {
            return this.logStats;
        }

        public void setLogStats(boolean bl) {
            this.logStats = bl;
        }
    }
}

