/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Hint {
    public static final Hint EMPTY_HINT = new Hint(new TreeSet(), new TreeSet(), new TreeSet(), new HashMap());
    private final Set<SQLHint> sqlHints;
    private final Set<JoinHint> bgpJoinHints;
    private final Set<AntiJoinHint> antiJoinHints;
    private final Map<QueryOption, String> queryOptions;

    public Hint(Collection<? extends SQLHint> collection, Collection<? extends JoinHint> collection2, Collection<? extends AntiJoinHint> collection3, Map<? extends QueryOption, String> map) {
        TreeSet<? extends SQLHint> treeSet = new TreeSet<SQLHint>();
        TreeSet<? extends JoinHint> treeSet2 = new TreeSet<JoinHint>();
        TreeSet<? extends AntiJoinHint> treeSet3 = new TreeSet<AntiJoinHint>();
        HashMap<? extends QueryOption, String> hashMap = new HashMap<QueryOption, String>();
        if (collection != null) {
            treeSet.addAll(collection);
        }
        if (collection2 != null) {
            treeSet2.addAll(collection2);
        }
        if (collection3 != null) {
            treeSet3.addAll(collection3);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        this.sqlHints = Collections.unmodifiableSet(treeSet);
        this.bgpJoinHints = Collections.unmodifiableSet(treeSet2);
        this.antiJoinHints = Collections.unmodifiableSet(treeSet3);
        this.queryOptions = Collections.unmodifiableMap(hashMap);
    }

    public Hint merge(Hint hint) {
        if (hint == null) {
            return this;
        }
        HashSet<SQLHint> hashSet = new HashSet<SQLHint>();
        HashSet<JoinHint> hashSet2 = new HashSet<JoinHint>();
        HashSet<AntiJoinHint> hashSet3 = new HashSet<AntiJoinHint>();
        HashMap<QueryOption, String> hashMap = new HashMap<QueryOption, String>();
        hashSet.addAll(this.getSQLHints());
        hashSet2.addAll(this.getBGPJoinHints());
        hashSet3.addAll(this.getAntiJoinHints());
        hashMap.putAll(this.getQueryOptionsMap());
        hashSet.addAll(hint.getSQLHints());
        hashSet2.addAll(hint.getBGPJoinHints());
        hashSet3.addAll(hint.getAntiJoinHints());
        hashMap.putAll(hint.getQueryOptionsMap());
        return new Hint(hashSet, hashSet2, hashSet3, hashMap);
    }

    public Set<SQLHint> getSQLHints() {
        return this.sqlHints;
    }

    public Set<JoinHint> getBGPJoinHints() {
        return this.bgpJoinHints;
    }

    public Set<AntiJoinHint> getAntiJoinHints() {
        return this.antiJoinHints;
    }

    public Set<QueryOption> getQueryOptions() {
        return Collections.unmodifiableSet(this.queryOptions.keySet());
    }

    public Map<QueryOption, String> getQueryOptionsMap() {
        return this.queryOptions;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 17;
        n2 = n2 * n + this.getSQLHints().hashCode();
        n2 = n2 * n + this.getBGPJoinHints().hashCode();
        n2 = n2 * n + this.getAntiJoinHints().hashCode();
        n2 = n2 * n + this.getQueryOptionsMap().hashCode();
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Hint) {
            Hint hint = (Hint)object;
            if (this.getSQLHints().equals(hint.getSQLHints()) && this.getBGPJoinHints().equals(hint.getBGPJoinHints()) && this.getAntiJoinHints().equals(hint.getAntiJoinHints()) && this.getQueryOptionsMap().equals(hint.getQueryOptionsMap())) {
                return true;
            }
        }
        return false;
    }

    public static enum QueryOption {
        USE_EXACT_VALS("GET_EXACT_VALUES"),
        NO_OPT_TRANS_FOR_LEADING("NO_OPT_TRANSITIVITY"),
        USE_WITH("USE_WITH"),
        BGP_PUSH_DOWN("PULL_PARENT_BGP"),
        ALL_LOCAL_VALUE_HASH("ALL_LOCAL_VALUE_HASH"),
        ALL_LOCAL_VALUE_NL("ALL_LOCAL_VALUE_NL"),
        ALL_NONLOCAL_VALUE_HASH("ALL_NONLOCAL_VALUE_HASH"),
        ALL_NONLOCAL_VALUE_NL("ALL_NONLOCAL_VALUE_NL"),
        ALL_NONLOCAL_VALUE_NO_MERGE("ALL_NONLOCAL_VALUE_NO_MERGE"),
        ALL_LINK_HASH("ALL_LINK_HASH"),
        ALL_LINK_NL("ALL_LINK_NL"),
        ALL_MVP_HASH("ALL_MVP_HASH"),
        ALL_MVP_NL("ALL_MVP_NL"),
        ALL_SPM_HASH("ALL_SPM_HASH"),
        ALL_SPM_NL("ALL_SPM_NL"),
        ALL_SVP_HASH("ALL_SVP_HASH"),
        ALL_SVP_NL("ALL_SVP_NL"),
        ALL_PCN_HASH("ALL_PCN_HASH"),
        ALL_PCN_NL("ALL_PCN_NL"),
        LEX_JOIN("LEX_JOIN"),
        NO_LINK_INDEX("ALL_LINK_NO_INDEX"),
        NO_VALUE_INDEX("ALL_LOCAL_VALUE_NO_INDEX"),
        NO_NL_VALUE_INDEX("ALL_NONLOCAL_VALUE_NO_INDEX"),
        NO_SPM_INDEX("ALL_SPM_NO_INDEX"),
        NO_MVP_INDEX("ALL_MVP_NO_INDEX"),
        NO_SVP_INDEX("ALL_SVP_NO_INDEX"),
        NO_PCN_INDEX("ALL_PCN_NO_INDEX"),
        USE_PP_HASH("USE_PP_HASH"),
        USE_PP_NL("USE_PP_NL"),
        DISABLE_PP_SJ("DISABLE_PP_SJ"),
        DISABLE_PP_SJ_DIST("DISABLE_PP_DIST_SJ"),
        DEF_NON_NULL("NON_NULL"),
        USE_PP_RW("USE_PP_RW"),
        RW_PP_DISTINCT("RW_PP_DISTINCT"),
        USE_PP_BFS("USE_PP_BFS"),
        USE_PP_DFS("USE_PP_DFS"),
        MAX_PP_DEPTH("MAX_PP_DEPTH");

        String name;

        private QueryOption(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class AntiJoinHint
    extends Enum<AntiJoinHint> {
        public static final /* enum */ AntiJoinHint HASH_AJ = new AntiJoinHint("HASH_AJ");
        public static final /* enum */ AntiJoinHint NL_AJ = new AntiJoinHint("NL_AJ");
        public static final /* enum */ AntiJoinHint MERGE_AJ = new AntiJoinHint("MERGE_AJ");
        public static final /* enum */ AntiJoinHint NO_UNNEST = new AntiJoinHint("NO_UNNEST");
        public static final /* enum */ AntiJoinHint UNNEST = new AntiJoinHint("UNNEST");
        private final String name;
        private static final /* synthetic */ AntiJoinHint[] $VALUES;

        public static AntiJoinHint[] values() {
            return (AntiJoinHint[])$VALUES.clone();
        }

        public static AntiJoinHint valueOf(String string) {
            return Enum.valueOf(AntiJoinHint.class, string);
        }

        private AntiJoinHint(String string2) {
            assert (string2 != null) : "AntiJoinHint given null name";
            assert (string2.trim().length() > 0) : "AntiJoinHint given no (empty) name";
            this.name = string2.toUpperCase();
        }

        public String getName() {
            return this.name;
        }

        public String toSQLString() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            $VALUES = new AntiJoinHint[]{HASH_AJ, NL_AJ, MERGE_AJ, NO_UNNEST, UNNEST};
        }
    }

    public static final class JoinHint
    extends Enum<JoinHint> {
        public static final /* enum */ JoinHint USE_NL = new JoinHint("USE_NL", Type.PAIR);
        public static final /* enum */ JoinHint USE_HASH = new JoinHint("USE_HASH", Type.PAIR);
        public static final /* enum */ JoinHint SWAP_JOIN_INPUTS = new JoinHint("SWAP_JOIN_INPUTS", Type.RIGHT_ONLY);
        public static final /* enum */ JoinHint NO_MERGE = new JoinHint("NO_MERGE", Type.INDIVIDUAL);
        private final String name;
        private final Type type;
        private static final /* synthetic */ JoinHint[] $VALUES;

        public static JoinHint[] values() {
            return (JoinHint[])$VALUES.clone();
        }

        public static JoinHint valueOf(String string) {
            return Enum.valueOf(JoinHint.class, string);
        }

        private JoinHint(String string2, Type type) {
            assert (string2 != null) : "JoinHint given null name";
            assert (string2.trim().length() > 0) : "JoinHint given no (empty) name";
            assert (type != null) : "JoinHint given null type";
            this.name = string2.toUpperCase();
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        private Type getType() {
            return this.type;
        }

        public String toSQLString(String string, String string2) {
            return this.type.format(this.name, string, string2);
        }

        public String toString() {
            return this.name;
        }

        static {
            $VALUES = new JoinHint[]{USE_NL, USE_HASH, SWAP_JOIN_INPUTS, NO_MERGE};
        }

        private static enum Type {
            INDIVIDUAL("%1$s(%2$s) %1$s(%3$s)"),
            PAIR("%1$s(%2$s %3$s)"),
            LEFT_ONLY("%1$s(%2$s)"),
            RIGHT_ONLY("%1$s(%3$s)");

            private String format;

            private Type(String string2) {
                this.format = string2;
            }

            public String format(String string, String string2, String string3) {
                return String.format(this.format, string, string2, string3);
            }
        }
    }

    public static class SQLHint
    implements Comparable<SQLHint> {
        private static final String PAREN_FORMAT = "%1$s(%2$s)";
        private static final String BOOLEAN_FORMAT = "%1$s=%2$s";
        private static final String NO_ARG_FORMAT = "%1$s%2$s";
        private final String name;
        private final List<Arg> arguments;
        private final String format;

        private SQLHint(String string, Collection<? extends Arg> collection, String string2) {
            assert (string != null) : "Hint.SQLHint constructor given null name";
            assert (string.trim().length() > 0) : "Hint.SQLHint constructor given empty name";
            this.name = string;
            this.format = string2;
            LinkedList<Arg> linkedList = new LinkedList<Arg>();
            if (collection != null) {
                for (Arg arg : collection) {
                    linkedList.add(arg);
                }
            }
            this.arguments = Collections.unmodifiableList(linkedList);
        }

        public static SQLHint createNoArgHint(String string) {
            return new SQLHint(string, new LinkedList(), NO_ARG_FORMAT);
        }

        public static SQLHint createSingleArgHint(String string, Arg arg, boolean bl) {
            LinkedList<Arg> linkedList = new LinkedList<Arg>();
            linkedList.add(arg);
            return new SQLHint(string, linkedList, bl ? BOOLEAN_FORMAT : PAREN_FORMAT);
        }

        public static SQLHint createMultiArgHint(String string, Collection<? extends Arg> collection) {
            if (collection.isEmpty()) {
                return SQLHint.createNoArgHint(string);
            }
            return new SQLHint(string, collection, PAREN_FORMAT);
        }

        public String getName() {
            return this.name;
        }

        public List<Arg> getArguments() {
            return this.arguments;
        }

        public Set<Arg> getVariables() {
            HashSet<Arg> hashSet = new HashSet<Arg>();
            for (Arg arg : this.arguments) {
                if (!arg.isVariable()) continue;
                hashSet.add(arg);
            }
            return hashSet;
        }

        public String toSQLString() {
            return this.toSQLString(null);
        }

        public String toSQLString(Map<Arg, String> map) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.arguments.isEmpty()) {
                for (Arg arg : this.arguments) {
                    String string = null;
                    if (map != null && map.containsKey(arg)) {
                        string = map.get(arg);
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    if (arg.isVariable() && string != null) {
                        stringBuilder.append(string);
                        continue;
                    }
                    stringBuilder.append(arg.getValue());
                }
            }
            return String.format(this.format, this.name, stringBuilder.toString());
        }

        public String toString() {
            return this.toSQLString(new HashMap<Arg, String>());
        }

        public int hashCode() {
            int n = 17;
            int n2 = 31;
            n2 = n2 * n + this.getName().toUpperCase().hashCode();
            n2 = n2 * n + this.getArguments().hashCode();
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof SQLHint) {
                SQLHint sQLHint = (SQLHint)object;
                if (this.getName().equalsIgnoreCase(sQLHint.getName()) && this.getArguments().equals(sQLHint.getArguments())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(SQLHint sQLHint) {
            if (!sQLHint.getName().equals(this.getName())) {
                return this.getName().compareTo(sQLHint.getName());
            }
            if (sQLHint.getArguments().size() != this.getArguments().size()) {
                return this.getArguments().size() - sQLHint.getArguments().size();
            }
            for (int i = 0; i < sQLHint.getArguments().size(); ++i) {
                Arg arg;
                Arg arg2 = this.getArguments().get(i);
                if (arg2.compareTo(arg = sQLHint.getArguments().get(i)) == 0) continue;
                return arg2.compareTo(arg);
            }
            return 0;
        }

        public static class Arg
        implements Comparable<Arg> {
            private final boolean variable;
            private final String value;

            private Arg(String string, boolean bl) {
                assert (string != null) : "Hint.SQLHint.Arg constructor given null value";
                assert (string.trim().length() > 0) : "Hint.SQLHint.Arg constructor given empty value";
                this.variable = bl;
                this.value = string;
            }

            public static Arg createStaticArgument(String string) {
                return new Arg(string, false);
            }

            public static Arg createVariableArgument(String string) {
                return new Arg(string, true);
            }

            public String getValue() {
                return this.value;
            }

            public boolean isVariable() {
                return this.variable;
            }

            public boolean isStatic() {
                return !this.variable;
            }

            public int hashCode() {
                int n = 31;
                int n2 = 17;
                n2 = n2 * n + this.getValue().toUpperCase().hashCode();
                n2 = n2 * n + (this.isVariable() ? 0 : 1);
                return n2;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object instanceof Arg) {
                    Arg arg = (Arg)object;
                    if (this.isVariable() == arg.isVariable() && this.getValue().equalsIgnoreCase(arg.getValue())) {
                        return true;
                    }
                }
                return false;
            }

            public String toString() {
                return this.getValue();
            }

            @Override
            public int compareTo(Arg arg) {
                if (this.isVariable() && !arg.isVariable()) {
                    return -1;
                }
                if (!this.isVariable() && arg.isVariable()) {
                    return 1;
                }
                return this.getValue().compareTo(arg.getValue());
            }
        }
    }
}

