/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.AbstractSPARQLTreeNode;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SQLGenContext;

public class CurlyBraceSPARQLTreeNode
extends AbstractSPARQLTreeNode
implements SPARQLTreeNode {
    private Set<String> pushedVars = new HashSet<String>();
    private Set<String> postVars = new HashSet<String>();
    private Map<String, List<String>> valueJoinInfo = new HashMap<String, List<String>>();
    private String[] fromAddition = new String[1];
    private String[] whereAddition = new String[1];

    public CurlyBraceSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2) {
        super(n, sQLGenContext, n2);
    }

    @Override
    public boolean containsEmptyBGP() {
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            if (!sPARQLTreeNode.containsEmptyBGP()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setProjections() throws RDFException {
        this.extractValueJoinInfo();
        if (this.getNumChildren() == 1) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(0);
            sPARQLTreeNode.addProjectVars(this.pushedVars);
            sPARQLTreeNode.setProjections();
        }
    }

    @Override
    public String toSQL() throws RDFException {
        String string = "";
        if (this.getNumChildren() == 1) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(0);
            string = sPARQLTreeNode.toSQL();
            Set<String> set = sPARQLTreeNode.getDefiniteBoundVars();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                sPARQLTreeNode.genOuterSelectComponents(this.postVars, set, this.valueJoinInfo, this.fromAddition, this.whereAddition, hashMap, this.getLobVars());
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage(), sQLException);
            }
            ArrayList<String> arrayList = new ArrayList();
            try {
                arrayList = this.buildFinalProjectCols();
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage(), sQLException);
            }
            string = this.wrapFinalSelect(string, arrayList, hashMap.values());
            if (this.ctx.networkStorageForm.equals("UNESC")) {
                if (!this.ctx.unescapeResults) {
                    string = this.wrapForEscapeSpecialChars(string, this.ctx.varMap.indexedNames, null, true);
                }
            } else if (this.ctx.unescapeResults) {
                string = this.wrapForUnescape(string, this.ctx.varMap.indexedNames, null, true);
            }
        } else if (this.getNumChildren() == 0) {
            string = "SELECT NULL FROM DUAL";
        } else {
            throw new RDFException("Syntax Tree Error: ASTCurlyBraceQuery with more than one child");
        }
        return string;
    }

    private void extractValueJoinInfo() {
        Object[] objectArray = this.ctx.varMap.indexedNames.toArray();
        if (objectArray.length > 0) {
            HashSet<String> hashSet = new HashSet<String>(this.getPushCandidates());
            hashSet.addAll(this.getAllLexVars());
            int n = 0;
            for (int i = 0; i < this.ctx.pIDs.length; ++i) {
                n = this.ctx.pIDs[i];
                if (n % 8 == 1) continue;
                String string = (String)objectArray[n / 8];
                if (hashSet.contains(string = string.toUpperCase())) {
                    this.pushedVars.add(string);
                    continue;
                }
                this.postVars.add(string);
            }
        }
    }

    private List<String> buildFinalProjectCols() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = this.ctx.varMap.indexedNames.toArray();
        int n = objectArray.length * 8;
        String string = "R";
        Set<String> set = this.getAllLexVars();
        if (n > 0) {
            int n2;
            SPARQLTreeNode sPARQLTreeNode = this.getChild(0);
            int n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 < this.ctx.pIDs.length; ++n2) {
                n4 = this.ctx.pIDs[n2];
                String string2 = ((String)objectArray[n4 / 8]).toUpperCase();
                if (n4 > n3) {
                    for (int i = n3; i < n4; ++i) {
                        arrayList.add(QueryUtils.buildAliasExpr(this.ctx, "NULL", (String)objectArray[i / 8] + this.finalCols[i % 8]));
                    }
                }
                if (this.pushedVars.contains(string2) || n4 % 8 == 1) {
                    if (n4 % 8 == 1 && this.ctx.hashVids && set.contains(string2)) {
                        String string3 = this.buildRDFTForVar(string, string2, this.valueJoinInfo, false, false, false, true);
                        arrayList.add(QueryUtils.buildAliasExpr(this.ctx, QueryUtils.buildVidHash(string3), string2 + this.finalCols[n4 % 8]));
                    } else {
                        arrayList.add(QueryUtils.buildAliasExpr(this.ctx, string + "." + (String)objectArray[n4 / 8] + this.finalCols[n4 % 8], (String)objectArray[n4 / 8] + this.finalCols[n4 % 8]));
                    }
                } else {
                    List<String> list = this.valueJoinInfo.get(string2);
                    arrayList.add(QueryUtils.buildAliasExpr(this.ctx, list.get(n4 % 8), (String)objectArray[n4 / 8] + this.finalCols[n4 % 8]));
                }
                n3 = n4 + 1;
            }
            for (n2 = n3; n2 < n; ++n2) {
                arrayList.add(QueryUtils.buildAliasExpr(this.ctx, "NULL", (String)objectArray[n2 / 8] + this.finalCols[n2 % 8]));
            }
        }
        if ((this.ctx.contextFlags & 3) > 0) {
            arrayList.add(QueryUtils.buildAliasExpr(this.ctx, string + ".T0_CTXT2", "T0_CTXT2"));
        } else if (n == 0) {
            arrayList.add("NULL");
        }
        return arrayList;
    }

    private String wrapFinalSelect(String string, List<String> list, Collection<String> collection) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = this.buildFinalValueJoinHint(collection);
        stringBuffer.append("SELECT ").append(string2).append(" ");
        boolean bl = false;
        int n = 1;
        for (String string3 : list) {
            if (!bl) {
                stringBuffer.append(string3);
                bl = true;
            } else {
                stringBuffer.append(", " + string3);
            }
            if (n % 8 == 0) {
                stringBuffer.append("\n");
            }
            ++n;
        }
        stringBuffer.append(" FROM (");
        stringBuffer.append(string);
        stringBuffer.append(") R");
        stringBuffer.append(this.fromAddition[0]);
        stringBuffer.append("\n");
        stringBuffer.append("WHERE (1=1)");
        stringBuffer.append(this.whereAddition[0]);
        return stringBuffer.toString();
    }
}

