/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.spatial.rdf.server.BasicGraphPattern;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.TriplesBlock;

public class ClauseTreeNode {
    public String edgeRowSrc;
    public String label;
    public String type;
    public BasicGraphPattern bgp;
    public int children_left;
    public List<ClauseTreeNode> children;
    protected ClauseTreeNode parent;
    public Map<String, String> edgeTable;
    public Map<String, String> varset;
    public Map<String, String> rdfTermSet;
    public Map<String, String> varTable;
    private Set<String> newBindings;
    private HashSet<String> variablesToBeJoined;
    public final String subjectCol = "START_NODE_ID";
    public final String predicateCol = "P_VALUE_ID";
    public final String canonObjCol = "CANON_END_NODE_ID";
    public final String exactObjCol = "END_NODE_ID";
    private static final String DUMMY_VAR_PREFIX = "DUMMY$";
    private SortedSet<String> dummyVarsForLOJ;
    private List<Filter> filters;
    private Set<String> filterJoinVars;
    private Map<String, Integer> hint0leadPosMap;
    boolean m_bLog = false;
    private int id;

    public static void printClauseTree(String string, ClauseTreeNode clauseTreeNode) {
        System.out.println(clauseTreeNode.debugToString(string));
        List<ClauseTreeNode> list = clauseTreeNode.children;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ClauseTreeNode.printClauseTree(string + " ", list.get(i));
            }
        }
    }

    private static void log(String string) {
        System.out.print("\n");
        System.out.print(string);
    }

    private static String appendToList(String string, String string2, String string3, String string4) {
        String string5 = "";
        string5 = string.equalsIgnoreCase(string4) ? string + string2 : string + string3 + string2;
        return string5;
    }

    public ClauseTreeNode() {
        this.label = null;
        this.children_left = 0;
        this.children = new ArrayList<ClauseTreeNode>();
        this.hint0leadPosMap = new HashMap<String, Integer>();
        this.filters = new ArrayList<Filter>();
        this.filterJoinVars = new HashSet<String>();
        this.newBindings = new HashSet<String>();
        this.varset = new HashMap<String, String>();
        this.id = -1;
        this.dummyVarsForLOJ = new TreeSet<String>();
        this.bgp = new BasicGraphPattern();
    }

    public ClauseTreeNode(String string, int n) {
        this.edgeRowSrc = string;
        this.label = null;
        this.children_left = 0;
        this.children = new ArrayList<ClauseTreeNode>();
        this.hint0leadPosMap = new HashMap<String, Integer>();
        this.filters = new ArrayList<Filter>();
        this.filterJoinVars = new HashSet<String>();
        this.newBindings = new HashSet<String>();
        this.varset = new HashMap<String, String>();
        this.id = n;
        this.dummyVarsForLOJ = new TreeSet<String>();
        this.addDummyVarForLOJ(this.getDummyVarName());
        this.bgp = new BasicGraphPattern();
    }

    public String getDummyVarName() {
        return DUMMY_VAR_PREFIX + this.id;
    }

    public SortedSet<String> getDummyVarsForLOJ() {
        return this.dummyVarsForLOJ;
    }

    public void addDummyVarForLOJ(String string) {
        this.dummyVarsForLOJ.add(string);
    }

    public int getNumChildren() {
        int n = 0;
        if (this.children != null) {
            n = this.children.size();
        }
        return n;
    }

    public ClauseTreeNode getChild(int n) {
        ClauseTreeNode clauseTreeNode = null;
        if (this.children != null) {
            clauseTreeNode = this.children.get(n);
        }
        return clauseTreeNode;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public List<Filter> getLocalFilters() {
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : this.filters) {
            if ((filter.getSpecialCaseFlags() & 1) <= 0) continue;
            arrayList.add(filter);
        }
        return arrayList;
    }

    public List<Filter> getNonLocalFilters() {
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : this.filters) {
            if ((filter.getSpecialCaseFlags() & 1) > 0) continue;
            arrayList.add(filter);
        }
        return arrayList;
    }

    public void addFilterJoinVar(String string) {
        this.filterJoinVars.add(string);
    }

    public Set<String> getFilterJoinVars() {
        return this.filterJoinVars;
    }

    public void setSpecialCaseFilters() throws RDFException {
        for (Filter filter : this.filters) {
            filter.setIsLocal(this.newBindings);
            filter.setUsesBound();
        }
    }

    public void populateClauseTreeNode(BasicGraphPattern basicGraphPattern, Set<String> set) {
        this.bgp = basicGraphPattern;
        this.varset = new HashMap<String, String>();
        this.extractVariables();
        this.rdfTermSet = new HashMap<String, String>();
        this.extractRDFTerms();
        this.updateNewBindings(set);
    }

    private void extractVariables() {
        boolean bl = false;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            int n = 0;
            for (TriplesBlock.Element element : new TriplesBlock.Element[]{triplesBlock.getSubject(), triplesBlock.getPredicate(), triplesBlock.getObject()}) {
                String string = element.getName();
                if (element.isVariable() && !this.varset.containsKey(string)) {
                    this.varset.put(string, this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string).append((String)",").append((int)n).toString()).position);
                }
                ++n;
            }
        }
    }

    private void extractRDFTerms() {
        for (String string : this.bgp.BGPelements.keySet()) {
            if (this.bgp.BGPelements.get((Object)string).type.equalsIgnoreCase("0")) continue;
            this.rdfTermSet.put(string.split(",")[0], this.bgp.BGPelements.get((Object)string).position);
        }
    }

    private void updateNewBindings(Set<String> set) {
        for (String string : this.varset.keySet()) {
            if (set.contains(string)) continue;
            this.newBindings.add(string);
        }
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setParent(ClauseTreeNode clauseTreeNode) {
        this.parent = clauseTreeNode;
    }

    public ClauseTreeNode getParent() {
        return this.parent;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String toString() {
        String string = "null";
        if (this.parent != null) {
            string = this.parent.label;
        }
        int n = 0;
        if (this.children != null) {
            n = this.children.size();
        }
        return "Label [" + this.label + "], Type [" + this.type + "], Parent [" + string + "], Num Children [" + n + "]";
    }

    public String debugToString(String string) {
        String string2 = "";
        string2 = string2 + string + this.toString() + "\n";
        string2 = this.bgp != null ? string2 + string + "BGP: " + this.bgp.toString() + "\n" : string2 + string + "BGP is NULL\n";
        string2 = string2 + string + "New Bindings:\n" + string;
        for (String object : this.newBindings) {
            string2 = string2 + " " + object;
        }
        string2 = string2 + "\n";
        string2 = string2 + string + "Vars:\n" + string;
        for (String string3 : this.varset.keySet()) {
            string2 = string2 + " " + string3;
        }
        string2 = string2 + "\n";
        string2 = string2 + string + "Filter Join Vars:\n" + string;
        for (String string4 : this.filterJoinVars) {
            string2 = string2 + " " + string4;
        }
        string2 = string2 + "\n";
        string2 = string2 + string + "Filters:\n" + string;
        for (Filter filter : this.filters) {
            string2 = string2 + filter.toString() + "\n";
        }
        return string2;
    }

    public void copyAll(ClauseTreeNode clauseTreeNode) {
        this.label = clauseTreeNode.label;
        this.type = clauseTreeNode.type;
        this.bgp = clauseTreeNode.bgp;
        this.children = clauseTreeNode.children;
        this.children_left = clauseTreeNode.children_left;
        this.edgeTable = clauseTreeNode.edgeTable;
        this.varset = clauseTreeNode.varset;
        this.rdfTermSet = clauseTreeNode.rdfTermSet;
    }

    public boolean equals(Object object) {
        ClauseTreeNode clauseTreeNode;
        boolean bl = false;
        if (object instanceof ClauseTreeNode && this.id == (clauseTreeNode = (ClauseTreeNode)object).getId() && this.label.equals(clauseTreeNode.label) && this.type.equals(clauseTreeNode.type) && (this.bgp != null && this.bgp.equals(clauseTreeNode.bgp) || this.bgp == null && clauseTreeNode.bgp == null) && this.children.equals(clauseTreeNode.children)) {
            bl = true;
        }
        return bl;
    }

    public void popHint0leadPosMap(SQLGenContext sQLGenContext, String string) {
        this.hint0leadPosMap = new HashMap<String, Integer>();
        if (string != null) {
            int n;
            int n2;
            String string2 = string.toUpperCase();
            String string3 = "";
            int n3 = string2.toUpperCase().indexOf("HINT0");
            if (n3 < 0) {
                return;
            }
            string3 = string2.substring(n3 + "HINT0".length(), string2.length()).trim();
            if (string3.equals("") || string3.charAt(0) != '=') {
                return;
            }
            if ((string3 = string3.substring(1, string3.length()).trim()).equals("") || string3.charAt(0) != '{') {
                return;
            }
            int n4 = string3.indexOf("}");
            if (n4 < 0) {
                return;
            }
            string3 = "{ " + string3.substring(1, n4) + " }";
            String string4 = "";
            int n5 = 0;
            int n6 = string3.indexOf("LEADING");
            if (n6 > 0 && (n2 = string3.indexOf("(", n6)) < (n = string3.indexOf(")", n6))) {
                string4 = string3.substring(n2 + 1, n).trim();
            }
            if (string4.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                String string5 = "";
                String string6 = "";
                String string7 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken().trim();
                    if (string5.startsWith("T")) {
                        this.hint0leadPosMap.put(string5, ++n5);
                        continue;
                    }
                    if (!string5.startsWith("?") && !string5.startsWith("$") || (string7 = sQLGenContext.varMap.getProjectionByName((string6 = string5.substring(1)).toUpperCase())) == null) continue;
                    this.hint0leadPosMap.put(string7, ++n5);
                }
            }
        }
    }

    public List<String> extractIncomingEdges(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getObject().isVariable() && triplesBlock.getObject().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    public String extractFirstIncomingEdge(String string) {
        List<String> list = this.extractIncomingEdges(string);
        int n = -1;
        String string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string3 : list) {
                Integer n2 = this.hint0leadPosMap.get(string3.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string2 = string3;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string2 = string3;
            }
        }
        return string2;
    }

    public List<String> extractOutgoingEdges(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getSubject().isVariable() && triplesBlock.getSubject().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    public String extractFirstOutgoingEdge(String string) {
        List<String> list = this.extractOutgoingEdges(string);
        int n = -1;
        String string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string3 : list) {
                Integer n2 = this.hint0leadPosMap.get(string3.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string2 = string3;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string2 = string3;
            }
        }
        return string2;
    }

    public String extractFirstTableAlias(String string) {
        List<String> list = this.extractAllTableAliases(string);
        int n = -1;
        String string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string3 : list) {
                Integer n2 = this.hint0leadPosMap.get(string3.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string2 = string3;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string2 = string3;
            }
        }
        return string2;
    }

    public List<String> extractAllTableAliases(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getPredicate().isVariable() && triplesBlock.getPredicate().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    public String bgpToSQL(boolean bl, List<String> list, SQLGenContext sQLGenContext, int[] nArray, String string, boolean bl2, boolean bl3, String string2, String string3, boolean bl4, Map<String, String> map, Map<String, String> map2, boolean bl5, int n) throws RDFException {
        String string4 = new String();
        this.variablesToBeJoined = new HashSet();
        HashMap hashMap = new HashMap();
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (bl && !list.isEmpty()) {
            string5 = this.constructOptimizedSelect(this.varset, list, sQLGenContext, nArray, this.getFilterJoinVars(), bl5, n);
            if (bl4) {
                this.popHint0leadPosMap(sQLGenContext, string3);
            }
            string6 = this.constructOptimizedFrom(list, string, sQLGenContext, bl2, string2);
            string7 = this.constructOptimizedWhere(list, sQLGenContext, bl3);
        } else {
            string6 = this.constructFrom(string, sQLGenContext, bl2, string2);
            string5 = this.constructSelect(this.varset, list, sQLGenContext, bl5, n);
            string7 = this.constructWhere(list, sQLGenContext);
        }
        for (Filter filter : this.getLocalFilters()) {
            filter.setSQLGenCtx(sQLGenContext);
            string7 = ClauseTreeNode.appendToList(string7, filter.toSQL(map, map2, sQLGenContext.funcHandMap), " AND\n", "");
        }
        string4 = "SELECT " + string5 + "\nFROM " + string6 + "\nWHERE " + string7;
        return string4;
    }

    private String constructOptimizedFrom(List<String> list, String string, SQLGenContext sQLGenContext, boolean bl, String string2) {
        String string3 = new String("");
        string3 = ClauseTreeNode.appendToList(string3, this.constructFrom(string, sQLGenContext, bl, string2), ", ", "");
        for (String string4 : list) {
            if (!this.needsJoin(string4)) continue;
            String string5 = this.varset.get(string4);
            string5 = string5.equalsIgnoreCase("Subject") ? "0" : (string5.equalsIgnoreCase("Predicate") ? "1" : "2");
            string3 = ClauseTreeNode.appendToList(string3, "MDSYS.RDF_VALUE$ V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string4).append((String)",").append((String)string5).toString()).uniqueId, ", ", "");
        }
        return string3;
    }

    private String constructOptimizedSelect(Map<String, String> map, List<String> list, SQLGenContext sQLGenContext, int[] nArray, Set<String> set, boolean bl, int n) {
        Object object2;
        String string = new String("");
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        boolean bl2 = false;
        boolean bl3 = false;
        for (Object object2 : sQLGenContext.varMap.indexedNames) {
            if (list.contains(object2)) {
                boolean bl4 = false;
                bl2 = set.contains(object2);
                bl3 = true;
                String string2 = map.get(object2);
                string2 = string2.equalsIgnoreCase("Subject") ? "0" : (string2.equalsIgnoreCase("Predicate") ? "1" : "2");
                String string3 = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)object2).append((String)",").append((String)string2).toString()).uniqueId;
                String string4 = " (CASE WHEN " + string3 + ".VALUE_TYPE IS NULL THEN NULL WHEN " + string3 + ".VALUE_TYPE = 'UR' THEN '" + "URI" + "'\n WHEN " + string3 + ".VALUE_TYPE = 'BN' THEN '" + "BLN" + "'\n ELSE '" + "LIT" + "'\nEND) ";
                if (QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3)) {
                    string = ClauseTreeNode.appendToList(string, string3 + ".VALUE_NAME AS " + (String)object2, ", ", "");
                    bl4 = true;
                } else {
                    string = string + "";
                }
                QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3);
                string = ClauseTreeNode.appendToList(string, this.optimizedPartSelect((String)object2), ", ", "");
                if (QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3)) {
                    string = ClauseTreeNode.appendToList(string, string3 + ".VNAME_PREFIX AS " + (String)object2 + "$_PREFIX", ", ", "");
                    bl4 = true;
                } else {
                    string = string + "";
                }
                if (QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3)) {
                    string = ClauseTreeNode.appendToList(string, string3 + ".VNAME_SUFFIX AS " + (String)object2 + "$_SUFFIX", ", ", "");
                    bl4 = true;
                } else {
                    string = string + "";
                }
                if (QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3)) {
                    string = ClauseTreeNode.appendToList(string, string4 + " AS " + (String)object2 + "$RDFVTYP", ", ", "");
                    bl4 = true;
                } else {
                    string = string + "";
                }
                if (bl3 || bl2) {
                    QueryUtils.selectNeeded(bl3, false, true, nArray, nArray2, nArray3);
                    if (QueryUtils.selectNeeded(bl3, bl2, true, nArray, nArray2, nArray3)) {
                        string = ClauseTreeNode.appendToList(string, string3 + ".LITERAL_TYPE AS " + (String)object2 + "$RDFLTYP", ", ", "");
                        bl4 = true;
                    } else {
                        string = string + "";
                    }
                    if (QueryUtils.selectNeeded(bl3, bl2, true, nArray, nArray2, nArray3)) {
                        string = ClauseTreeNode.appendToList(string, string3 + ".LANGUAGE_TYPE AS " + (String)object2 + "$RDFLANG", ", ", "");
                        bl4 = true;
                    } else {
                        string = string + "";
                    }
                }
                if (!bl4) continue;
                string = string + "\n";
                this.variablesToBeJoined.add((String)object2);
                sQLGenContext.varMap.addProjection((String)object2, string3);
                continue;
            }
            nArray3[0] = nArray3[0] + 8;
            nArray2[0] = this.incrementJ(nArray2[0], nArray3[0], nArray);
        }
        HashMap hashMap = new HashMap();
        for (String string5 : map.keySet()) {
            if (list.contains(string5)) continue;
            hashMap.put(string5, map.get(string5));
        }
        object2 = this.constructSelect(hashMap, list, sQLGenContext, bl, n);
        if (!((String)object2).equalsIgnoreCase("")) {
            string = ClauseTreeNode.appendToList(string, (String)object2, ", ", "");
        }
        return string;
    }

    private int incrementJ(int n, int n2, int[] nArray) {
        int n3 = n;
        int n4 = n2 - 8;
        for (int i = n2 - 8; i < n2 && n3 < nArray.length; ++i) {
            if (nArray[n3] != i) continue;
            ++n3;
        }
        return n3;
    }

    private String optimizedPartSelect(String string) {
        String string2;
        String string3 = new String("");
        if (this.varset.get(string).equalsIgnoreCase("Subject")) {
            string2 = this.extractFirstOutgoingEdge(string);
            string3 = ClauseTreeNode.appendToList(string3, string2 + "." + "START_NODE_ID" + " AS " + string + "$RDFVID", ", ", "");
        }
        if (this.varset.get(string).equalsIgnoreCase("Object")) {
            string2 = this.extractFirstIncomingEdge(string);
            string3 = ClauseTreeNode.appendToList(string3, string2 + "." + "CANON_END_NODE_ID" + "  AS " + string + "$RDFVID", ", ", "");
        }
        if (this.varset.get(string).equalsIgnoreCase("Predicate")) {
            string2 = this.extractFirstTableAlias(string);
            string3 = ClauseTreeNode.appendToList(string3, string2 + "." + "P_VALUE_ID" + " AS " + string + "$RDFVID", ", ", "");
        }
        return string3;
    }

    private String constructOptimizedWhere(List<String> list, SQLGenContext sQLGenContext, boolean bl) {
        String string = new String("");
        for (String string2 : list) {
            String string3;
            if (!this.needsJoin(string2)) continue;
            if (this.varset.get(string2).equalsIgnoreCase("Subject")) {
                string3 = this.extractFirstOutgoingEdge(string2);
                string = ClauseTreeNode.appendToList(string, "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string2).append((String)",0").toString()).uniqueId + ".VALUE_ID = " + string3 + "." + "START_NODE_ID", " AND\n", "");
            }
            if (this.varset.get(string2).equalsIgnoreCase("Object")) {
                string3 = this.extractFirstIncomingEdge(string2);
                string = bl ? ClauseTreeNode.appendToList(string, "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string2).append((String)",2").toString()).uniqueId + ".VALUE_ID = " + string3 + "." + "END_NODE_ID", " AND\n", "") : ClauseTreeNode.appendToList(string, "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string2).append((String)",2").toString()).uniqueId + ".VALUE_ID = " + string3 + "." + "CANON_END_NODE_ID", " AND\n", "");
            }
            if (!this.varset.get(string2).equalsIgnoreCase("Predicate")) continue;
            string3 = this.extractFirstTableAlias(string2);
            string = ClauseTreeNode.appendToList(string, "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string2).append((String)",1").toString()).uniqueId + ".VALUE_ID = " + string3 + "." + "P_VALUE_ID", " AND\n", "");
        }
        String string4 = this.constructWhere(list, sQLGenContext);
        if (!string4.equalsIgnoreCase("")) {
            string = ClauseTreeNode.appendToList(string, string4, " AND\n", "");
        }
        return string;
    }

    private boolean needsJoin(String string) {
        return this.variablesToBeJoined.contains(string);
    }

    public String constructFrom(String string, SQLGenContext sQLGenContext, boolean bl, String string2) {
        String string3 = new String("");
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (string != null) {
                string3 = ClauseTreeNode.appendToList(string3, string + " T" + n++, ", ", "");
                continue;
            }
            if (bl) {
                string3 = ClauseTreeNode.appendToList(string3, string2 + " T" + n++, ", ", "");
                continue;
            }
            string3 = ClauseTreeNode.appendToList(string3, "BASIC_TRIPLES T" + n++, ", ", "");
        }
        if (string3.length() == 0) {
            string3 = "DUAL";
        }
        sQLGenContext.nTriples = n;
        return string3;
    }

    public String constructSelect(Map<String, String> map, List<String> list, SQLGenContext sQLGenContext, boolean bl, int n) {
        String string = "";
        string = ClauseTreeNode.appendToList(string, "1 AS " + this.getDummyVarName(), ", ", "");
        for (String string2 : map.keySet()) {
            if (string2.equalsIgnoreCase("Dummy")) continue;
            if (map.get(string2).equalsIgnoreCase("Subject")) {
                string = ClauseTreeNode.appendToList(string, this.extractFirstOutgoingEdge(string2) + "." + "START_NODE_ID" + " AS " + string2 + "$RDFVID", ",\n", "");
                continue;
            }
            if (map.get(string2).equalsIgnoreCase("Predicate")) {
                string = ClauseTreeNode.appendToList(string, this.extractFirstTableAlias(string2) + "." + "P_VALUE_ID" + " AS " + string2 + "$RDFVID", ",\n", "");
                continue;
            }
            string = ClauseTreeNode.appendToList(string, this.extractFirstIncomingEdge(string2) + "." + "CANON_END_NODE_ID" + " AS " + string2 + "$RDFVID", ",\n", "");
        }
        if ((sQLGenContext.contextFlags & 1) > 0) {
            string = this.bgp.TBList.size() > 0 ? ClauseTreeNode.appendToList(string, " T0.CTXT2 as T0_CTXT2 ", ",\n", "") : ClauseTreeNode.appendToList(string, " NULL as T0_CTXT2 ", ",\n", "");
        } else if ((sQLGenContext.contextFlags & 2) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.bgp.TBList.size() > 1) {
                stringBuffer.append(" COALESCE(T0.CTXT2");
                for (int i = 1; i < this.bgp.TBList.size(); ++i) {
                    stringBuffer.append(", T" + i + ".CTXT2");
                }
                stringBuffer.append(") ");
            } else if (this.bgp.TBList.size() == 1) {
                stringBuffer.append(" T0.CTXT2 ");
            } else {
                stringBuffer.append(" NULL ");
            }
            string = ClauseTreeNode.appendToList(string, stringBuffer.toString() + " as T0_CTXT2 ", ",\n", "");
        }
        if (bl) {
            string = ClauseTreeNode.appendToList(string, "'" + n + "' as " + "RDF$L" + " ", ",\n", "");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String constructWhere(List<String> list, SQLGenContext sQLGenContext) {
        Object object;
        Iterator<String> iterator;
        Object object2;
        Object object3;
        String string = new String("");
        int n = 0;
        for (TriplesBlock object4 : this.bgp.TBList) {
            object3 = object4.getSubject();
            object2 = object4.getPredicate();
            iterator = object4.getObject();
            if (!((TriplesBlock.Element)object3).isVariable()) {
                string = ((TriplesBlock.Element)object3).exists() ? ClauseTreeNode.appendToList(string, "T" + n + "." + "START_NODE_ID" + " = " + ((TriplesBlock.Element)object3).getCanonicalID().toString(), " AND\n", "") : ClauseTreeNode.appendToList(string, "T" + n + "." + "START_NODE_ID" + " IN (SELECT NULL FROM mdsys.rdf_namespace$ where rownum < 1)", " AND\n", "");
            }
            if (!((TriplesBlock.Element)object2).isVariable()) {
                string = ((TriplesBlock.Element)object2).exists() ? ClauseTreeNode.appendToList(string, "T" + n + "." + "P_VALUE_ID" + " = " + ((TriplesBlock.Element)object2).getCanonicalID().toString(), " AND\n", "") : ClauseTreeNode.appendToList(string, "T" + n + "." + "P_VALUE_ID" + " IN (SELECT NULL FROM mdsys.rdf_namespace$ where rownum < 1)", " AND\n", "");
            }
            if (!((TriplesBlock.Element)((Object)iterator)).isVariable()) {
                object = ((TriplesBlock.Element)((Object)iterator)).getCanonicalID();
                String string2 = "";
                if (object != null) {
                    string2 = ((Long)object).toString();
                }
                if (((TriplesBlock.Element)((Object)iterator)).isSysCtxFunction()) {
                    string2 = ((TriplesBlock.Element)((Object)iterator)).getName();
                }
                string = ((TriplesBlock.Element)((Object)iterator)).exists() ? ClauseTreeNode.appendToList(string, "T" + n + "." + "CANON_END_NODE_ID" + " = " + string2, " AND\n", "") : ClauseTreeNode.appendToList(string, "T" + n + "." + "CANON_END_NODE_ID" + " IN (SELECT NULL FROM mdsys.rdf_namespace$ where rownum < 1)", " AND\n", "");
            }
            ++n;
        }
        for (String string3 : this.varset.keySet()) {
            if (this.bgp.BGPelements.containsKey(string3 + ",2") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string3).append((String)",2").toString()).position.equalsIgnoreCase("Object") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string3).append((String)",2").toString()).in_degree > 1) {
                object3 = this.extractIncomingEdges(string3);
                object2 = this.extractFirstIncomingEdge(string3);
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (((String)object).equals(object2)) continue;
                    string = ClauseTreeNode.appendToList(string, (String)object2 + "." + "CANON_END_NODE_ID" + " = " + (String)object + "." + "CANON_END_NODE_ID", " AND\n", "");
                }
            }
            if (this.bgp.BGPelements.containsKey(string3 + ",0") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string3).append((String)",0").toString()).position.equalsIgnoreCase("Subject") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string3).append((String)",0").toString()).out_degree > 1) {
                object3 = this.extractOutgoingEdges(string3);
                object2 = this.extractFirstOutgoingEdge(string3);
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (((String)object).equals(object2)) continue;
                    string = ClauseTreeNode.appendToList(string, (String)object2 + "." + "START_NODE_ID" + " = " + (String)object + "." + "START_NODE_ID", " AND\n", "");
                }
            }
            if (!this.bgp.BGPelements.containsKey(string3 + ",2") || !this.bgp.BGPelements.containsKey(string3 + ",0") || this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string3).append((String)",2").toString()).in_degree <= 0 || this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string3).append((String)",0").toString()).out_degree <= 0) continue;
            object3 = this.extractFirstIncomingEdge(string3);
            object2 = this.extractFirstOutgoingEdge(string3);
            string = ClauseTreeNode.appendToList(string, (String)object3 + "." + "CANON_END_NODE_ID" + " = " + (String)object2 + "." + "START_NODE_ID", " AND\n", "");
        }
        for (String string4 : this.varset.keySet()) {
            if (this.varset.get(string4).equalsIgnoreCase("Predicate") && this.bgp.BGPelements.containsKey(string4 + ",1") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string4).append((String)",1").toString()).occurences > 1) {
                object3 = this.extractAllTableAliases(string4);
                object2 = this.extractFirstTableAlias(string4);
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (((String)object).equalsIgnoreCase((String)object2)) continue;
                    string = ClauseTreeNode.appendToList(string, (String)object2 + "." + "P_VALUE_ID" + " = " + (String)object + "." + "P_VALUE_ID", " AND\n", "");
                }
            }
            if (this.bgp.BGPelements.containsKey(string4 + ",1") && this.bgp.BGPelements.containsKey(string4 + ",0")) {
                object3 = this.extractFirstOutgoingEdge(string4);
                object2 = this.extractFirstTableAlias(string4);
                string = ClauseTreeNode.appendToList(string, (String)object2 + "." + "P_VALUE_ID" + " = " + object3 + "." + "START_NODE_ID", " AND\n", "");
            }
            if (!this.bgp.BGPelements.containsKey(string4 + ",1") || !this.bgp.BGPelements.containsKey(string4 + ",2")) continue;
            object3 = this.extractFirstIncomingEdge(string4);
            object2 = this.extractFirstTableAlias(string4);
            string = ClauseTreeNode.appendToList(string, (String)object2 + "." + "P_VALUE_ID" + " = " + object3 + "." + "CANON_END_NODE_ID", " AND\n", "");
        }
        if ((sQLGenContext.contextFlags & 1) > 0 && this.bgp.TBList.size() > 1) {
            for (int i = 1; i < this.bgp.TBList.size(); ++i) {
                string = ClauseTreeNode.appendToList(string, "T0.CTXT2 = T" + i + ".CTXT2 ", " AND\n", "");
            }
        } else if ((sQLGenContext.contextFlags & 2) > 0 && this.bgp.TBList.size() > 1) {
            void var6_15;
            void var6_13;
            StringBuffer stringBuffer = new StringBuffer(" COALESCE(");
            boolean bl = false;
            while (var6_13 < this.bgp.TBList.size()) {
                stringBuffer.append("T" + (int)var6_13 + ".CTXT2,");
                ++var6_13;
            }
            stringBuffer.append("'RDFCTX$NULLCTX')");
            boolean bl2 = true;
            while (var6_15 < this.bgp.TBList.size()) {
                string = ClauseTreeNode.appendToList(string, stringBuffer.toString() + " = NVL(T" + (int)var6_15 + ".CTXT2, " + stringBuffer.toString() + ") ", " AND\n", "");
                ++var6_15;
            }
        }
        if (string.equalsIgnoreCase("")) {
            string = "(1=1)";
        }
        return string;
    }

    public HashMap<String, String> getParentVariables() {
        return (HashMap)this.parent.varset;
    }

    public Set<String> getNewBindings() {
        return this.newBindings;
    }

    public void setFilterDepVars(Set<String> set) {
        for (Filter filter : this.filters) {
            filter.setDepVars(set);
        }
    }

    public void setBGP(BasicGraphPattern basicGraphPattern) {
        this.bgp = basicGraphPattern;
    }

    public int getId() {
        return this.id;
    }
}

