/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.HashMap;
import java.util.Map;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class BlankNodesRewriteOptimizer
implements SparqlQueryOptimizer {
    private Map blankNodesMap = new HashMap();
    protected boolean hasBNode;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        if (((SimpleNode)node).id == 73) {
            if (((ASTTripleAtom)node).type == 11) {
                this.hasBNode = true;
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)node;
                if (OptimizerUtils.hasAncestorType(node, 52)) {
                    throw new RDFException("Use of blank nodes inside SERVICE is not allowed");
                }
                if (OptimizerUtils.hasAncestorType(node, 35)) {
                    throw new RDFException("Use of blank nodes inside DELETE DATA is not allowed");
                }
                if (OptimizerUtils.hasAncestorType(node, 36)) {
                    throw new RDFException("Use of blank nodes inside DELETE WHERE is not allowed");
                }
                this.blankNodeToVar(aSTTripleAtom);
            }
        } else {
            int n = ((SimpleNode)node).jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                if (((SimpleNode)node.jjtGetChild((int)i)).id == 34) continue;
                this.optimizeQuery((SimpleNode)node.jjtGetChild(i));
            }
        }
        return node;
    }

    protected void blankNodeToVar(ASTTripleAtom aSTTripleAtom) {
        aSTTripleAtom.type = 0;
        if (this.blankNodesMap.containsKey(aSTTripleAtom.name)) {
            aSTTripleAtom.name = (String)this.blankNodesMap.get(aSTTripleAtom.name);
        } else {
            String string = "B$" + (this.getBlankNodesNumber() + 1);
            this.blankNodesMap.put(aSTTripleAtom.name, string);
            aSTTripleAtom.name = string;
        }
    }

    public int getBlankNodesNumber() {
        return this.blankNodesMap.size();
    }
}

