/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;

public final class Platform {
    private Platform() {
    }

    public static URL resolve(URL url) throws IOException {
        URL rURL = FileLocator.resolve((URL)url);
        try {
            rURL.toURI();
        }
        catch (URISyntaxException e) {
            StringBuilder sbProt = new StringBuilder();
            while (rURL.getPath().charAt(0) != '/') {
                sbProt.append(rURL.getProtocol());
                sbProt.append(":");
                rURL = new URL(rURL.getPath());
            }
            sbProt.append(rURL.getProtocol());
            try {
                URI u = new URI(sbProt.toString(), rURL.getUserInfo(), rURL.getHost(), rURL.getPort(), rURL.getPath(), rURL.getQuery(), null);
                rURL = u.toURL();
            }
            catch (URISyntaxException e2) {
                throw new IOException(e2.getMessage());
            }
        }
        return rURL;
    }
}

