/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.xdiffer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.CMDomHash;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.CMXMLDiff;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.DiffTreeNode;
import oracle.xml.async.DOMBuilder;
import oracle.xml.async.DOMBuilderErrorEvent;
import oracle.xml.async.DOMBuilderErrorListener;
import oracle.xml.async.DOMBuilderEvent;
import oracle.xml.async.DOMBuilderListener;
import oracle.xml.async.ResourceManager;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.apache.log4j.Category;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CMDiff
implements DOMBuilderListener,
DOMBuilderErrorListener,
Serializable {
    private static Category s_log = Category.getInstance(CMDiff.class);
    private Node m_doc1 = null;
    private Node m_doc2 = null;
    private CMXMLDiff m_xmldiff;
    private DOMBuilder m_dom1;
    private DOMBuilder m_dom2;
    private ResourceManager m_rm;
    private static final int ONE = 1;
    private static final int TWO = 2;
    CMDomHash m_dh = new CMDomHash();
    private DOMParser m_domparser = null;
    private boolean m_delWSdeletes = false;
    private String m_ddl1 = null;
    private String m_ddl2 = null;
    private Vector m_commentsDdl1 = null;
    private Vector m_commentsDdl2 = null;
    private String m_grantDiffsXML = null;
    private String m_commentDiffsXML = null;
    private boolean m_logicalCompare = false;
    private boolean m_ignoreHighValues = false;
    private boolean m_ignoreAllPartitioning = false;
    private boolean m_countStats = false;
    private HashMap<String, String> m_schemaMap;
    private static final String s_xmldecl = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String s_cmdiffMetaS = "<CMDIFFS VER=\"1.0\">";
    private static final String s_cmdiffMetaE = "</CMDIFFS>";
    private boolean m_usingSXML = false;

    public CMDiff() {
    }

    public CMDiff(boolean logicalCompare) {
        this.m_logicalCompare = logicalCompare;
    }

    public CMDiff(boolean logicalCompare, boolean ignoreHighValues) {
        this.m_logicalCompare = logicalCompare;
        this.m_ignoreHighValues = ignoreHighValues;
    }

    public CMDiff(boolean logicalCompare, boolean ignoreHighValues, boolean ignoreAllPartitioning) {
        this.m_logicalCompare = logicalCompare;
        this.m_ignoreHighValues = ignoreHighValues;
        this.m_ignoreAllPartitioning = ignoreAllPartitioning;
    }

    public void init() {
        this.m_doc1 = null;
        this.m_doc2 = null;
        this.m_ddl1 = null;
        this.m_ddl2 = null;
        this.m_commentsDdl1 = null;
        this.m_commentsDdl2 = null;
        this.m_xmldiff = null;
        this.m_grantDiffsXML = null;
        this.m_commentDiffsXML = null;
    }

    public void setDocuments(Node doc1, Node doc2) {
        this.m_doc1 = doc1;
        this.m_doc2 = doc2;
    }

    public void setDDLs(String ddl1, String ddl2) {
        this.m_ddl1 = ddl1;
        this.m_ddl2 = ddl2;
    }

    public void addLeftCommentDdl(String theDdl) {
        if (this.m_commentsDdl1 == null) {
            this.m_commentsDdl1 = new Vector();
        }
        this.m_commentsDdl1.addElement(theDdl);
    }

    public void addRightCommentDdl(String theDdl) {
        if (this.m_commentsDdl2 == null) {
            this.m_commentsDdl2 = new Vector();
        }
        this.m_commentsDdl2.addElement(theDdl);
    }

    public void setGrantDiffsXML(String gdXML) {
        this.m_grantDiffsXML = gdXML;
    }

    public void setCommentDiffsXML(String cdXML) {
        this.m_commentDiffsXML = cdXML;
    }

    public String getCommentDiffsXML() {
        return this.m_commentDiffsXML;
    }

    private void setInputs(InputStream is1, InputStream is2, XSLProcessor processor, XSLStylesheet sst, boolean transform) throws IOException, XMLParseException, SAXException, InterruptedException, XSLException {
        this.m_rm = new ResourceManager(2);
        this.m_rm.getResource();
        this.m_dom1 = new DOMBuilder(1);
        this.m_dom1.setPreserveWhitespace(false);
        this.m_dom1.addDOMBuilderListener((DOMBuilderListener)this);
        this.m_dom1.addDOMBuilderErrorListener((DOMBuilderErrorListener)this);
        this.m_dom1.parse(is1);
        this.m_rm.getResource();
        this.m_dom2 = new DOMBuilder(2);
        this.m_dom2.setPreserveWhitespace(false);
        this.m_dom2.addDOMBuilderListener((DOMBuilderListener)this);
        this.m_dom2.addDOMBuilderErrorListener((DOMBuilderErrorListener)this);
        this.m_dom2.parse(is2);
        while (this.m_rm.activeFound()) {
            Thread.sleep(100L);
        }
        if (processor != null && sst != null && transform) {
            this.m_doc1 = processor.processXSL(sst, (XMLDocument)this.m_doc1);
            this.m_doc2 = processor.processXSL(sst, (XMLDocument)this.m_doc2);
        }
    }

    private void setInput1(InputSource inp1) throws IOException, XMLParseException, SAXException {
        this.m_doc1 = this.parseXML(inp1);
    }

    public void setInput2(InputSource inp2) throws IOException, XMLParseException, SAXException {
        this.m_doc2 = this.parseXML(inp2);
    }

    public Node getDocument1() {
        return this.m_doc1;
    }

    public String getDDL1() {
        return this.m_ddl1;
    }

    public Node getDocument2() {
        return this.m_doc2;
    }

    public String getDDL2() {
        return this.m_ddl2;
    }

    public boolean getLogicalCompare() {
        return this.m_logicalCompare;
    }

    public boolean getIgnoreHighValues() {
        return this.m_ignoreHighValues;
    }

    public boolean getIgnoreAllPartitioning() {
        return this.m_ignoreAllPartitioning;
    }

    public void setCountStatDiffs(boolean countStats) {
        this.m_countStats = countStats;
    }

    public boolean getCountStatDiffs() {
        return this.m_countStats;
    }

    public void setSchemaMap(HashMap<String, String> map) {
        this.m_schemaMap = map;
    }

    HashMap<String, String> getSchemaMap() {
        return this.m_schemaMap;
    }

    public void setUsingSxml(boolean us) {
        this.m_usingSXML = us;
    }

    public boolean getUsingSxml() {
        return this.m_usingSXML;
    }

    public DiffTreeNode getCMDiffTree(int tree) {
        if (this.m_xmldiff != null) {
            return this.m_xmldiff.getCMDiffTree(tree);
        }
        return null;
    }

    public boolean diff() throws NullPointerException {
        if (this.m_doc1 == null || this.m_doc2 == null) {
            throw new NullPointerException();
        }
        this.m_xmldiff = new CMXMLDiff(this.m_doc1, this.m_doc2, this, this.m_usingSXML);
        return this.m_xmldiff.getDiffCount() != 0;
    }

    public boolean ignoredDiffFound() {
        return this.m_xmldiff != null && this.m_xmldiff.getIgnoredDiffExists();
    }

    protected boolean equals(Node node1, Node node2) {
        return CMDomHash.hashValueEquals(this.m_dh.getDOMHash(node1), this.m_dh.getDOMHash(node2));
    }

    public void domBuilderErrorCalled(DOMBuilderErrorEvent p0) {
        int id = ((DOMBuilder)p0.getSource()).getId();
        String errString = null;
        errString = id == 1 ? new String("Error parsing XML file1:") : (id == 2 ? new String("Error parsing XML file2:") : new String("Error from DOM Builder. File not known.:"));
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)(errString + p0.getException().getMessage()));
        }
        System.exit(0);
    }

    public void domBuilderError(DOMBuilderEvent p0) {
    }

    public synchronized void domBuilderOver(DOMBuilderEvent p0) {
        DOMBuilder db = (DOMBuilder)p0.getSource();
        if (db.getId() == 1) {
            this.m_doc1 = db.getDocument();
        } else if (db.getId() == 2) {
            this.m_doc2 = db.getDocument();
        }
        this.m_rm.releaseResource();
    }

    public void domBuilderStarted(DOMBuilderEvent p0) {
    }

    public void printDiffTree(int tree, BufferedWriter out) throws IOException {
        this.m_xmldiff.getCMDiffTree(tree).printNode(out);
    }

    public void writeDiffXML(int tree, OutputStream os) throws IOException {
        os.write(s_xmldecl.getBytes("UTF-8"));
        os.write(s_cmdiffMetaS.getBytes("UTF-8"));
        this.writeCoreDiff(os, tree);
        this.writeGrantsDiff(os);
        this.writeCommentsDiff(os);
        os.write(s_cmdiffMetaE.getBytes("UTF-8"));
    }

    private XMLDocument parseXML(InputSource inp) throws IOException, XMLParseException, SAXException {
        DOMParser domParser = this.getDOMParser();
        domParser.setPreserveWhitespace(false);
        domParser.parse(inp);
        return domParser.getDocument();
    }

    private DOMParser getDOMParser() {
        if (this.m_domparser == null) {
            this.m_domparser = new DOMParser();
        } else {
            this.m_domparser.reset();
        }
        return this.m_domparser;
    }

    private void writeCoreDiff(OutputStream os, int tree) throws IOException {
        if (this.m_xmldiff != null && this.m_xmldiff.getCMDiffTree(tree) != null) {
            this.m_ddl1 = this.appendCommentsDDL(this.m_ddl1, this.m_commentsDdl1);
            this.m_ddl2 = this.appendCommentsDDL(this.m_ddl2, this.m_commentsDdl2);
            this.m_xmldiff.getCMDiffTree(tree).writeXMLNode(os, this.m_ddl1, this.m_ddl2);
        }
    }

    private String appendCommentsDDL(String theDDL, Vector theComments) {
        if (theDDL != null && theComments != null) {
            StringBuffer sb = new StringBuffer(theDDL);
            for (int i = 0; i < theComments.size(); ++i) {
                sb.append((String)theComments.elementAt(i)).append('\n');
            }
            return new String(sb);
        }
        return theDDL;
    }

    private void writeGrantsDiff(OutputStream os) throws IOException {
        if (this.m_grantDiffsXML != null && !(this.m_grantDiffsXML = this.m_grantDiffsXML.trim()).equals("")) {
            os.write(this.m_grantDiffsXML.getBytes("UTF-8"));
        }
    }

    private void writeCommentsDiff(OutputStream os) throws IOException {
        if (this.m_commentDiffsXML != null && !(this.m_commentDiffsXML = this.m_commentDiffsXML.trim()).equals("")) {
            os.write(this.m_commentDiffsXML.getBytes("UTF-8"));
        }
    }
}

