/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.util.Vector;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTSDatafileAccessor;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.NodeList;

public class XMLTablespaceAccessor
extends XMLAccessor {
    private static String TABLESPACE = "TABLESPACE";
    private Vector m_datafiles = null;
    private static final int EXT_MGMT_UNSPECIFIED = 0;
    public static final int EXT_MGMT_AUTOALLOCATE = 1;
    public static final int EXT_MGMT_UNIFORM = 2;
    private static final int SEG_MGMT_UNSPECIFIED = 0;
    public static final int SEG_MGMT_MANUAL = 1;
    public static final int SEG_MGMT_AUTO = 2;
    public static String X_DATAFILE_LIST_ITEM = "/sxml:" + TABLESPACE + "/sxml:" + "DATAFILE_LIST" + "/sxml:" + "DATAFILE_LIST_ITEM";
    private static String X_TYPE = "sxml:TYPE";
    private static String X_EXTENT_MANAGEMENT_TYPE = "sxml:EXTENT_MANAGEMENT/sxml:TYPE";
    private static String X_ALLOCATION_TYPE = "sxml:EXTENT_MANAGEMENT/sxml:ALLOCATION_TYPE";
    private static String X_ALLOCATION_SIZE = "sxml:EXTENT_MANAGEMENT/sxml:SIZE";
    private static String X_BLOCKSIZE = "sxml:BLOCKSIZE";
    private static String X_OFFLINE = "sxml:OFFLINE";
    private static String X_LOGGING = "sxml:LOGGING";
    private static String X_SEGMENT_SPACE_MANAGEMENT = "sxml:SEGMENT_SPACE_MANAGEMENT";
    private static String X_STORAGE = "sxml:DEFAULT/sxml:STORAGE";
    private static String X_INITIAL_SIZE = X_STORAGE + "/sxml:" + "INITIAL";
    private static String X_NEXT_SIZE = X_STORAGE + "/sxml:" + "NEXT";
    private static String X_MINIMUM_EXTENT = X_STORAGE + "/sxml:" + "MINEXTENTS";
    private static String X_MAXIMUM_EXTENT = X_STORAGE + "/sxml:" + "MAXEXTENTS";
    private static String X_PCT_INCREASE = X_STORAGE + "/sxml:" + "PCTINCREASE";

    protected XMLTablespaceAccessor() {
    }

    protected XMLTablespaceAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    @Override
    public void initializeAll() throws XMLAccessorException {
        this.initializeDatafiles();
    }

    public void initializeDatafiles() throws XMLAccessorException {
        this.m_datafiles = new Vector();
        NodeList dFiles = this.selectNodes(X_DATAFILE_LIST_ITEM);
        int len = 0;
        if (dFiles != null && (len = dFiles.getLength()) > 0) {
            for (int i = 0; i < len; ++i) {
                XMLNode dfNode = (XMLNode)dFiles.item(i);
                XMLAccessor accessor = XMLTablespaceAccessor.getXMLAccessorForType(104, dfNode, this.getAccessorClient());
                this.m_datafiles.add(accessor);
            }
        }
    }

    public String getStatus() {
        return this.nodeExists(X_OFFLINE) ? "OFFLINE" : "ONLINE";
    }

    public String getBlockSize() {
        return this.selectTextValue(X_BLOCKSIZE);
    }

    public String getType() {
        return this.selectTextValue(X_TYPE);
    }

    public String getAllocationType() {
        return this.selectTextValue(X_ALLOCATION_TYPE);
    }

    public String getAllocationSize() {
        return this.selectTextValue(X_ALLOCATION_SIZE);
    }

    public String getExtentManagement() {
        return this.selectTextValue(X_EXTENT_MANAGEMENT_TYPE);
    }

    public String getLogging() {
        return this.selectTextValue(X_LOGGING);
    }

    public String getSegmentSpaceManagement() {
        return this.selectTextValue(X_SEGMENT_SPACE_MANAGEMENT);
    }

    public String getInitialSize() {
        return this.selectTextValue(X_INITIAL_SIZE);
    }

    public String getNextSize() {
        return this.selectTextValue(X_NEXT_SIZE);
    }

    public String getMinimumExtent() {
        return this.selectTextValue(X_MINIMUM_EXTENT);
    }

    public String getMaximumExtent() {
        return this.selectTextValue(X_MAXIMUM_EXTENT);
    }

    public String getPctIncrease() {
        return this.selectTextValue(X_PCT_INCREASE);
    }

    @Override
    public String getTypePathElement() {
        return TABLESPACE;
    }

    public void setLocal(boolean isLocal) {
        String mgmtType = isLocal ? "LOCAL" : "DICTIONARY";
        this.setTextValue(X_EXTENT_MANAGEMENT_TYPE, mgmtType);
        if (isLocal) {
            XMLTablespaceAccessor.removeNode(this.getXmlNode(), X_STORAGE, 1);
        }
    }

    public void setAllocationType(int allocType) {
        switch (allocType) {
            case 1: {
                this.setTextValue(X_ALLOCATION_TYPE, "AUTOALLOCATE");
                break;
            }
            case 2: {
                this.setTextValue(X_ALLOCATION_TYPE, "UNIFORM");
            }
        }
    }

    public void setUniformExtentSize(int size, int unit) {
        String extentStr = Integer.toString(XMLTablespaceAccessor.calculateExtent(size, unit));
        this.setTextValue(X_ALLOCATION_SIZE, extentStr);
    }

    public void setSegmentManagementType(int segMgmtType) {
        switch (segMgmtType) {
            case 1: {
                this.setTextValue(X_SEGMENT_SPACE_MANAGEMENT, "MANUAL");
                break;
            }
            case 2: {
                this.setTextValue(X_SEGMENT_SPACE_MANAGEMENT, "AUTO");
            }
        }
    }

    public String[] getDatafileNames() {
        String[] names = null;
        if (this.m_datafiles != null && this.m_datafiles.size() > 0) {
            names = new String[this.m_datafiles.size()];
            for (int i = 0; i < this.m_datafiles.size(); ++i) {
                XMLTSDatafileAccessor dfa = (XMLTSDatafileAccessor)this.m_datafiles.elementAt(i);
                names[i] = dfa.getFileName();
            }
        }
        return names;
    }

    public String getFullDatafileName(int index, String nameOnly) {
        XMLTSDatafileAccessor dfa = (XMLTSDatafileAccessor)this.m_datafiles.elementAt(index);
        if (dfa != null) {
            return dfa.getFilePath() + nameOnly;
        }
        return null;
    }

    public void setDatafileName(int index, String newName) {
        XMLTSDatafileAccessor dfa = (XMLTSDatafileAccessor)this.m_datafiles.elementAt(index);
        if (dfa != null) {
            dfa.setFileName(newName);
        }
    }

    @Override
    public String toString() {
        String datafiles = "None\n";
        if (this.m_datafiles != null && this.m_datafiles.size() > 0) {
            for (int i = 0; i < this.m_datafiles.size(); ++i) {
                datafiles = "\n";
                XMLTSDatafileAccessor dfa = (XMLTSDatafileAccessor)this.m_datafiles.elementAt(i);
                datafiles = datafiles + dfa.toString();
            }
        }
        return super.toString() + "  Type: " + this.getType() + "\n" + "  Status: " + this.getStatus() + "\n" + "  Block size: " + this.nin(this.getBlockSize()) + "\n" + "  Allocation type: " + this.nin(this.getAllocationType()) + "\n" + "  Allocation size: " + this.nin(this.getAllocationSize()) + "\n" + "  Extent management: " + this.nin(this.getExtentManagement()) + "\n" + "  Logging: " + this.nin(this.getLogging()) + "\n" + "  Segment space management: " + this.nin(this.getSegmentSpaceManagement()) + "\n" + "  Initial: " + this.nin(this.getInitialSize()) + "\n" + "  Next: " + this.nin(this.getNextSize()) + "\n" + "  Min extent: " + this.nin(this.getMinimumExtent()) + "\n" + "  Max extent: " + this.nin(this.getMaximumExtent()) + "\n" + "  Pct increase: " + this.nin(this.getPctIncrease()) + "\n" + "  Datafiles:" + datafiles;
    }
}

