/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.xml.parser.v2.XMLNode;

public class XMLTSDatafileAccessor
extends XMLAccessor {
    private static String DATAFILE_LIST = "DATAFILE_LIST";
    private String m_path;
    private String m_name;
    private static String X_SIZE = "sxml:SIZE";
    private static String X_AUTOEXTEND = "sxml:AUTOEXTEND";
    private static String X_NEXT = X_AUTOEXTEND + "/sxml:" + "NEXT";
    private static String X_MAX_FILE_SIZE = X_AUTOEXTEND + "/sxml:" + "MAXSIZE";

    protected XMLTSDatafileAccessor() {
    }

    protected XMLTSDatafileAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    @Override
    public void setXmlDoc(XMLNode dfItemNode) {
        this.setXmlNode(dfItemNode);
    }

    @Override
    public void initializeAll() throws XMLAccessorException {
        this.parseFilespec(this.getName());
    }

    public String getFilePath() {
        return this.m_path;
    }

    public String getFileName() {
        return this.m_name;
    }

    public void setFileName(String newName) {
        this.m_name = newName;
        this.setTextValue(X_NAME, this.m_path + newName);
    }

    public String getSize() {
        return this.selectTextValue(X_SIZE);
    }

    public String getAutoExtend() {
        return XMLTSDatafileAccessor.YorN(this.nodeExists(X_AUTOEXTEND));
    }

    public String getIncrement() {
        return this.selectTextValue(X_NEXT);
    }

    public String getMaxFileSize() {
        return this.selectTextValue(X_MAX_FILE_SIZE);
    }

    @Override
    public String getTypePathElement() {
        return DATAFILE_LIST;
    }

    @Override
    public String toString() {
        return "   Filename: " + this.getName() + "\n" + "    Size: " + this.getSize() + "\n" + "    Autoextend: " + this.getAutoExtend() + "\n" + "     Next size: " + this.nin(this.getIncrement()) + "\n" + "     Max size: " + this.nin(this.getMaxFileSize()) + "\n" + "     Parsed filespec:\n" + "      Path: " + this.nin(this.m_path) + "\n" + "      Name: " + this.nin(this.m_name) + "\n";
    }

    private void parseFilespec(String filespec) {
        if (filespec == null) {
            this.m_name = "";
            this.m_path = "";
        } else if (filespec.charAt(0) == '+') {
            this.m_name = filespec;
            this.m_path = "";
        } else {
            String fileSeparator = filespec.length() > 0 && filespec.indexOf("/") != -1 ? "/" : "\\";
            int index = filespec.lastIndexOf(fileSeparator);
            if (index >= 0) {
                this.m_name = filespec.substring(index + 1);
                this.m_path = filespec.substring(0, index + 1);
            }
        }
    }
}

