/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.cpapi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItemInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlan;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccessException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.ApplyDiffListener;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.ApplyOneDiffResult;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXMLUtils;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.DDLUtils;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLMViewLogAccessor;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.NodeList;

public class ChangeItem
extends ChangeItemInfo {
    private ChangePlan m_plan = null;
    private XMLDocument m_definition = null;
    private XMLDocument m_origFullXML = null;
    private boolean m_wasModify = false;
    private String m_addnlInfo = null;
    private static final Integer CP_ADD_INTEGER = new Integer(1);
    private static final Integer CP_MODIFY_INTEGER = new Integer(2);
    private static final Integer CP_DROP_INTEGER = new Integer(3);
    private static final Integer CP_MONITOR_INTEGER = new Integer(4);
    protected static String s_alterItemPath = "/sxml:ALTER_XML/sxml:ALTER_LIST/sxml:ALTER_LIST_ITEM";
    protected static String s_sqlItemPath = "sxml:SQL_LIST/sxml:SQL_LIST_ITEM/sxml:TEXT";
    private static final Vector s_monitorActions = new Vector();
    private static final Vector s_addActions = new Vector();
    private static final Vector s_modifyActions = new Vector();
    private static final Vector s_dropWithDefnActions = new Vector();
    private static final Vector s_dropWithNoDefnActions = new Vector();

    public ChangeItem(int itemAction, String typeName, String objectName, String objectSchema, String description, XMLDocument origDefn, XMLDocument revisedDefn, XMLAccessorClient client) throws ChangePlanAccessException {
        super(itemAction, typeName, objectName, objectSchema, description);
        this.initDefinition(origDefn, revisedDefn, client);
        if (MATERIALIZED_VIEW_LOG.equals(typeName)) {
            this.setAdditionalInfo(objectName);
            this.setObjectName(XMLMViewLogAccessor.getMViewLogNameFromMstrTblName(objectName));
        }
    }

    ChangeItem(int itemAction, String typeName, String objectName, String objectSchema, String description, XMLDocument defn) throws ChangePlanAccessException {
        super(itemAction, typeName, objectName, objectSchema, description);
        this.m_definition = defn;
    }

    public XMLDocument getDefinition() {
        return this.m_definition;
    }

    public XMLDocument getOriginalDefinition() {
        XMLDocument defn = null;
        if (this.getItemAction() != 2) {
            defn = this.m_definition;
        } else if (this.sxmlSupported()) {
            XMLDocument origDefn = (XMLDocument)this.m_definition.cloneNode(true);
            DDLUtils.prepDiffDocForCreateDDL((XMLNode)origDefn, 1);
            defn = origDefn;
        } else {
            defn = this.m_origFullXML;
        }
        return defn;
    }

    public XMLDocument getRevisedDefinition() {
        XMLDocument defn = null;
        if (this.getItemAction() != 2) {
            defn = this.m_definition;
        } else {
            XMLDocument revisedDefn = (XMLDocument)this.m_definition.cloneNode(true);
            DDLUtils.prepDiffDocForCreateDDL((XMLNode)revisedDefn, 2);
            defn = revisedDefn;
        }
        return defn;
    }

    public ApplyOneDiffResult[] updateDefinition(XMLDocument revisedDefn, XMLAccessorClient client) throws ChangePlanAccessException {
        return this.updateDefinition(revisedDefn, client, null);
    }

    public ApplyOneDiffResult[] updateDefinition(XMLDocument revisedDefn, XMLAccessorClient client, ApplyDiffListener adl) throws ChangePlanAccessException {
        ApplyOneDiffResult[] results = null;
        if (this.getItemAction() == 2) {
            this.m_wasModify = true;
            if (this.hasModifications()) {
                if (this.sxmlSupported()) {
                    XMLDocument origDefn = this.getOriginalDefinition();
                    boolean hasDiffs = this.compareDocuments(origDefn, revisedDefn, client);
                    if (hasDiffs) {
                        XMLAccessor xa = null;
                        try {
                            xa = XMLAccessor.getXMLAccessorForType(this.getObjectTypeCode(), (XMLNode)this.m_definition);
                            xa.registerApplyDiffListener(adl);
                            results = xa.applyDiffs(revisedDefn);
                        }
                        catch (XMLAccessorException xae) {
                            throw new ChangePlanAccessException(10, "XMLAccessorException while applying diff:", xae);
                        }
                    }
                } else {
                    this.compareDocuments(this.getOriginalDefinition(), revisedDefn, client);
                }
            } else {
                this.initDefinition(this.m_definition, revisedDefn, client);
            }
        } else {
            this.m_definition = revisedDefn;
        }
        return results;
    }

    public void convertChangeItem(int newAction, XMLDocument revisedDefn, XMLAccessorClient client) throws ChangePlanAccessException {
        if (!this.newActionAllowed(newAction)) {
            throw new ChangePlanAccessException(9, "Cannot convert this " + this.getActionName(this.getItemAction()) + " change item to a " + this.getActionName(newAction) + " change item.");
        }
        int oldAction = this.getItemAction();
        if (oldAction == 2 && newAction == 4) {
            this.m_definition = this.getOriginalDefinition();
            this.m_wasModify = true;
        } else if (oldAction == 4 && newAction == 2) {
            XMLDocument origDefn = this.getOriginalDefinition();
            this.compareDocuments(origDefn, revisedDefn, client);
            if (this.sxmlSupported()) {
                this.m_definition = revisedDefn;
            } else {
                this.m_origFullXML = origDefn;
            }
        }
        this.setItemAction(newAction);
    }

    public boolean newActionAllowed(int newAction) {
        return this.getAllowedNewActions().contains(new Integer(newAction));
    }

    public Vector getAllowedNewActions() {
        Vector actions = null;
        switch (this.getItemAction()) {
            case 4: {
                actions = s_monitorActions;
                break;
            }
            case 1: {
                actions = s_addActions;
                break;
            }
            case 2: {
                actions = s_modifyActions;
                break;
            }
            case 3: {
                actions = this.getDefinition() != null ? s_dropWithDefnActions : s_dropWithNoDefnActions;
            }
        }
        return actions;
    }

    public String getDDL(XMLAccessorClient client) throws ChangePlanAccessException {
        if (client == null) {
            throw new ChangePlanAccessException(9, "getDDL() requires XMLAccessorClient to be supplied.");
        }
        XMLDocument defn = this.getDefinition();
        String ddl = null;
        if (defn == null) {
            throw new ChangePlanAccessException(9, "Cannot generate DDL for " + this.getActionName(this.getItemAction()) + " that has no definition.");
        }
        try {
            XMLAccessor xa = XMLAccessor.getXMLAccessorForType(this.getObjectTypeCode(), (XMLNode)defn, client);
            switch (this.getItemAction()) {
                case 1: 
                case 4: {
                    ddl = xa.getDDL(2);
                    break;
                }
                case 2: {
                    ddl = xa.getDDL(3);
                    break;
                }
                case 3: {
                    ddl = xa.getDDL(5);
                }
            }
        }
        catch (XMLAccessorException xae) {
            throw new ChangePlanAccessException(10, "XMLAccessorException while getting DDL:", xae);
        }
        return ddl;
    }

    protected void initDefinition(XMLDocument origDefn, XMLDocument revisedDefn, XMLAccessorClient client) throws ChangePlanAccessException {
        if (origDefn == null && this.getItemAction() != 3) {
            throw new ChangePlanAccessException(8, "An original definition must be supplied for Add and Modify change items.");
        }
        if (revisedDefn == null || this.getItemAction() != 2) {
            this.m_definition = origDefn;
        } else {
            boolean hasDiffs = this.compareDocuments(origDefn, revisedDefn, client);
            if (this.sxmlSupported()) {
                this.m_definition = revisedDefn;
            } else {
                this.m_origFullXML = origDefn;
            }
        }
    }

    void setAdditionalInfo(String addnlInfo) {
        this.m_addnlInfo = addnlInfo;
    }

    String getAdditionalInfo() {
        return this.m_addnlInfo;
    }

    void setChangePlan(ChangePlan plan) {
        this.m_plan = plan;
    }

    XMLDocument getOriginalFullXML() {
        return this.m_origFullXML;
    }

    void setOriginalFullXML(XMLDocument xmlDoc) {
        this.m_origFullXML = xmlDoc;
    }

    boolean updateFullXML() {
        return !this.sxmlSupported() && this.getItemAction() == 2 && !this.m_wasModify;
    }

    @Override
    public String toString() {
        String defn = null;
        if (this.m_definition != null) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            try {
                this.m_definition.print((OutputStream)bs);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            defn = bs.toString();
        }
        if (defn != null) {
            return super.toString() + "\n  Client source DB: " + this.getClientSourceDatabase() + "\n  EM source DB: " + this.getEntMgrSourceDatabase() + "\n  Global source DB: " + this.getGlobalSourceDatabase() + "\n  Definition:\n" + defn;
        }
        return super.toString() + "\n  Client source DB: " + this.getClientSourceDatabase() + "\n  EM source DB: " + this.getEntMgrSourceDatabase() + "\n  Global source DB: " + this.getGlobalSourceDatabase();
    }

    private boolean hasModifications() throws ChangePlanAccessException {
        boolean hasMods = false;
        if (this.getItemAction() == 2) {
            XMLDocument doc = this.getDefinition();
            if (this.sxmlSupported()) {
                NodeList diffNodes = null;
                try {
                    diffNodes = doc.selectNodes("(//*[@src='1' and not (@no_diff)] | //*[@src='2' and not (@no_diff)] | //*[@value1 and not (@no_diff)])", (NSResolver)CMXMLUtils.getSXMLResolver());
                }
                catch (XSLException xse) {
                    throw new ChangePlanAccessException(10, "XSLException while getting diffs:", xse);
                }
                hasMods = diffNodes != null && diffNodes.getLength() > 0;
            } else {
                NodeList ddls = doc.getElementsByTagName("MDAPIDDL");
                hasMods = ddls != null && ddls.getLength() > 0;
            }
        }
        return hasMods;
    }

    private boolean compareDocuments(XMLDocument origDefn, XMLDocument revisedDefn, XMLAccessorClient client) throws ChangePlanAccessException {
        if (client == null) {
            throw new ChangePlanAccessException(9, "compareDocuments() requires XMLAccessorClient.");
        }
        boolean hasDiffs = false;
        try {
            XMLAccessor xa = XMLAccessor.getXMLAccessorForType(this.getObjectTypeCode(), (XMLNode)origDefn, client);
            hasDiffs = xa.compareDefinition(revisedDefn, true);
            if (!this.sxmlSupported()) {
                this.m_definition = xa.getDifferencesDocument();
            }
        }
        catch (XMLAccessorException xae) {
            throw new ChangePlanAccessException(10, "XMLAccessorException while comparing documents:", xae);
        }
        return hasDiffs;
    }

    boolean sxmlSupported() {
        return XMLAccessor.sxmlSupported(this.getObjectTypeCode());
    }

    static {
        s_monitorActions.add(CP_MODIFY_INTEGER);
        s_monitorActions.add(CP_DROP_INTEGER);
        s_modifyActions.add(CP_MONITOR_INTEGER);
        s_dropWithDefnActions.add(CP_MONITOR_INTEGER);
    }
}

