/*
 * Decompiled with CFR 0.152.
 */
package oracle.viz.util.svg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Vector;
import oracle.viz.util.svg.internal.ATag;
import oracle.viz.util.svg.internal.ATagEnd;
import oracle.viz.util.svg.internal.SVGImage;
import oracle.viz.util.svg.internal.SVGShape;
import oracle.viz.util.svg.internal.SVGText;
import oracle.viz.util.svg.internal.TagGroup;
import oracle.viz.util.svg.internal.TagGroupEnd;
import oracle.viz.util.svg.internal.Util;

public class SVGGraphics
extends Graphics2D {
    public static final RenderingHints.Key IMAGE_SOURCE = new SVGKey(0){

        public boolean isCompatibleValue(Object v) {
            return v instanceof String;
        }
    };
    public static final RenderingHints.Key SVG_PRIMITIVE_ID = new SVGKey(1){

        public boolean isCompatibleValue(Object v) {
            return v instanceof String;
        }
    };
    public static final RenderingHints.Key USER_SCRIPT = new SVGKey(2){

        public boolean isCompatibleValue(Object v) {
            return v instanceof String;
        }
    };
    public static final RenderingHints.Key XCOORDS = new SVGKey(3){

        public boolean isCompatibleValue(Object v) {
            return v instanceof double[];
        }
    };
    public static final RenderingHints.Key YCOORDS = new SVGKey(4){

        public boolean isCompatibleValue(Object v) {
            return v instanceof double[];
        }
    };
    protected Graphics2D buffer;
    protected Vector SVGElement = new Vector();
    protected String xmlHeader_start = "<?xml version=\"1.0\" encoding=";
    protected String xmlEncoding = "UTF-8";
    protected String xmlHeader = null;
    protected String xmlNameSpace = "xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"";
    protected String xmlDocType = "<!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 1.0//EN' 'http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd'>";
    protected String svgHeader;
    protected String svgTrailer = "</svg>\n";
    protected String svgDefsHeader = "<defs>\n";
    protected String svgDefsTrailer = "</defs>";
    protected String svgDefsBody = "";
    protected String svgDefsBodyInternal = "";
    protected String copyrightString = "\n<!-- Copyright (c) 1996, 2005, Oracle. All rights reserved. -->\n";
    protected TagGroup elementsGroupStart;
    protected TagGroupEnd elementsGroupEnd;
    protected String imageSource = null;
    protected String svgPrimitiveID = null;
    protected String userScript = null;
    protected int indent = 0;
    protected int IndentSpaces = 1;
    protected int documentHeight = 100;
    protected int documentWidth = 100;
    protected float strokeWidth = 1.0f;
    boolean interactiveSVG = false;
    public static final int AXISCHART = 0;
    public static final int GANTTCHART = 1;
    int chartType = 0;
    int SliderX = 0;
    int SliderY = 0;
    int SliderWidth = 0;
    int SliderKnobWidth = 13;
    int SliderHeight = this.SliderKnobWidth + 2;
    String SliderObjectName = "cb_coords";
    float[] dashArray;
    float dashPhase;
    double[] xCoords;
    double[] yCoords;

    public SVGGraphics() {
        this(null);
    }

    public SVGGraphics(Graphics2D g) {
        this.buffer = g;
        this.elementsGroupStart = new TagGroup();
        this.elementsGroupEnd = new TagGroupEnd();
    }

    public Graphics2D getGraphicsBuffer() {
        return this.buffer;
    }

    public void setGraphicsBuffer(Graphics2D g) {
        this.buffer = g;
    }

    public void setInteractiveSVG(boolean enable) {
        this.interactiveSVG = enable;
    }

    public boolean getInteractiveSVG() {
        return this.interactiveSVG;
    }

    public void setChartType(int type) {
        this.chartType = type;
    }

    public char[] getSVG() {
        return this.getXMLDocument();
    }

    public char[] getXMLDocument() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.getXMLHeader());
        sbuf.append(this.getXMLDocType());
        sbuf.append("\n");
        sbuf.append(this.getDocumentFragment());
        return sbuf.toString().toCharArray();
    }

    public void setSliderPosition(int x, int y, int width) {
        this.SliderX = x;
        this.SliderY = y;
        this.SliderWidth = width;
    }

    public char[] getDocumentFragment() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.getSVGHeader());
        sbuf.append("\n");
        sbuf.append(this.getSVGDefinitions());
        sbuf.append("\n");
        if (!this.interactiveSVG) {
            sbuf.append(this.getSVGElements());
        }
        if (this.interactiveSVG) {
            if (this.chartType == 1) {
                sbuf.append("\n");
                sbuf.append(this.getUseXLink("#cb_chart"));
                sbuf.append(this.getUseXLink("#cb_tasklabels"));
                sbuf.append(this.getUseXLink("#cb_chartstatic"));
                sbuf.append(this.getUseXLink("#cb_axislabels"));
                sbuf.append(this.getUseXLinkClip("#" + this.SliderObjectName, "#cb_plotWindowClip"));
                sbuf.append("\n");
                sbuf.append(this.getSlider(this.SliderX, this.SliderY, this.SliderWidth));
            } else {
                sbuf.append("\n");
                sbuf.append(this.getUseXLink("#cb_chart"));
                sbuf.append(this.getUseXLink("#cb_frameoutline"));
                sbuf.append(this.getUseXLink("#cb_plotoutline"));
                sbuf.append(this.getUseXLinkClip("#cb_xaxis", "#cb_XAxisClip"));
                sbuf.append(this.getUseXLinkClip("#cb_yaxis", "#cb_YAxisClip"));
                sbuf.append(this.getUseXLink("#cb_titles"));
                sbuf.append(this.getUseXLink("#cb_legend"));
                sbuf.append(this.getUseXLinkClip("#" + this.SliderObjectName, "#cb_plotWindowClip"));
                sbuf.append("\n");
                sbuf.append(this.getSlider(this.SliderX, this.SliderY, this.SliderWidth));
            }
        }
        sbuf.append(this.getSVGTrailer());
        return sbuf.toString().toCharArray();
    }

    public String getUseXLink(String tag) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<use xlink:href=");
        sbuf.append("\"" + tag + "\"");
        sbuf.append(" />");
        sbuf.append("\n");
        return sbuf.toString();
    }

    public String getUseXLinkClip(String tag, String tag2) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<use xlink:href=");
        sbuf.append("\"" + tag + "\"");
        sbuf.append(" style=\"clip-path: url(" + tag2 + ");\"");
        sbuf.append(" />");
        sbuf.append("\n");
        return sbuf.toString();
    }

    public String getSlider(int x, int y, int width) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\n");
        sbuf.append("<g id=\"slider\" transform=\"translate(" + x + " " + (y - this.SliderKnobWidth) + ")\" xoffset=\"" + x + "\">");
        sbuf.append("\n");
        sbuf.append(" <rect x=\"0\" y=\"0\" width=\"" + width + "\" height=\"" + this.SliderHeight + "\" style=\"fill:#e0e0ff\" />");
        sbuf.append("\n");
        sbuf.append(" <line style=\"stroke:#c0c0c0;stroke-width:1;\" x1=\"1\" y1=\"" + this.SliderHeight + "\" x2=\"" + width + "\" y2=\"" + this.SliderHeight + "\" />");
        sbuf.append("\n");
        sbuf.append(" <g id=\"knob\" transform=\"translate(0 0)\">");
        sbuf.append("\n");
        sbuf.append("  <rect x=\"0\" y=\"0\" width=\"" + this.SliderKnobWidth + "\" height=\"" + this.SliderKnobWidth + "\" style=\"fill:#a0a0f0\" />");
        sbuf.append("\n");
        sbuf.append("  <path style=\"stroke:white;fill:none;\" d=\"M " + this.SliderKnobWidth + ",1 1,1 1," + this.SliderKnobWidth + "\" />");
        sbuf.append("\n");
        sbuf.append("  <path style=\"stroke:#404040;fill:none;\" d=\"M 1," + this.SliderKnobWidth + " " + this.SliderKnobWidth + "," + this.SliderKnobWidth + " " + this.SliderKnobWidth + ",1\" />");
        sbuf.append("\n");
        sbuf.append(" </g>\n");
        sbuf.append("</g>");
        sbuf.append("\n");
        return sbuf.toString();
    }

    public void setSliderObjectName(String name) {
        this.SliderObjectName = name;
    }

    public String getSliderScript(int width) {
        int w = width - this.SliderKnobWidth;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<script type=\"text/ecmascript\">\n");
        sbuf.append("<![CDATA[\n\n");
        sbuf.append("var " + this.SliderObjectName + "=null\n");
        sbuf.append("var cb_chart=null, cb_xaxis=null, slider=null, knob=null, sliderActive = false\n\n");
        sbuf.append("function SliderDown(event) { sliderActive = true; }\n\n");
        sbuf.append("function SliderUp(event) {\n");
        sbuf.append("   sliderActive = false;\n");
        sbuf.append("   window.status = \"slider is inactive\";\n");
        sbuf.append("}\n\n");
        sbuf.append("function SliderMove(event) {\n");
        sbuf.append("   var value = event.getClientX() - parseFloat(slider.getAttribute(\"xoffset\"));\n");
        sbuf.append("   if (sliderActive && value > 0 && value < " + w + ") {\n");
        sbuf.append("      knob.setAttribute(\"transform\", \"translate(\" + (value) + \" 0)\");\n");
        sbuf.append("      SliderCallback(value);\n");
        sbuf.append("   }}\n\n");
        sbuf.append("function SliderClick(event) {\n");
        sbuf.append("   var value = event.getClientX() - parseFloat(slider.getAttribute(\"xoffset\"));\n");
        sbuf.append("   if (value > 0 && value < " + w + ") {\n");
        sbuf.append("      knob.setAttribute(\"transform\", \"translate(\" + (value) + \" 0)\");\n");
        sbuf.append("      SliderCallback(value);\n");
        sbuf.append("   }}\n\n");
        sbuf.append("function SliderCallback(val) {\n");
        sbuf.append("   " + this.SliderObjectName + ".setAttribute(\"transform\", \"translate(\" + val * 2 + \", 0)\" );\n");
        sbuf.append("   cb_xaxis.setAttribute(\"transform\", \"translate(\" + val * 2 + \", 0)\" );\n");
        sbuf.append("}\n");
        sbuf.append("function OnLoadEvent(event) {\n");
        sbuf.append("   var doc = event.getTarget() != null ? event.getTarget().getOwnerDocument() : null;\n");
        sbuf.append("   if (doc != null) {\n");
        sbuf.append("      slider = doc.getElementById(\"slider\");\n");
        sbuf.append("      knob = doc.getElementById(\"knob\");\n");
        sbuf.append("      cb_chart = doc.getElementById(\"cb_chart\");\n");
        sbuf.append("      " + this.SliderObjectName + " = doc.getElementById(\"" + this.SliderObjectName + "\");\n");
        sbuf.append("      cb_xaxis = doc.getElementById(\"cb_xaxis\");\n");
        sbuf.append("      slider.addEventListener(\"mousedown\", SliderDown, false);\n");
        sbuf.append("      slider.addEventListener(\"mouseup\", SliderUp, false);\n");
        sbuf.append("      slider.addEventListener(\"mousemove\", SliderMove, false);\n");
        sbuf.append("      slider.addEventListener(\"click\", SliderClick, false);\n");
        sbuf.append("   }}\n\n");
        sbuf.append("]]></script>\n");
        return sbuf.toString();
    }

    public char[] getSVGElements() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.copyrightString);
        if (!this.interactiveSVG) {
            sbuf.append(this.elementsGroupStart.getSVG());
        }
        int i = 0;
        while (i < this.SVGElement.size()) {
            sbuf.append(this.getSVGCommand(i));
            ++i;
        }
        if (!this.interactiveSVG) {
            sbuf.append(this.elementsGroupEnd.getSVG());
        }
        return sbuf.toString().toCharArray();
    }

    public void clearSVG() {
        this.SVGElement.clear();
    }

    private String getSVGCommand(int index) {
        StringBuffer sbuf = new StringBuffer();
        if (this.SVGElement.elementAt(index) instanceof SVGShape) {
            sbuf.append(this.indentLine(this.indent));
            SVGShape E = (SVGShape)this.SVGElement.elementAt(index);
            sbuf.append(E.getSVG());
        } else if (this.SVGElement.elementAt(index) instanceof SVGImage) {
            sbuf.append(this.indentLine(this.indent));
            SVGImage E = (SVGImage)this.SVGElement.elementAt(index);
            sbuf.append(E.getSVG());
        } else if (this.SVGElement.elementAt(index) instanceof SVGText) {
            sbuf.append(this.indentLine(this.indent));
            SVGText txt = (SVGText)this.SVGElement.elementAt(index);
            sbuf.append(txt.getSVG());
        } else if (this.SVGElement.elementAt(index) instanceof ATag) {
            sbuf.append(this.indentLine(this.indent));
            ATag A = (ATag)this.SVGElement.elementAt(index);
            sbuf.append(A.getSVG());
            this.indent += this.IndentSpaces;
        } else if (this.SVGElement.elementAt(index) instanceof ATagEnd) {
            this.indent -= this.IndentSpaces;
            sbuf.append(this.indentLine(this.indent));
            ATagEnd A = (ATagEnd)this.SVGElement.elementAt(index);
            sbuf.append(A.getSVG());
        } else if (this.SVGElement.elementAt(index) instanceof TagGroup) {
            sbuf.append(this.indentLine(this.indent));
            TagGroup A = (TagGroup)this.SVGElement.elementAt(index);
            sbuf.append(A.getSVG());
            this.indent += this.IndentSpaces;
        } else if (this.SVGElement.elementAt(index) instanceof TagGroupEnd) {
            this.indent -= this.IndentSpaces;
            sbuf.append(this.indentLine(this.indent));
            TagGroupEnd A = (TagGroupEnd)this.SVGElement.elementAt(index);
            sbuf.append(A.getSVG());
        } else {
            System.out.println("No command! (" + this.SVGElement.elementAt(index) + ")");
        }
        return sbuf.toString();
    }

    private String getSVGXMLHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.getXMLHeader());
        sbuf.append(this.getXMLDocType());
        sbuf.append("\n");
        sbuf.append(this.getSVGHeader());
        sbuf.append("\n");
        sbuf.append(this.getSVGDefinitions());
        return sbuf.toString();
    }

    private String indentLine(int indent) {
        StringBuffer sbuf = new StringBuffer();
        int j = 0;
        while (j < indent) {
            sbuf.append(" ");
            ++j;
        }
        return sbuf.toString();
    }

    public void setDocumentSize(int width, int height) {
        this.documentWidth = width;
        this.documentHeight = height;
    }

    public void setSVGHeader(String svgHeader) {
        this.svgHeader = svgHeader;
    }

    public String getSVGHeader() {
        if (this.svgHeader == null) {
            StringBuffer sbuf = new StringBuffer("<svg ");
            sbuf.append(this.xmlNameSpace).append(" width=\"");
            sbuf.append(Integer.toString(this.documentWidth)).append("\"").append(" height=\"");
            sbuf.append(Integer.toString(this.documentHeight));
            sbuf.append("\"");
            if (this.interactiveSVG) {
                sbuf.append(" onload=\"OnLoadEvent(evt)\"");
            }
            sbuf.append(">");
            return sbuf.toString();
        }
        return this.svgHeader;
    }

    public String getXMLEncoding() {
        return this.xmlEncoding;
    }

    public void setXMLEncoding(String encoding) {
        this.xmlEncoding = encoding;
        this.xmlHeader = null;
    }

    public String getXMLHeader() {
        if (this.xmlHeader == null) {
            StringBuffer xmlHeadBuf = new StringBuffer(this.xmlHeader_start);
            xmlHeadBuf.append("\"").append(this.xmlEncoding).append("\"?>\n");
            this.xmlHeader = xmlHeadBuf.toString();
        }
        return this.xmlHeader;
    }

    public String getXMLDocType() {
        return this.xmlDocType;
    }

    public String getSVGTrailer() {
        return this.svgTrailer;
    }

    public void setSVGDefinitions(String svgDefs) {
        this.svgDefsBody = svgDefs;
    }

    public void setSVGDefinitionsInternal(String svgDefs) {
        this.svgDefsBodyInternal = svgDefs;
    }

    public String getSVGDefinitions() {
        StringBuffer sbuf = new StringBuffer(this.svgDefsHeader);
        sbuf.append(this.svgDefsBodyInternal);
        if (this.interactiveSVG) {
            sbuf.append(this.getSVGElements());
            sbuf.append(this.getSliderScript(this.SliderWidth));
        }
        sbuf.append(this.svgDefsBody).append(this.svgDefsTrailer);
        return sbuf.toString();
    }

    public String getSVGDefinitionsInternal() {
        return this.svgDefsBodyInternal;
    }

    public void setElementsStartGroup(String id, String onMouseClick, String onMouseDown, String onMouseMove, String onMouseOut, String onMouseOver, String onMouseUp, String display, String transform) {
        TagGroup grp = this.elementsGroupStart;
        grp.setID(id);
        grp.setOnMouseClick(onMouseClick);
        grp.setOnMouseDown(onMouseDown);
        grp.setOnMouseMove(onMouseMove);
        grp.setOnMouseOut(onMouseOut);
        grp.setOnMouseOver(onMouseOver);
        grp.setOnMouseUp(onMouseUp);
        grp.setDisplay(display);
        grp.setTransform(transform);
    }

    public void startGroup(String id, String onMouseClick, String onMouseDown, String onMouseMove, String onMouseOut, String onMouseOver, String onMouseUp, String display, String transform) {
        TagGroup grp = new TagGroup();
        if (id != null) {
            grp.setID(id);
        }
        grp.setOnMouseClick(onMouseClick);
        grp.setOnMouseDown(onMouseDown);
        grp.setOnMouseMove(onMouseMove);
        grp.setOnMouseOut(onMouseOut);
        grp.setOnMouseOver(onMouseOver);
        grp.setOnMouseUp(onMouseUp);
        grp.setDisplay(display);
        grp.setTransform(transform);
        this.SVGElement.addElement(grp);
    }

    public void startGroup(String id, String onMouseClick, String onMouseDown, String onMouseMove, String onMouseOut, String onMouseOver, String onMouseUp, String display) {
        this.startGroup(id, onMouseClick, onMouseDown, onMouseMove, onMouseOut, onMouseOver, onMouseUp, display, null);
    }

    public void startGroup(String id, String onMouseClick, String onMouseDown, String onMouseMove, String onMouseOut, String onMouseOver, String onMouseUp) {
        this.startGroup(id, onMouseClick, onMouseDown, onMouseMove, onMouseOut, onMouseOver, onMouseUp, null, null);
    }

    public void startGroup(String id) {
        TagGroup grp = new TagGroup();
        if (id != null) {
            grp.setID(id);
        }
        this.SVGElement.addElement(grp);
    }

    public void endGroup() {
        this.SVGElement.addElement(new TagGroupEnd());
    }

    public void drawRectInvisible(String id, int x, int y, long width, long height) {
        SVGShape s = new SVGShape();
        s.drawRectInvisible(id, x, y, width, height);
        this.SVGElement.addElement(s);
    }

    public void fillRectInvisible(int x, int y, int width, int height) {
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        s.fillRectInvisible(this.userScript, this.svgPrimitiveID, x, y, width, height, cString, oString);
        this.svgPrimitiveID = null;
        this.userScript = null;
        this.SVGElement.addElement(s);
    }

    public void draw(Shape s) {
        this.buffer.draw(s);
        SVGShape svgShape = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        svgShape.draw(this.userScript, s, cString, oString);
        this.userScript = null;
        this.svgPrimitiveID = null;
        this.SVGElement.addElement(svgShape);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.buffer.drawImage(img, xform, obs);
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.buffer.drawImage(img, op, x, y);
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.buffer.drawRenderedImage(img, xform);
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.buffer.drawRenderableImage(img, xform);
    }

    public void drawString(String str, int x, int y) {
        this.buffer.drawString(str, x, y);
        SVGText txt = new SVGText();
        if (this.userScript != null) {
            txt.setUserScript(this.userScript);
        }
        txt.setText(str);
        txt.setLocation(x, y);
        txt.setFill(this.getColor());
        Font f = this.getFont();
        txt.setFontFamily(f.getName());
        txt.setFontSize(f.getSize());
        txt.setFontStyle(f.getStyle());
        AffineTransform trans = this.getTransform();
        double[] matrix = new double[6];
        trans.getMatrix(matrix);
        txt.setTransformMatrix(matrix);
        this.SVGElement.addElement(txt);
        this.userScript = null;
        this.svgPrimitiveID = null;
    }

    public void drawString(String s, float x, float y) {
        this.drawString(s, Math.round(x), Math.round(y));
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        FontRenderContext frc = this.getFontRenderContext();
        TextLayout tl = new TextLayout(iterator, frc);
        tl.draw(this, x, y);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        FontRenderContext frc = this.getFontRenderContext();
        TextLayout tl = new TextLayout(iterator, frc);
        tl.draw(this, x, y);
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.buffer.drawGlyphVector(g, x, y);
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        s.fill(this.userScript, this.svgPrimitiveID, g.getOutline(x, y), cString, oString);
        this.userScript = null;
        this.svgPrimitiveID = null;
        AffineTransform trans = this.getTransform();
        if (!trans.isIdentity()) {
            double[] matrix = new double[6];
            trans.getMatrix(matrix);
            s.setTransformMatrix(matrix);
        }
        this.SVGElement.addElement(s);
    }

    public void fill(Shape s) {
        this.buffer.fill(s);
        SVGShape svgShape = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        svgShape.fill(this.userScript, this.svgPrimitiveID, s, cString, oString);
        this.userScript = null;
        this.svgPrimitiveID = null;
        this.SVGElement.addElement(svgShape);
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.buffer.hit(rect, s, onStroke);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.buffer.getDeviceConfiguration();
    }

    public void setComposite(Composite comp) {
        this.buffer.setComposite(comp);
    }

    public void setPaint(Paint paint) {
        this.buffer.setPaint(paint);
    }

    public void setStroke(Stroke stroke) {
        this.buffer.setStroke(stroke);
        this.strokeWidth = ((BasicStroke)stroke).getLineWidth();
        this.dashArray = ((BasicStroke)stroke).getDashArray();
        this.dashPhase = ((BasicStroke)stroke).getDashPhase();
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        if (hintKey == IMAGE_SOURCE) {
            this.imageSource = (String)hintValue;
        } else if (hintKey == SVG_PRIMITIVE_ID) {
            this.svgPrimitiveID = (String)hintValue;
        } else if (hintKey == USER_SCRIPT) {
            this.userScript = (String)hintValue;
        } else if (hintKey == XCOORDS) {
            this.yCoords = (double[])hintValue;
        } else if (hintKey == YCOORDS) {
            this.yCoords = (double[])hintValue;
        }
        this.buffer.setRenderingHint(hintKey, hintValue);
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.buffer.getRenderingHint(hintKey);
    }

    public void setRenderingHints(Map hints) {
        double[] y;
        double[] x;
        String script;
        String rectID;
        String imgSrc = (String)hints.get(IMAGE_SOURCE);
        if (imgSrc != null) {
            this.imageSource = imgSrc;
        }
        if ((rectID = (String)hints.get(SVG_PRIMITIVE_ID)) != null) {
            this.svgPrimitiveID = rectID;
        }
        if ((script = (String)hints.get(USER_SCRIPT)) != null) {
            this.userScript = script;
        }
        if ((x = (double[])hints.get(XCOORDS)) != null) {
            this.xCoords = x;
        }
        if ((y = (double[])hints.get(YCOORDS)) != null) {
            this.yCoords = y;
        }
        this.buffer.setRenderingHints(hints);
    }

    public void addRenderingHints(Map hints) {
        this.buffer.addRenderingHints(hints);
    }

    public RenderingHints getRenderingHints() {
        return this.buffer.getRenderingHints();
    }

    public void translate(int x, int y) {
        this.buffer.translate(x, y);
    }

    public void translate(double tx, double ty) {
        this.buffer.translate(tx, ty);
    }

    public void rotate(double theta) {
        this.buffer.rotate(theta);
    }

    public void rotate(double theta, double x, double y) {
        this.buffer.rotate(theta, x, y);
    }

    public void scale(double sx, double sy) {
        this.buffer.scale(sx, sy);
    }

    public void shear(double shx, double shy) {
        this.buffer.shear(shx, shy);
    }

    public void transform(AffineTransform Tx) {
        this.buffer.transform(Tx);
    }

    public void setTransform(AffineTransform Tx) {
        this.buffer.setTransform(Tx);
    }

    public AffineTransform getTransform() {
        return this.buffer.getTransform();
    }

    public Paint getPaint() {
        return this.buffer.getPaint();
    }

    public Composite getComposite() {
        return this.buffer.getComposite();
    }

    public void setBackground(Color color) {
        this.buffer.setBackground(color);
    }

    public Color getBackground() {
        return this.buffer.getBackground();
    }

    public Stroke getStroke() {
        return this.buffer.getStroke();
    }

    public void clip(Shape s) {
        this.buffer.clip(s);
    }

    public FontRenderContext getFontRenderContext() {
        return this.buffer.getFontRenderContext();
    }

    public Graphics create() {
        return this.buffer.create();
    }

    public Color getColor() {
        return this.buffer.getColor();
    }

    public void setColor(Color c) {
        this.buffer.setColor(c);
    }

    public void setPaintMode() {
        this.buffer.setPaintMode();
    }

    public void setXORMode(Color c1) {
        this.buffer.setXORMode(c1);
    }

    public Font getFont() {
        return this.buffer.getFont();
    }

    public void setFont(Font font) {
        this.buffer.setFont(font);
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.buffer.getFontMetrics(f);
    }

    public Rectangle getClipBounds() {
        return this.buffer.getClipBounds();
    }

    public void clipRect(int x, int y, int width, int height) {
        this.buffer.clipRect(x, y, width, height);
    }

    public void setClip(int x, int y, int width, int height) {
        this.buffer.setClip(x, y, width, height);
    }

    public Shape getClip() {
        return this.buffer.getClip();
    }

    public void setClip(Shape clip) {
        this.buffer.setClip(clip);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.buffer.copyArea(x, y, width, height, dx, dy);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.buffer.drawLine(x1, y1, x2, y2);
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        s.drawLine(x1, y1, x2, y2, cString, oString, this.strokeWidth, this.dashArray, this.dashPhase);
        this.SVGElement.addElement(s);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.buffer.drawRect(x, y, width, height);
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        s.drawRect(x, y, width, height, cString, oString);
        this.SVGElement.addElement(s);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.buffer.fillRect(x, y, width, height);
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        s.fillRect(this.userScript, this.svgPrimitiveID, x, y, width, height, cString, oString);
        this.svgPrimitiveID = null;
        this.userScript = null;
        this.SVGElement.addElement(s);
    }

    public void drawOutlinedRect(int x, int y, int width, int height, Color outlineColor) {
        Color saveColor = this.buffer.getColor();
        this.buffer.fillRect(x, y, width, height);
        this.buffer.setColor(outlineColor);
        this.buffer.drawRect(x, y, width - 1, height - 1);
        this.buffer.setColor(saveColor);
        SVGShape s = new SVGShape();
        String innerColor = Util.colorToString(saveColor);
        String outlineColorStr = Util.colorToString(outlineColor);
        String innerOString = Util.opacityToString(saveColor);
        String outlineOString = Util.opacityToString(outlineColor);
        s.drawOutlinedRect(x, y, width, height, innerColor, outlineColorStr, innerOString, outlineOString);
        this.SVGElement.addElement(s);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.buffer.clearRect(x, y, width, height);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.buffer.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        s.drawRoundRect(x, y, width, height, arcWidth, arcHeight, cString, oString);
        this.SVGElement.addElement(s);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.buffer.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        s.fillRoundRect(x, y, width, height, arcWidth, arcHeight, cString, oString);
        this.SVGElement.addElement(s);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.buffer.drawOval(x, y, width, height);
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        s.drawOval(x, y, width, height, cString, oString, this.strokeWidth);
        this.SVGElement.addElement(s);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.buffer.fillOval(x, y, width, height);
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        s.fillOval(x, y, width, height, cString, oString);
        this.SVGElement.addElement(s);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.buffer.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.buffer.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.buffer.drawPolyline(xPoints, yPoints, nPoints);
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        if (this.yCoords != null) {
            s.drawPolyline(this.userScript, this.svgPrimitiveID, this.xCoords, this.yCoords, xPoints, yPoints, nPoints, cString, oString, this.strokeWidth);
        } else {
            s.drawPolyline(this.userScript, this.svgPrimitiveID, xPoints, yPoints, nPoints, cString, oString, this.strokeWidth);
        }
        this.svgPrimitiveID = null;
        this.userScript = null;
        this.xCoords = null;
        this.yCoords = null;
        this.SVGElement.addElement(s);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.buffer.drawPolygon(xPoints, yPoints, nPoints);
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        s.drawPolygon(xPoints, yPoints, nPoints, cString, oString);
        this.SVGElement.addElement(s);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.buffer.fillPolygon(xPoints, yPoints, nPoints);
        SVGShape s = new SVGShape();
        Color c = this.getColor();
        String cString = null;
        String oString = null;
        if (c != null) {
            cString = Util.colorToString(c);
            oString = Util.opacityToString(c);
        }
        s.fillPolygon(this.userScript, this.svgPrimitiveID, xPoints, yPoints, nPoints, cString, oString);
        this.svgPrimitiveID = null;
        this.userScript = null;
        this.SVGElement.addElement(s);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.buffer.drawImage(img, x, y, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.buffer.drawImage(img, x, y, width, height, observer);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.buffer.drawImage(img, x, y, bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.buffer.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        boolean retVal = this.buffer.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        SVGImage s = new SVGImage(this.imageSource, dx1, dy1, dx2 - dx1, dy2 - dy1);
        this.SVGElement.addElement(s);
        this.imageSource = null;
        return retVal;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.buffer.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    public void dispose() {
        this.buffer.dispose();
    }

    public static abstract class SVGKey
    extends RenderingHints.Key {
        SVGKey(int key) {
            super(key);
        }
    }
}

